/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.Quota;
import com.google.cloud.compute.v1.UsageExportLocation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Project
implements ApiMessage {
    private final Metadata commonInstanceMetadata;
    private final String creationTimestamp;
    private final String defaultServiceAccount;
    private final String description;
    private final List<String> enabledFeatures;
    private final String id;
    private final String kind;
    private final String name;
    private final List<Quota> quotas;
    private final String selfLink;
    private final UsageExportLocation usageExportLocation;
    private final String xpnProjectStatus;
    private static final Project DEFAULT_INSTANCE = new Project();

    private Project() {
        this.commonInstanceMetadata = null;
        this.creationTimestamp = null;
        this.defaultServiceAccount = null;
        this.description = null;
        this.enabledFeatures = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.quotas = null;
        this.selfLink = null;
        this.usageExportLocation = null;
        this.xpnProjectStatus = null;
    }

    private Project(Metadata commonInstanceMetadata, String creationTimestamp, String defaultServiceAccount, String description, List<String> enabledFeatures, String id, String kind, String name, List<Quota> quotas, String selfLink, UsageExportLocation usageExportLocation, String xpnProjectStatus) {
        this.commonInstanceMetadata = commonInstanceMetadata;
        this.creationTimestamp = creationTimestamp;
        this.defaultServiceAccount = defaultServiceAccount;
        this.description = description;
        this.enabledFeatures = enabledFeatures;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.quotas = quotas;
        this.selfLink = selfLink;
        this.usageExportLocation = usageExportLocation;
        this.xpnProjectStatus = xpnProjectStatus;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("commonInstanceMetadata")) {
            return this.commonInstanceMetadata;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("defaultServiceAccount")) {
            return this.defaultServiceAccount;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("enabledFeatures")) {
            return this.enabledFeatures;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("quotas")) {
            return this.quotas;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("usageExportLocation")) {
            return this.usageExportLocation;
        }
        if (fieldName.equals("xpnProjectStatus")) {
            return this.xpnProjectStatus;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Metadata getCommonInstanceMetadata() {
        return this.commonInstanceMetadata;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDefaultServiceAccount() {
        return this.defaultServiceAccount;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getEnabledFeaturesList() {
        return this.enabledFeatures;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<Quota> getQuotasList() {
        return this.quotas;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public UsageExportLocation getUsageExportLocation() {
        return this.usageExportLocation;
    }

    public String getXpnProjectStatus() {
        return this.xpnProjectStatus;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Project prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Project getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Project{commonInstanceMetadata=" + this.commonInstanceMetadata + ", creationTimestamp=" + this.creationTimestamp + ", defaultServiceAccount=" + this.defaultServiceAccount + ", description=" + this.description + ", enabledFeatures=" + this.enabledFeatures + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", quotas=" + this.quotas + ", selfLink=" + this.selfLink + ", usageExportLocation=" + this.usageExportLocation + ", xpnProjectStatus=" + this.xpnProjectStatus + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Project) {
            Project that = (Project)o;
            return Objects.equals(this.commonInstanceMetadata, that.getCommonInstanceMetadata()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.defaultServiceAccount, that.getDefaultServiceAccount()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.enabledFeatures, that.getEnabledFeaturesList()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.quotas, that.getQuotasList()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.usageExportLocation, that.getUsageExportLocation()) && Objects.equals(this.xpnProjectStatus, that.getXpnProjectStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.commonInstanceMetadata, this.creationTimestamp, this.defaultServiceAccount, this.description, this.enabledFeatures, this.id, this.kind, this.name, this.quotas, this.selfLink, this.usageExportLocation, this.xpnProjectStatus);
    }

    public static class Builder {
        private Metadata commonInstanceMetadata;
        private String creationTimestamp;
        private String defaultServiceAccount;
        private String description;
        private List<String> enabledFeatures;
        private String id;
        private String kind;
        private String name;
        private List<Quota> quotas;
        private String selfLink;
        private UsageExportLocation usageExportLocation;
        private String xpnProjectStatus;

        Builder() {
        }

        public Builder mergeFrom(Project other) {
            if (other == Project.getDefaultInstance()) {
                return this;
            }
            if (other.getCommonInstanceMetadata() != null) {
                this.commonInstanceMetadata = other.commonInstanceMetadata;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDefaultServiceAccount() != null) {
                this.defaultServiceAccount = other.defaultServiceAccount;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getEnabledFeaturesList() != null) {
                this.enabledFeatures = other.enabledFeatures;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getQuotasList() != null) {
                this.quotas = other.quotas;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getUsageExportLocation() != null) {
                this.usageExportLocation = other.usageExportLocation;
            }
            if (other.getXpnProjectStatus() != null) {
                this.xpnProjectStatus = other.xpnProjectStatus;
            }
            return this;
        }

        Builder(Project source) {
            this.commonInstanceMetadata = source.commonInstanceMetadata;
            this.creationTimestamp = source.creationTimestamp;
            this.defaultServiceAccount = source.defaultServiceAccount;
            this.description = source.description;
            this.enabledFeatures = source.enabledFeatures;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.quotas = source.quotas;
            this.selfLink = source.selfLink;
            this.usageExportLocation = source.usageExportLocation;
            this.xpnProjectStatus = source.xpnProjectStatus;
        }

        public Metadata getCommonInstanceMetadata() {
            return this.commonInstanceMetadata;
        }

        public Builder setCommonInstanceMetadata(Metadata commonInstanceMetadata) {
            this.commonInstanceMetadata = commonInstanceMetadata;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDefaultServiceAccount() {
            return this.defaultServiceAccount;
        }

        public Builder setDefaultServiceAccount(String defaultServiceAccount) {
            this.defaultServiceAccount = defaultServiceAccount;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<String> getEnabledFeaturesList() {
            return this.enabledFeatures;
        }

        public Builder addAllEnabledFeatures(List<String> enabledFeatures) {
            if (this.enabledFeatures == null) {
                this.enabledFeatures = new LinkedList<String>();
            }
            this.enabledFeatures.addAll(enabledFeatures);
            return this;
        }

        public Builder addEnabledFeatures(String enabledFeatures) {
            if (this.enabledFeatures == null) {
                this.enabledFeatures = new LinkedList<String>();
            }
            this.enabledFeatures.add(enabledFeatures);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<Quota> getQuotasList() {
            return this.quotas;
        }

        public Builder addAllQuotas(List<Quota> quotas) {
            if (this.quotas == null) {
                this.quotas = new LinkedList<Quota>();
            }
            this.quotas.addAll(quotas);
            return this;
        }

        public Builder addQuotas(Quota quotas) {
            if (this.quotas == null) {
                this.quotas = new LinkedList<Quota>();
            }
            this.quotas.add(quotas);
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public UsageExportLocation getUsageExportLocation() {
            return this.usageExportLocation;
        }

        public Builder setUsageExportLocation(UsageExportLocation usageExportLocation) {
            this.usageExportLocation = usageExportLocation;
            return this;
        }

        public String getXpnProjectStatus() {
            return this.xpnProjectStatus;
        }

        public Builder setXpnProjectStatus(String xpnProjectStatus) {
            this.xpnProjectStatus = xpnProjectStatus;
            return this;
        }

        public Project build() {
            return new Project(this.commonInstanceMetadata, this.creationTimestamp, this.defaultServiceAccount, this.description, this.enabledFeatures, this.id, this.kind, this.name, this.quotas, this.selfLink, this.usageExportLocation, this.xpnProjectStatus);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCommonInstanceMetadata(this.commonInstanceMetadata);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDefaultServiceAccount(this.defaultServiceAccount);
            newBuilder.setDescription(this.description);
            newBuilder.addAllEnabledFeatures(this.enabledFeatures);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllQuotas(this.quotas);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setUsageExportLocation(this.usageExportLocation);
            newBuilder.setXpnProjectStatus(this.xpnProjectStatus);
            return newBuilder;
        }
    }
}

