/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstancesHttpRequest;
import com.google.cloud.compute.v1.AttachDiskInstanceHttpRequest;
import com.google.cloud.compute.v1.DeleteAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceHttpRequest;
import com.google.cloud.compute.v1.DetachDiskInstanceHttpRequest;
import com.google.cloud.compute.v1.GetInstanceHttpRequest;
import com.google.cloud.compute.v1.GetSerialPortOutputInstanceHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceHttpRequest;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceAggregatedList;
import com.google.cloud.compute.v1.InstanceClient;
import com.google.cloud.compute.v1.InstanceList;
import com.google.cloud.compute.v1.InstanceListReferrers;
import com.google.cloud.compute.v1.InstancesScopedList;
import com.google.cloud.compute.v1.ListInstancesHttpRequest;
import com.google.cloud.compute.v1.ListReferrersInstancesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Reference;
import com.google.cloud.compute.v1.ResetInstanceHttpRequest;
import com.google.cloud.compute.v1.SerialPortOutput;
import com.google.cloud.compute.v1.SetDeletionProtectionInstanceHttpRequest;
import com.google.cloud.compute.v1.SetDiskAutoDeleteInstanceHttpRequest;
import com.google.cloud.compute.v1.SetLabelsInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMachineResourcesInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMachineTypeInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMetadataInstanceHttpRequest;
import com.google.cloud.compute.v1.SetMinCpuPlatformInstanceHttpRequest;
import com.google.cloud.compute.v1.SetSchedulingInstanceHttpRequest;
import com.google.cloud.compute.v1.SetServiceAccountInstanceHttpRequest;
import com.google.cloud.compute.v1.SetTagsInstanceHttpRequest;
import com.google.cloud.compute.v1.StartInstanceHttpRequest;
import com.google.cloud.compute.v1.StartWithEncryptionKeyInstanceHttpRequest;
import com.google.cloud.compute.v1.StopInstanceHttpRequest;
import com.google.cloud.compute.v1.UpdateAccessConfigInstanceHttpRequest;
import com.google.cloud.compute.v1.UpdateNetworkInterfaceInstanceHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceStub;
import com.google.cloud.compute.v1.stub.InstanceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InstanceStubSettings
extends StubSettings<InstanceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddAccessConfigInstanceHttpRequest, Operation> addAccessConfigInstanceSettings;
    private final PagedCallSettings<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse> aggregatedListInstancesSettings;
    private final UnaryCallSettings<AttachDiskInstanceHttpRequest, Operation> attachDiskInstanceSettings;
    private final UnaryCallSettings<DeleteInstanceHttpRequest, Operation> deleteInstanceSettings;
    private final UnaryCallSettings<DeleteAccessConfigInstanceHttpRequest, Operation> deleteAccessConfigInstanceSettings;
    private final UnaryCallSettings<DetachDiskInstanceHttpRequest, Operation> detachDiskInstanceSettings;
    private final UnaryCallSettings<GetInstanceHttpRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<GetSerialPortOutputInstanceHttpRequest, SerialPortOutput> getSerialPortOutputInstanceSettings;
    private final UnaryCallSettings<InsertInstanceHttpRequest, Operation> insertInstanceSettings;
    private final PagedCallSettings<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse> listInstancesSettings;
    private final PagedCallSettings<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse> listReferrersInstancesSettings;
    private final UnaryCallSettings<ResetInstanceHttpRequest, Operation> resetInstanceSettings;
    private final UnaryCallSettings<SetDeletionProtectionInstanceHttpRequest, Operation> setDeletionProtectionInstanceSettings;
    private final UnaryCallSettings<SetDiskAutoDeleteInstanceHttpRequest, Operation> setDiskAutoDeleteInstanceSettings;
    private final UnaryCallSettings<SetLabelsInstanceHttpRequest, Operation> setLabelsInstanceSettings;
    private final UnaryCallSettings<SetMachineResourcesInstanceHttpRequest, Operation> setMachineResourcesInstanceSettings;
    private final UnaryCallSettings<SetMachineTypeInstanceHttpRequest, Operation> setMachineTypeInstanceSettings;
    private final UnaryCallSettings<SetMetadataInstanceHttpRequest, Operation> setMetadataInstanceSettings;
    private final UnaryCallSettings<SetMinCpuPlatformInstanceHttpRequest, Operation> setMinCpuPlatformInstanceSettings;
    private final UnaryCallSettings<SetSchedulingInstanceHttpRequest, Operation> setSchedulingInstanceSettings;
    private final UnaryCallSettings<SetServiceAccountInstanceHttpRequest, Operation> setServiceAccountInstanceSettings;
    private final UnaryCallSettings<SetTagsInstanceHttpRequest, Operation> setTagsInstanceSettings;
    private final UnaryCallSettings<StartInstanceHttpRequest, Operation> startInstanceSettings;
    private final UnaryCallSettings<StartWithEncryptionKeyInstanceHttpRequest, Operation> startWithEncryptionKeyInstanceSettings;
    private final UnaryCallSettings<StopInstanceHttpRequest, Operation> stopInstanceSettings;
    private final UnaryCallSettings<UpdateAccessConfigInstanceHttpRequest, Operation> updateAccessConfigInstanceSettings;
    private final UnaryCallSettings<UpdateNetworkInterfaceInstanceHttpRequest, Operation> updateNetworkInterfaceInstanceSettings;
    private static final PagedListDescriptor<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList> AGGREGATED_LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstancesHttpRequest injectToken(AggregatedListInstancesHttpRequest payload, String token) {
            return AggregatedListInstancesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListInstancesHttpRequest injectPageSize(AggregatedListInstancesHttpRequest payload, int pageSize) {
            return AggregatedListInstancesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstancesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstancesScopedList> extractResources(InstanceAggregatedList payload) {
            return payload.getItemsMap().values();
        }
    };
    private static final PagedListDescriptor<ListInstancesHttpRequest, InstanceList, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesHttpRequest, InstanceList, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesHttpRequest injectToken(ListInstancesHttpRequest payload, String token) {
            return ListInstancesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstancesHttpRequest injectPageSize(ListInstancesHttpRequest payload, int pageSize) {
            return ListInstancesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(InstanceList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference> LIST_REFERRERS_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference>(){

        public String emptyToken() {
            return "";
        }

        public ListReferrersInstancesHttpRequest injectToken(ListReferrersInstancesHttpRequest payload, String token) {
            return ListReferrersInstancesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListReferrersInstancesHttpRequest injectPageSize(ListReferrersInstancesHttpRequest payload, int pageSize) {
            return ListReferrersInstancesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReferrersInstancesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceListReferrers payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reference> extractResources(InstanceListReferrers payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse> AGGREGATED_LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse>(){

        public ApiFuture<InstanceClient.AggregatedListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstancesHttpRequest, InstanceAggregatedList> callable, AggregatedListInstancesHttpRequest request, ApiCallContext context, ApiFuture<InstanceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceClient.AggregatedListInstancesPagedResponse.createAsync((PageContext<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstancesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse>(){

        public ApiFuture<InstanceClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesHttpRequest, InstanceList> callable, ListInstancesHttpRequest request, ApiCallContext context, ApiFuture<InstanceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesHttpRequest, InstanceList, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse> LIST_REFERRERS_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse>(){

        public ApiFuture<InstanceClient.ListReferrersInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListReferrersInstancesHttpRequest, InstanceListReferrers> callable, ListReferrersInstancesHttpRequest request, ApiCallContext context, ApiFuture<InstanceListReferrers> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REFERRERS_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceClient.ListReferrersInstancesPagedResponse.createAsync((PageContext<ListReferrersInstancesHttpRequest, InstanceListReferrers, Reference>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAccessConfigInstanceHttpRequest, Operation> addAccessConfigInstanceSettings() {
        return this.addAccessConfigInstanceSettings;
    }

    public PagedCallSettings<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse> aggregatedListInstancesSettings() {
        return this.aggregatedListInstancesSettings;
    }

    public UnaryCallSettings<AttachDiskInstanceHttpRequest, Operation> attachDiskInstanceSettings() {
        return this.attachDiskInstanceSettings;
    }

    public UnaryCallSettings<DeleteInstanceHttpRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public UnaryCallSettings<DeleteAccessConfigInstanceHttpRequest, Operation> deleteAccessConfigInstanceSettings() {
        return this.deleteAccessConfigInstanceSettings;
    }

    public UnaryCallSettings<DetachDiskInstanceHttpRequest, Operation> detachDiskInstanceSettings() {
        return this.detachDiskInstanceSettings;
    }

    public UnaryCallSettings<GetInstanceHttpRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<GetSerialPortOutputInstanceHttpRequest, SerialPortOutput> getSerialPortOutputInstanceSettings() {
        return this.getSerialPortOutputInstanceSettings;
    }

    public UnaryCallSettings<InsertInstanceHttpRequest, Operation> insertInstanceSettings() {
        return this.insertInstanceSettings;
    }

    public PagedCallSettings<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public PagedCallSettings<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse> listReferrersInstancesSettings() {
        return this.listReferrersInstancesSettings;
    }

    public UnaryCallSettings<ResetInstanceHttpRequest, Operation> resetInstanceSettings() {
        return this.resetInstanceSettings;
    }

    public UnaryCallSettings<SetDeletionProtectionInstanceHttpRequest, Operation> setDeletionProtectionInstanceSettings() {
        return this.setDeletionProtectionInstanceSettings;
    }

    public UnaryCallSettings<SetDiskAutoDeleteInstanceHttpRequest, Operation> setDiskAutoDeleteInstanceSettings() {
        return this.setDiskAutoDeleteInstanceSettings;
    }

    public UnaryCallSettings<SetLabelsInstanceHttpRequest, Operation> setLabelsInstanceSettings() {
        return this.setLabelsInstanceSettings;
    }

    public UnaryCallSettings<SetMachineResourcesInstanceHttpRequest, Operation> setMachineResourcesInstanceSettings() {
        return this.setMachineResourcesInstanceSettings;
    }

    public UnaryCallSettings<SetMachineTypeInstanceHttpRequest, Operation> setMachineTypeInstanceSettings() {
        return this.setMachineTypeInstanceSettings;
    }

    public UnaryCallSettings<SetMetadataInstanceHttpRequest, Operation> setMetadataInstanceSettings() {
        return this.setMetadataInstanceSettings;
    }

    public UnaryCallSettings<SetMinCpuPlatformInstanceHttpRequest, Operation> setMinCpuPlatformInstanceSettings() {
        return this.setMinCpuPlatformInstanceSettings;
    }

    public UnaryCallSettings<SetSchedulingInstanceHttpRequest, Operation> setSchedulingInstanceSettings() {
        return this.setSchedulingInstanceSettings;
    }

    public UnaryCallSettings<SetServiceAccountInstanceHttpRequest, Operation> setServiceAccountInstanceSettings() {
        return this.setServiceAccountInstanceSettings;
    }

    public UnaryCallSettings<SetTagsInstanceHttpRequest, Operation> setTagsInstanceSettings() {
        return this.setTagsInstanceSettings;
    }

    public UnaryCallSettings<StartInstanceHttpRequest, Operation> startInstanceSettings() {
        return this.startInstanceSettings;
    }

    public UnaryCallSettings<StartWithEncryptionKeyInstanceHttpRequest, Operation> startWithEncryptionKeyInstanceSettings() {
        return this.startWithEncryptionKeyInstanceSettings;
    }

    public UnaryCallSettings<StopInstanceHttpRequest, Operation> stopInstanceSettings() {
        return this.stopInstanceSettings;
    }

    public UnaryCallSettings<UpdateAccessConfigInstanceHttpRequest, Operation> updateAccessConfigInstanceSettings() {
        return this.updateAccessConfigInstanceSettings;
    }

    public UnaryCallSettings<UpdateNetworkInterfaceInstanceHttpRequest, Operation> updateNetworkInterfaceInstanceSettings() {
        return this.updateNetworkInterfaceInstanceSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAccessConfigInstanceSettings = settingsBuilder.addAccessConfigInstanceSettings().build();
        this.aggregatedListInstancesSettings = settingsBuilder.aggregatedListInstancesSettings().build();
        this.attachDiskInstanceSettings = settingsBuilder.attachDiskInstanceSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteAccessConfigInstanceSettings = settingsBuilder.deleteAccessConfigInstanceSettings().build();
        this.detachDiskInstanceSettings = settingsBuilder.detachDiskInstanceSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.getSerialPortOutputInstanceSettings = settingsBuilder.getSerialPortOutputInstanceSettings().build();
        this.insertInstanceSettings = settingsBuilder.insertInstanceSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.listReferrersInstancesSettings = settingsBuilder.listReferrersInstancesSettings().build();
        this.resetInstanceSettings = settingsBuilder.resetInstanceSettings().build();
        this.setDeletionProtectionInstanceSettings = settingsBuilder.setDeletionProtectionInstanceSettings().build();
        this.setDiskAutoDeleteInstanceSettings = settingsBuilder.setDiskAutoDeleteInstanceSettings().build();
        this.setLabelsInstanceSettings = settingsBuilder.setLabelsInstanceSettings().build();
        this.setMachineResourcesInstanceSettings = settingsBuilder.setMachineResourcesInstanceSettings().build();
        this.setMachineTypeInstanceSettings = settingsBuilder.setMachineTypeInstanceSettings().build();
        this.setMetadataInstanceSettings = settingsBuilder.setMetadataInstanceSettings().build();
        this.setMinCpuPlatformInstanceSettings = settingsBuilder.setMinCpuPlatformInstanceSettings().build();
        this.setSchedulingInstanceSettings = settingsBuilder.setSchedulingInstanceSettings().build();
        this.setServiceAccountInstanceSettings = settingsBuilder.setServiceAccountInstanceSettings().build();
        this.setTagsInstanceSettings = settingsBuilder.setTagsInstanceSettings().build();
        this.startInstanceSettings = settingsBuilder.startInstanceSettings().build();
        this.startWithEncryptionKeyInstanceSettings = settingsBuilder.startWithEncryptionKeyInstanceSettings().build();
        this.stopInstanceSettings = settingsBuilder.stopInstanceSettings().build();
        this.updateAccessConfigInstanceSettings = settingsBuilder.updateAccessConfigInstanceSettings().build();
        this.updateNetworkInterfaceInstanceSettings = settingsBuilder.updateNetworkInterfaceInstanceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAccessConfigInstanceHttpRequest, Operation> addAccessConfigInstanceSettings;
        private final PagedCallSettings.Builder<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse> aggregatedListInstancesSettings;
        private final UnaryCallSettings.Builder<AttachDiskInstanceHttpRequest, Operation> attachDiskInstanceSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceHttpRequest, Operation> deleteInstanceSettings;
        private final UnaryCallSettings.Builder<DeleteAccessConfigInstanceHttpRequest, Operation> deleteAccessConfigInstanceSettings;
        private final UnaryCallSettings.Builder<DetachDiskInstanceHttpRequest, Operation> detachDiskInstanceSettings;
        private final UnaryCallSettings.Builder<GetInstanceHttpRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<GetSerialPortOutputInstanceHttpRequest, SerialPortOutput> getSerialPortOutputInstanceSettings;
        private final UnaryCallSettings.Builder<InsertInstanceHttpRequest, Operation> insertInstanceSettings;
        private final PagedCallSettings.Builder<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse> listInstancesSettings;
        private final PagedCallSettings.Builder<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse> listReferrersInstancesSettings;
        private final UnaryCallSettings.Builder<ResetInstanceHttpRequest, Operation> resetInstanceSettings;
        private final UnaryCallSettings.Builder<SetDeletionProtectionInstanceHttpRequest, Operation> setDeletionProtectionInstanceSettings;
        private final UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceHttpRequest, Operation> setDiskAutoDeleteInstanceSettings;
        private final UnaryCallSettings.Builder<SetLabelsInstanceHttpRequest, Operation> setLabelsInstanceSettings;
        private final UnaryCallSettings.Builder<SetMachineResourcesInstanceHttpRequest, Operation> setMachineResourcesInstanceSettings;
        private final UnaryCallSettings.Builder<SetMachineTypeInstanceHttpRequest, Operation> setMachineTypeInstanceSettings;
        private final UnaryCallSettings.Builder<SetMetadataInstanceHttpRequest, Operation> setMetadataInstanceSettings;
        private final UnaryCallSettings.Builder<SetMinCpuPlatformInstanceHttpRequest, Operation> setMinCpuPlatformInstanceSettings;
        private final UnaryCallSettings.Builder<SetSchedulingInstanceHttpRequest, Operation> setSchedulingInstanceSettings;
        private final UnaryCallSettings.Builder<SetServiceAccountInstanceHttpRequest, Operation> setServiceAccountInstanceSettings;
        private final UnaryCallSettings.Builder<SetTagsInstanceHttpRequest, Operation> setTagsInstanceSettings;
        private final UnaryCallSettings.Builder<StartInstanceHttpRequest, Operation> startInstanceSettings;
        private final UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceHttpRequest, Operation> startWithEncryptionKeyInstanceSettings;
        private final UnaryCallSettings.Builder<StopInstanceHttpRequest, Operation> stopInstanceSettings;
        private final UnaryCallSettings.Builder<UpdateAccessConfigInstanceHttpRequest, Operation> updateAccessConfigInstanceSettings;
        private final UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceHttpRequest, Operation> updateNetworkInterfaceInstanceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAccessConfigInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_INSTANCES_PAGE_STR_FACT);
            this.attachDiskInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessConfigInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachDiskInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSerialPortOutputInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.listReferrersInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REFERRERS_INSTANCES_PAGE_STR_FACT);
            this.resetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDeletionProtectionInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDiskAutoDeleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineResourcesInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineTypeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMetadataInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMinCpuPlatformInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSchedulingInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setServiceAccountInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTagsInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startWithEncryptionKeyInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessConfigInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNetworkInterfaceInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigInstanceSettings, this.aggregatedListInstancesSettings, this.attachDiskInstanceSettings, this.deleteInstanceSettings, this.deleteAccessConfigInstanceSettings, this.detachDiskInstanceSettings, this.getInstanceSettings, this.getSerialPortOutputInstanceSettings, this.insertInstanceSettings, this.listInstancesSettings, this.listReferrersInstancesSettings, this.resetInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.setDeletionProtectionInstanceSettings, this.setDiskAutoDeleteInstanceSettings, this.setLabelsInstanceSettings, this.setMachineResourcesInstanceSettings, this.setMachineTypeInstanceSettings, this.setMetadataInstanceSettings, this.setMinCpuPlatformInstanceSettings, this.setSchedulingInstanceSettings, this.setServiceAccountInstanceSettings, this.setTagsInstanceSettings, this.startInstanceSettings, this.startWithEncryptionKeyInstanceSettings, this.stopInstanceSettings, this.updateAccessConfigInstanceSettings, this.updateNetworkInterfaceInstanceSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstanceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAccessConfigInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.attachDiskInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAccessConfigInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.detachDiskInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSerialPortOutputInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listReferrersInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setDeletionProtectionInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setDiskAutoDeleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMachineResourcesInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMachineTypeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMetadataInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setMinCpuPlatformInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSchedulingInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setServiceAccountInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setTagsInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.startInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.startWithEncryptionKeyInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.stopInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAccessConfigInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateNetworkInterfaceInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InstanceStubSettings settings) {
            super((StubSettings)settings);
            this.addAccessConfigInstanceSettings = settings.addAccessConfigInstanceSettings.toBuilder();
            this.aggregatedListInstancesSettings = settings.aggregatedListInstancesSettings.toBuilder();
            this.attachDiskInstanceSettings = settings.attachDiskInstanceSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteAccessConfigInstanceSettings = settings.deleteAccessConfigInstanceSettings.toBuilder();
            this.detachDiskInstanceSettings = settings.detachDiskInstanceSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.getSerialPortOutputInstanceSettings = settings.getSerialPortOutputInstanceSettings.toBuilder();
            this.insertInstanceSettings = settings.insertInstanceSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.listReferrersInstancesSettings = settings.listReferrersInstancesSettings.toBuilder();
            this.resetInstanceSettings = settings.resetInstanceSettings.toBuilder();
            this.setDeletionProtectionInstanceSettings = settings.setDeletionProtectionInstanceSettings.toBuilder();
            this.setDiskAutoDeleteInstanceSettings = settings.setDiskAutoDeleteInstanceSettings.toBuilder();
            this.setLabelsInstanceSettings = settings.setLabelsInstanceSettings.toBuilder();
            this.setMachineResourcesInstanceSettings = settings.setMachineResourcesInstanceSettings.toBuilder();
            this.setMachineTypeInstanceSettings = settings.setMachineTypeInstanceSettings.toBuilder();
            this.setMetadataInstanceSettings = settings.setMetadataInstanceSettings.toBuilder();
            this.setMinCpuPlatformInstanceSettings = settings.setMinCpuPlatformInstanceSettings.toBuilder();
            this.setSchedulingInstanceSettings = settings.setSchedulingInstanceSettings.toBuilder();
            this.setServiceAccountInstanceSettings = settings.setServiceAccountInstanceSettings.toBuilder();
            this.setTagsInstanceSettings = settings.setTagsInstanceSettings.toBuilder();
            this.startInstanceSettings = settings.startInstanceSettings.toBuilder();
            this.startWithEncryptionKeyInstanceSettings = settings.startWithEncryptionKeyInstanceSettings.toBuilder();
            this.stopInstanceSettings = settings.stopInstanceSettings.toBuilder();
            this.updateAccessConfigInstanceSettings = settings.updateAccessConfigInstanceSettings.toBuilder();
            this.updateNetworkInterfaceInstanceSettings = settings.updateNetworkInterfaceInstanceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigInstanceSettings, this.aggregatedListInstancesSettings, this.attachDiskInstanceSettings, this.deleteInstanceSettings, this.deleteAccessConfigInstanceSettings, this.detachDiskInstanceSettings, this.getInstanceSettings, this.getSerialPortOutputInstanceSettings, this.insertInstanceSettings, this.listInstancesSettings, this.listReferrersInstancesSettings, this.resetInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.setDeletionProtectionInstanceSettings, this.setDiskAutoDeleteInstanceSettings, this.setLabelsInstanceSettings, this.setMachineResourcesInstanceSettings, this.setMachineTypeInstanceSettings, this.setMetadataInstanceSettings, this.setMinCpuPlatformInstanceSettings, this.setSchedulingInstanceSettings, this.setServiceAccountInstanceSettings, this.setTagsInstanceSettings, this.startInstanceSettings, this.startWithEncryptionKeyInstanceSettings, this.stopInstanceSettings, this.updateAccessConfigInstanceSettings, this.updateNetworkInterfaceInstanceSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAccessConfigInstanceHttpRequest, Operation> addAccessConfigInstanceSettings() {
            return this.addAccessConfigInstanceSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstancesHttpRequest, InstanceAggregatedList, InstanceClient.AggregatedListInstancesPagedResponse> aggregatedListInstancesSettings() {
            return this.aggregatedListInstancesSettings;
        }

        public UnaryCallSettings.Builder<AttachDiskInstanceHttpRequest, Operation> attachDiskInstanceSettings() {
            return this.attachDiskInstanceSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceHttpRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessConfigInstanceHttpRequest, Operation> deleteAccessConfigInstanceSettings() {
            return this.deleteAccessConfigInstanceSettings;
        }

        public UnaryCallSettings.Builder<DetachDiskInstanceHttpRequest, Operation> detachDiskInstanceSettings() {
            return this.detachDiskInstanceSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceHttpRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<GetSerialPortOutputInstanceHttpRequest, SerialPortOutput> getSerialPortOutputInstanceSettings() {
            return this.getSerialPortOutputInstanceSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceHttpRequest, Operation> insertInstanceSettings() {
            return this.insertInstanceSettings;
        }

        public PagedCallSettings.Builder<ListInstancesHttpRequest, InstanceList, InstanceClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public PagedCallSettings.Builder<ListReferrersInstancesHttpRequest, InstanceListReferrers, InstanceClient.ListReferrersInstancesPagedResponse> listReferrersInstancesSettings() {
            return this.listReferrersInstancesSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceHttpRequest, Operation> resetInstanceSettings() {
            return this.resetInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetDeletionProtectionInstanceHttpRequest, Operation> setDeletionProtectionInstanceSettings() {
            return this.setDeletionProtectionInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceHttpRequest, Operation> setDiskAutoDeleteInstanceSettings() {
            return this.setDiskAutoDeleteInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsInstanceHttpRequest, Operation> setLabelsInstanceSettings() {
            return this.setLabelsInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetMachineResourcesInstanceHttpRequest, Operation> setMachineResourcesInstanceSettings() {
            return this.setMachineResourcesInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetMachineTypeInstanceHttpRequest, Operation> setMachineTypeInstanceSettings() {
            return this.setMachineTypeInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetMetadataInstanceHttpRequest, Operation> setMetadataInstanceSettings() {
            return this.setMetadataInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetMinCpuPlatformInstanceHttpRequest, Operation> setMinCpuPlatformInstanceSettings() {
            return this.setMinCpuPlatformInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetSchedulingInstanceHttpRequest, Operation> setSchedulingInstanceSettings() {
            return this.setSchedulingInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetServiceAccountInstanceHttpRequest, Operation> setServiceAccountInstanceSettings() {
            return this.setServiceAccountInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetTagsInstanceHttpRequest, Operation> setTagsInstanceSettings() {
            return this.setTagsInstanceSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceHttpRequest, Operation> startInstanceSettings() {
            return this.startInstanceSettings;
        }

        public UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceHttpRequest, Operation> startWithEncryptionKeyInstanceSettings() {
            return this.startWithEncryptionKeyInstanceSettings;
        }

        public UnaryCallSettings.Builder<StopInstanceHttpRequest, Operation> stopInstanceSettings() {
            return this.stopInstanceSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessConfigInstanceHttpRequest, Operation> updateAccessConfigInstanceSettings() {
            return this.updateAccessConfigInstanceSettings;
        }

        public UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceHttpRequest, Operation> updateNetworkInterfaceInstanceSettings() {
            return this.updateNetworkInterfaceInstanceSettings;
        }

        public InstanceStubSettings build() throws IOException {
            return new InstanceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

