/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.BackendBucket;
import com.google.cloud.compute.v1.BackendBucketClient;
import com.google.cloud.compute.v1.BackendBucketList;
import com.google.cloud.compute.v1.DeleteBackendBucketHttpRequest;
import com.google.cloud.compute.v1.GetBackendBucketHttpRequest;
import com.google.cloud.compute.v1.InsertBackendBucketHttpRequest;
import com.google.cloud.compute.v1.ListBackendBucketsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendBucketHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalBackendBucketName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateBackendBucketHttpRequest;
import com.google.cloud.compute.v1.stub.BackendBucketStub;
import com.google.cloud.compute.v1.stub.BackendBucketStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonBackendBucketCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonBackendBucketStub
extends BackendBucketStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets/{backendBucket}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalBackendBucketName.newFactory()).setResourceNameField("backendBucket").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets/{backendBucket}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalBackendBucketName.newFactory()).setResourceNameField("backendBucket").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)BackendBucket.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertBackendBucketHttpRequest, Operation> insertBackendBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListBackendBucketsHttpRequest, BackendBucketList> listBackendBucketsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)BackendBucketList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchBackendBucketHttpRequest, Operation> patchBackendBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets/{backendBucket}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalBackendBucketName.newFactory()).setResourceNameField("backendBucket").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.backendBuckets.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/backendBuckets/{backendBucket}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalBackendBucketName.newFactory()).setResourceNameField("backendBucket").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketCallable;
    private final UnaryCallable<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketCallable;
    private final UnaryCallable<InsertBackendBucketHttpRequest, Operation> insertBackendBucketCallable;
    private final UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketList> listBackendBucketsCallable;
    private final UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsPagedCallable;
    private final UnaryCallable<PatchBackendBucketHttpRequest, Operation> patchBackendBucketCallable;
    private final UnaryCallable<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBackendBucketStub create(BackendBucketStubSettings settings) throws IOException {
        return new HttpJsonBackendBucketStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBackendBucketStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBackendBucketStub(BackendBucketStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonBackendBucketStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBackendBucketStub(BackendBucketStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBackendBucketStub(BackendBucketStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBackendBucketCallableFactory());
    }

    protected HttpJsonBackendBucketStub(BackendBucketStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteBackendBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBackendBucketMethodDescriptor).build();
        HttpJsonCallSettings getBackendBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBackendBucketMethodDescriptor).build();
        HttpJsonCallSettings insertBackendBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertBackendBucketMethodDescriptor).build();
        HttpJsonCallSettings listBackendBucketsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBackendBucketsMethodDescriptor).build();
        HttpJsonCallSettings patchBackendBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchBackendBucketMethodDescriptor).build();
        HttpJsonCallSettings updateBackendBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateBackendBucketMethodDescriptor).build();
        this.deleteBackendBucketCallable = callableFactory.createUnaryCallable(deleteBackendBucketTransportSettings, settings.deleteBackendBucketSettings(), clientContext);
        this.getBackendBucketCallable = callableFactory.createUnaryCallable(getBackendBucketTransportSettings, settings.getBackendBucketSettings(), clientContext);
        this.insertBackendBucketCallable = callableFactory.createUnaryCallable(insertBackendBucketTransportSettings, settings.insertBackendBucketSettings(), clientContext);
        this.listBackendBucketsCallable = callableFactory.createUnaryCallable(listBackendBucketsTransportSettings, settings.listBackendBucketsSettings(), clientContext);
        this.listBackendBucketsPagedCallable = callableFactory.createPagedCallable(listBackendBucketsTransportSettings, settings.listBackendBucketsSettings(), clientContext);
        this.patchBackendBucketCallable = callableFactory.createUnaryCallable(patchBackendBucketTransportSettings, settings.patchBackendBucketSettings(), clientContext);
        this.updateBackendBucketCallable = callableFactory.createUnaryCallable(updateBackendBucketTransportSettings, settings.updateBackendBucketSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketCallable() {
        return this.deleteBackendBucketCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketCallable() {
        return this.getBackendBucketCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertBackendBucketHttpRequest, Operation> insertBackendBucketCallable() {
        return this.insertBackendBucketCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketClient.ListBackendBucketsPagedResponse> listBackendBucketsPagedCallable() {
        return this.listBackendBucketsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketList> listBackendBucketsCallable() {
        return this.listBackendBucketsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchBackendBucketHttpRequest, Operation> patchBackendBucketCallable() {
        return this.patchBackendBucketCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketCallable() {
        return this.updateBackendBucketCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

