/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Reference
implements ApiMessage {
    private final String kind;
    private final String referenceType;
    private final String referrer;
    private final String target;
    private static final Reference DEFAULT_INSTANCE = new Reference();

    private Reference() {
        this.kind = null;
        this.referenceType = null;
        this.referrer = null;
        this.target = null;
    }

    private Reference(String kind, String referenceType, String referrer, String target) {
        this.kind = kind;
        this.referenceType = referenceType;
        this.referrer = referrer;
        this.target = target;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("referenceType")) {
            return this.referenceType;
        }
        if (fieldName.equals("referrer")) {
            return this.referrer;
        }
        if (fieldName.equals("target")) {
            return this.target;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKind() {
        return this.kind;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getTarget() {
        return this.target;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Reference prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Reference getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Reference{kind=" + this.kind + ", referenceType=" + this.referenceType + ", referrer=" + this.referrer + ", target=" + this.target + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Reference) {
            Reference that = (Reference)o;
            return Objects.equals(this.kind, that.getKind()) && Objects.equals(this.referenceType, that.getReferenceType()) && Objects.equals(this.referrer, that.getReferrer()) && Objects.equals(this.target, that.getTarget());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.referenceType, this.referrer, this.target);
    }

    public static class Builder {
        private String kind;
        private String referenceType;
        private String referrer;
        private String target;

        Builder() {
        }

        public Builder mergeFrom(Reference other) {
            if (other == Reference.getDefaultInstance()) {
                return this;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getReferenceType() != null) {
                this.referenceType = other.referenceType;
            }
            if (other.getReferrer() != null) {
                this.referrer = other.referrer;
            }
            if (other.getTarget() != null) {
                this.target = other.target;
            }
            return this;
        }

        Builder(Reference source) {
            this.kind = source.kind;
            this.referenceType = source.referenceType;
            this.referrer = source.referrer;
            this.target = source.target;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getReferenceType() {
            return this.referenceType;
        }

        public Builder setReferenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public String getReferrer() {
            return this.referrer;
        }

        public Builder setReferrer(String referrer) {
            this.referrer = referrer;
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Reference build() {
            return new Reference(this.kind, this.referenceType, this.referrer, this.target);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKind(this.kind);
            newBuilder.setReferenceType(this.referenceType);
            newBuilder.setReferrer(this.referrer);
            newBuilder.setTarget(this.target);
            return newBuilder;
        }
    }
}

