/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NamedPort;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceWithNamedPorts
implements ApiMessage {
    private final String instance;
    private final List<NamedPort> namedPorts;
    private final String status;
    private static final InstanceWithNamedPorts DEFAULT_INSTANCE = new InstanceWithNamedPorts();

    private InstanceWithNamedPorts() {
        this.instance = null;
        this.namedPorts = null;
        this.status = null;
    }

    private InstanceWithNamedPorts(String instance, List<NamedPort> namedPorts, String status) {
        this.instance = instance;
        this.namedPorts = namedPorts;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("instance")) {
            return this.instance;
        }
        if (fieldName.equals("namedPorts")) {
            return this.namedPorts;
        }
        if (fieldName.equals("status")) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstance() {
        return this.instance;
    }

    public List<NamedPort> getNamedPortsList() {
        return this.namedPorts;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceWithNamedPorts prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceWithNamedPorts getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceWithNamedPorts{instance=" + this.instance + ", namedPorts=" + this.namedPorts + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceWithNamedPorts) {
            InstanceWithNamedPorts that = (InstanceWithNamedPorts)o;
            return Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.namedPorts, that.getNamedPortsList()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.namedPorts, this.status);
    }

    public static class Builder {
        private String instance;
        private List<NamedPort> namedPorts;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(InstanceWithNamedPorts other) {
            if (other == InstanceWithNamedPorts.getDefaultInstance()) {
                return this;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            if (other.getNamedPortsList() != null) {
                this.namedPorts = other.namedPorts;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(InstanceWithNamedPorts source) {
            this.instance = source.instance;
            this.namedPorts = source.namedPorts;
            this.status = source.status;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public List<NamedPort> getNamedPortsList() {
            return this.namedPorts;
        }

        public Builder addAllNamedPorts(List<NamedPort> namedPorts) {
            if (this.namedPorts == null) {
                this.namedPorts = new LinkedList<NamedPort>();
            }
            this.namedPorts.addAll(namedPorts);
            return this;
        }

        public Builder addNamedPorts(NamedPort namedPorts) {
            if (this.namedPorts == null) {
                this.namedPorts = new LinkedList<NamedPort>();
            }
            this.namedPorts.add(namedPorts);
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public InstanceWithNamedPorts build() {
            return new InstanceWithNamedPorts(this.instance, this.namedPorts, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstance(this.instance);
            newBuilder.addAllNamedPorts(this.namedPorts);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

