/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstancesScopedList
implements ApiMessage {
    private final List<Instance> instances;
    private final Warning warning;
    private static final InstancesScopedList DEFAULT_INSTANCE = new InstancesScopedList();

    private InstancesScopedList() {
        this.instances = null;
        this.warning = null;
    }

    private InstancesScopedList(List<Instance> instances, Warning warning) {
        this.instances = instances;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("instances")) {
            return this.instances;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Instance> getInstancesList() {
        return this.instances;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstancesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstancesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstancesScopedList{instances=" + this.instances + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstancesScopedList) {
            InstancesScopedList that = (InstancesScopedList)o;
            return Objects.equals(this.instances, that.getInstancesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.warning);
    }

    public static class Builder {
        private List<Instance> instances;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(InstancesScopedList other) {
            if (other == InstancesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(InstancesScopedList source) {
            this.instances = source.instances;
            this.warning = source.warning;
        }

        public List<Instance> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<Instance> instances) {
            if (this.instances == null) {
                this.instances = new ArrayList<Instance>(instances.size());
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(Instance instances) {
            this.instances.add(instances);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public InstancesScopedList build() {
            return new InstancesScopedList(this.instances, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

