/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AutoscalingPolicyCpuUtilization;
import com.google.cloud.compute.v1.AutoscalingPolicyCustomMetricUtilization;
import com.google.cloud.compute.v1.AutoscalingPolicyLoadBalancingUtilization;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AutoscalingPolicy
implements ApiMessage {
    private final Integer coolDownPeriodSec;
    private final AutoscalingPolicyCpuUtilization cpuUtilization;
    private final List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations;
    private final AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;
    private final Integer maxNumReplicas;
    private final Integer minNumReplicas;
    private static final AutoscalingPolicy DEFAULT_INSTANCE = new AutoscalingPolicy();

    private AutoscalingPolicy() {
        this.coolDownPeriodSec = null;
        this.cpuUtilization = null;
        this.customMetricUtilizations = null;
        this.loadBalancingUtilization = null;
        this.maxNumReplicas = null;
        this.minNumReplicas = null;
    }

    private AutoscalingPolicy(Integer coolDownPeriodSec, AutoscalingPolicyCpuUtilization cpuUtilization, List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations, AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization, Integer maxNumReplicas, Integer minNumReplicas) {
        this.coolDownPeriodSec = coolDownPeriodSec;
        this.cpuUtilization = cpuUtilization;
        this.customMetricUtilizations = customMetricUtilizations;
        this.loadBalancingUtilization = loadBalancingUtilization;
        this.maxNumReplicas = maxNumReplicas;
        this.minNumReplicas = minNumReplicas;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("coolDownPeriodSec")) {
            return this.coolDownPeriodSec;
        }
        if (fieldName.equals("cpuUtilization")) {
            return this.cpuUtilization;
        }
        if (fieldName.equals("customMetricUtilizations")) {
            return this.customMetricUtilizations;
        }
        if (fieldName.equals("loadBalancingUtilization")) {
            return this.loadBalancingUtilization;
        }
        if (fieldName.equals("maxNumReplicas")) {
            return this.maxNumReplicas;
        }
        if (fieldName.equals("minNumReplicas")) {
            return this.minNumReplicas;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getCoolDownPeriodSec() {
        return this.coolDownPeriodSec;
    }

    public AutoscalingPolicyCpuUtilization getCpuUtilization() {
        return this.cpuUtilization;
    }

    public List<AutoscalingPolicyCustomMetricUtilization> getCustomMetricUtilizationsList() {
        return this.customMetricUtilizations;
    }

    public AutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
        return this.loadBalancingUtilization;
    }

    public Integer getMaxNumReplicas() {
        return this.maxNumReplicas;
    }

    public Integer getMinNumReplicas() {
        return this.minNumReplicas;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AutoscalingPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AutoscalingPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AutoscalingPolicy{coolDownPeriodSec=" + this.coolDownPeriodSec + ", cpuUtilization=" + this.cpuUtilization + ", customMetricUtilizations=" + this.customMetricUtilizations + ", loadBalancingUtilization=" + this.loadBalancingUtilization + ", maxNumReplicas=" + this.maxNumReplicas + ", minNumReplicas=" + this.minNumReplicas + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AutoscalingPolicy) {
            AutoscalingPolicy that = (AutoscalingPolicy)o;
            return Objects.equals(this.coolDownPeriodSec, that.getCoolDownPeriodSec()) && Objects.equals(this.cpuUtilization, that.getCpuUtilization()) && Objects.equals(this.customMetricUtilizations, that.getCustomMetricUtilizationsList()) && Objects.equals(this.loadBalancingUtilization, that.getLoadBalancingUtilization()) && Objects.equals(this.maxNumReplicas, that.getMaxNumReplicas()) && Objects.equals(this.minNumReplicas, that.getMinNumReplicas());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.coolDownPeriodSec, this.cpuUtilization, this.customMetricUtilizations, this.loadBalancingUtilization, this.maxNumReplicas, this.minNumReplicas);
    }

    public static class Builder {
        private Integer coolDownPeriodSec;
        private AutoscalingPolicyCpuUtilization cpuUtilization;
        private List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations;
        private AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;
        private Integer maxNumReplicas;
        private Integer minNumReplicas;

        Builder() {
        }

        public Builder mergeFrom(AutoscalingPolicy other) {
            if (other == AutoscalingPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getCoolDownPeriodSec() != null) {
                this.coolDownPeriodSec = other.coolDownPeriodSec;
            }
            if (other.getCpuUtilization() != null) {
                this.cpuUtilization = other.cpuUtilization;
            }
            if (other.getCustomMetricUtilizationsList() != null) {
                this.customMetricUtilizations = other.customMetricUtilizations;
            }
            if (other.getLoadBalancingUtilization() != null) {
                this.loadBalancingUtilization = other.loadBalancingUtilization;
            }
            if (other.getMaxNumReplicas() != null) {
                this.maxNumReplicas = other.maxNumReplicas;
            }
            if (other.getMinNumReplicas() != null) {
                this.minNumReplicas = other.minNumReplicas;
            }
            return this;
        }

        Builder(AutoscalingPolicy source) {
            this.coolDownPeriodSec = source.coolDownPeriodSec;
            this.cpuUtilization = source.cpuUtilization;
            this.customMetricUtilizations = source.customMetricUtilizations;
            this.loadBalancingUtilization = source.loadBalancingUtilization;
            this.maxNumReplicas = source.maxNumReplicas;
            this.minNumReplicas = source.minNumReplicas;
        }

        public Integer getCoolDownPeriodSec() {
            return this.coolDownPeriodSec;
        }

        public Builder setCoolDownPeriodSec(Integer coolDownPeriodSec) {
            this.coolDownPeriodSec = coolDownPeriodSec;
            return this;
        }

        public AutoscalingPolicyCpuUtilization getCpuUtilization() {
            return this.cpuUtilization;
        }

        public Builder setCpuUtilization(AutoscalingPolicyCpuUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        public List<AutoscalingPolicyCustomMetricUtilization> getCustomMetricUtilizationsList() {
            return this.customMetricUtilizations;
        }

        public Builder addAllCustomMetricUtilizations(List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations) {
            if (this.customMetricUtilizations == null) {
                this.customMetricUtilizations = new ArrayList<AutoscalingPolicyCustomMetricUtilization>(customMetricUtilizations.size());
            }
            this.customMetricUtilizations.addAll(customMetricUtilizations);
            return this;
        }

        public Builder addCustomMetricUtilizations(AutoscalingPolicyCustomMetricUtilization customMetricUtilizations) {
            this.customMetricUtilizations.add(customMetricUtilizations);
            return this;
        }

        public AutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
            return this.loadBalancingUtilization;
        }

        public Builder setLoadBalancingUtilization(AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization) {
            this.loadBalancingUtilization = loadBalancingUtilization;
            return this;
        }

        public Integer getMaxNumReplicas() {
            return this.maxNumReplicas;
        }

        public Builder setMaxNumReplicas(Integer maxNumReplicas) {
            this.maxNumReplicas = maxNumReplicas;
            return this;
        }

        public Integer getMinNumReplicas() {
            return this.minNumReplicas;
        }

        public Builder setMinNumReplicas(Integer minNumReplicas) {
            this.minNumReplicas = minNumReplicas;
            return this;
        }

        public AutoscalingPolicy build() {
            return new AutoscalingPolicy(this.coolDownPeriodSec, this.cpuUtilization, this.customMetricUtilizations, this.loadBalancingUtilization, this.maxNumReplicas, this.minNumReplicas);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCoolDownPeriodSec(this.coolDownPeriodSec);
            newBuilder.setCpuUtilization(this.cpuUtilization);
            newBuilder.addAllCustomMetricUtilizations(this.customMetricUtilizations);
            newBuilder.setLoadBalancingUtilization(this.loadBalancingUtilization);
            newBuilder.setMaxNumReplicas(this.maxNumReplicas);
            newBuilder.setMinNumReplicas(this.minNumReplicas);
            return newBuilder;
        }
    }
}

