/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AcceleratorType;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AcceleratorTypesScopedList
implements ApiMessage {
    private final List<AcceleratorType> acceleratorTypes;
    private final Warning warning;
    private static final AcceleratorTypesScopedList DEFAULT_INSTANCE = new AcceleratorTypesScopedList();

    private AcceleratorTypesScopedList() {
        this.acceleratorTypes = null;
        this.warning = null;
    }

    private AcceleratorTypesScopedList(List<AcceleratorType> acceleratorTypes, Warning warning) {
        this.acceleratorTypes = acceleratorTypes;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("acceleratorTypes")) {
            return this.acceleratorTypes;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AcceleratorType> getAcceleratorTypesList() {
        return this.acceleratorTypes;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AcceleratorTypesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AcceleratorTypesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AcceleratorTypesScopedList{acceleratorTypes=" + this.acceleratorTypes + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AcceleratorTypesScopedList) {
            AcceleratorTypesScopedList that = (AcceleratorTypesScopedList)o;
            return Objects.equals(this.acceleratorTypes, that.getAcceleratorTypesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.acceleratorTypes, this.warning);
    }

    public static class Builder {
        private List<AcceleratorType> acceleratorTypes;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(AcceleratorTypesScopedList other) {
            if (other == AcceleratorTypesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getAcceleratorTypesList() != null) {
                this.acceleratorTypes = other.acceleratorTypes;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(AcceleratorTypesScopedList source) {
            this.acceleratorTypes = source.acceleratorTypes;
            this.warning = source.warning;
        }

        public List<AcceleratorType> getAcceleratorTypesList() {
            return this.acceleratorTypes;
        }

        public Builder addAllAcceleratorTypes(List<AcceleratorType> acceleratorTypes) {
            if (this.acceleratorTypes == null) {
                this.acceleratorTypes = new ArrayList<AcceleratorType>(acceleratorTypes.size());
            }
            this.acceleratorTypes.addAll(acceleratorTypes);
            return this;
        }

        public Builder addAcceleratorTypes(AcceleratorType acceleratorTypes) {
            this.acceleratorTypes.add(acceleratorTypes);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public AcceleratorTypesScopedList build() {
            return new AcceleratorTypesScopedList(this.acceleratorTypes, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAcceleratorTypes(this.acceleratorTypes);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

