/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetPoolsAddInstanceRequest
implements ApiMessage {
    private final List<InstanceReference> instances;
    private static final TargetPoolsAddInstanceRequest DEFAULT_INSTANCE = new TargetPoolsAddInstanceRequest();

    private TargetPoolsAddInstanceRequest() {
        this.instances = null;
    }

    private TargetPoolsAddInstanceRequest(List<InstanceReference> instances) {
        this.instances = instances;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("instances")) {
            return this.instances;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<InstanceReference> getInstancesList() {
        return this.instances;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetPoolsAddInstanceRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetPoolsAddInstanceRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetPoolsAddInstanceRequest{instances=" + this.instances + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetPoolsAddInstanceRequest) {
            TargetPoolsAddInstanceRequest that = (TargetPoolsAddInstanceRequest)o;
            return Objects.equals(this.instances, that.getInstancesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances);
    }

    public static class Builder {
        private List<InstanceReference> instances;

        Builder() {
        }

        public Builder mergeFrom(TargetPoolsAddInstanceRequest other) {
            if (other == TargetPoolsAddInstanceRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            return this;
        }

        Builder(TargetPoolsAddInstanceRequest source) {
            this.instances = source.instances;
        }

        public List<InstanceReference> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<InstanceReference> instances) {
            if (this.instances == null) {
                this.instances = new ArrayList<InstanceReference>(instances.size());
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(InstanceReference instances) {
            this.instances.add(instances);
            return this;
        }

        public TargetPoolsAddInstanceRequest build() {
            return new TargetPoolsAddInstanceRequest(this.instances);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            return newBuilder;
        }
    }
}

