/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectTargetHttpsProxyName
implements ResourceName {
    private final String project;
    private final String targetHttpsProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/targetHttpsProxies/{targetHttpsProxy}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectTargetHttpsProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetHttpsProxy());
    }

    public static ProjectTargetHttpsProxyName of(String project, String targetHttpsProxy) {
        return ProjectTargetHttpsProxyName.newBuilder().setProject(project).setTargetHttpsProxy(targetHttpsProxy).build();
    }

    public static String format(String project, String targetHttpsProxy) {
        return ProjectTargetHttpsProxyName.of(project, targetHttpsProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetHttpsProxy() {
        return this.targetHttpsProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectTargetHttpsProxyName projectTargetHttpsProxyName = this;
            synchronized (projectTargetHttpsProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetHttpsProxy", (Object)this.targetHttpsProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectTargetHttpsProxyName> newFactory() {
        return new ResourceNameFactory<ProjectTargetHttpsProxyName>(){

            public ProjectTargetHttpsProxyName parse(String formattedString) {
                return ProjectTargetHttpsProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectTargetHttpsProxyName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectTargetHttpsProxyName.parse: formattedString not in valid format");
        return ProjectTargetHttpsProxyName.of((String)matchMap.get("project"), (String)matchMap.get("targetHttpsProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetHttpsProxy", this.targetHttpsProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectTargetHttpsProxyName) {
            ProjectTargetHttpsProxyName that = (ProjectTargetHttpsProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetHttpsProxy, that.getTargetHttpsProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetHttpsProxy);
    }

    public static class Builder {
        private String project;
        private String targetHttpsProxy;

        public String getProject() {
            return this.project;
        }

        public String getTargetHttpsProxy() {
            return this.targetHttpsProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetHttpsProxy(String targetHttpsProxy) {
            this.targetHttpsProxy = targetHttpsProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectTargetHttpsProxyName projectTargetHttpsProxyName) {
            this.project = projectTargetHttpsProxyName.project;
            this.targetHttpsProxy = projectTargetHttpsProxyName.targetHttpsProxy;
        }

        public ProjectTargetHttpsProxyName build() {
            return new ProjectTargetHttpsProxyName(this);
        }
    }
}

