/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CacheKeyPolicy
implements ApiMessage {
    private final Boolean includeHost;
    private final Boolean includeProtocol;
    private final Boolean includeQueryString;
    private final List<String> queryStringBlacklist;
    private final List<String> queryStringWhitelist;
    private static final CacheKeyPolicy DEFAULT_INSTANCE = new CacheKeyPolicy();

    private CacheKeyPolicy() {
        this.includeHost = null;
        this.includeProtocol = null;
        this.includeQueryString = null;
        this.queryStringBlacklist = null;
        this.queryStringWhitelist = null;
    }

    private CacheKeyPolicy(Boolean includeHost, Boolean includeProtocol, Boolean includeQueryString, List<String> queryStringBlacklist, List<String> queryStringWhitelist) {
        this.includeHost = includeHost;
        this.includeProtocol = includeProtocol;
        this.includeQueryString = includeQueryString;
        this.queryStringBlacklist = queryStringBlacklist;
        this.queryStringWhitelist = queryStringWhitelist;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("includeHost")) {
            return this.includeHost;
        }
        if (fieldName.equals("includeProtocol")) {
            return this.includeProtocol;
        }
        if (fieldName.equals("includeQueryString")) {
            return this.includeQueryString;
        }
        if (fieldName.equals("queryStringBlacklist")) {
            return this.queryStringBlacklist;
        }
        if (fieldName.equals("queryStringWhitelist")) {
            return this.queryStringWhitelist;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getIncludeHost() {
        return this.includeHost;
    }

    public Boolean getIncludeProtocol() {
        return this.includeProtocol;
    }

    public Boolean getIncludeQueryString() {
        return this.includeQueryString;
    }

    public List<String> getQueryStringBlacklistList() {
        return this.queryStringBlacklist;
    }

    public List<String> getQueryStringWhitelistList() {
        return this.queryStringWhitelist;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CacheKeyPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CacheKeyPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CacheKeyPolicy{includeHost=" + this.includeHost + ", includeProtocol=" + this.includeProtocol + ", includeQueryString=" + this.includeQueryString + ", queryStringBlacklist=" + this.queryStringBlacklist + ", queryStringWhitelist=" + this.queryStringWhitelist + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CacheKeyPolicy) {
            CacheKeyPolicy that = (CacheKeyPolicy)o;
            return Objects.equals(this.includeHost, that.getIncludeHost()) && Objects.equals(this.includeProtocol, that.getIncludeProtocol()) && Objects.equals(this.includeQueryString, that.getIncludeQueryString()) && Objects.equals(this.queryStringBlacklist, that.getQueryStringBlacklistList()) && Objects.equals(this.queryStringWhitelist, that.getQueryStringWhitelistList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.includeHost, this.includeProtocol, this.includeQueryString, this.queryStringBlacklist, this.queryStringWhitelist);
    }

    public static class Builder {
        private Boolean includeHost;
        private Boolean includeProtocol;
        private Boolean includeQueryString;
        private List<String> queryStringBlacklist;
        private List<String> queryStringWhitelist;

        Builder() {
        }

        public Builder mergeFrom(CacheKeyPolicy other) {
            if (other == CacheKeyPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getIncludeHost() != null) {
                this.includeHost = other.includeHost;
            }
            if (other.getIncludeProtocol() != null) {
                this.includeProtocol = other.includeProtocol;
            }
            if (other.getIncludeQueryString() != null) {
                this.includeQueryString = other.includeQueryString;
            }
            if (other.getQueryStringBlacklistList() != null) {
                this.queryStringBlacklist = other.queryStringBlacklist;
            }
            if (other.getQueryStringWhitelistList() != null) {
                this.queryStringWhitelist = other.queryStringWhitelist;
            }
            return this;
        }

        Builder(CacheKeyPolicy source) {
            this.includeHost = source.includeHost;
            this.includeProtocol = source.includeProtocol;
            this.includeQueryString = source.includeQueryString;
            this.queryStringBlacklist = source.queryStringBlacklist;
            this.queryStringWhitelist = source.queryStringWhitelist;
        }

        public Boolean getIncludeHost() {
            return this.includeHost;
        }

        public Builder setIncludeHost(Boolean includeHost) {
            this.includeHost = includeHost;
            return this;
        }

        public Boolean getIncludeProtocol() {
            return this.includeProtocol;
        }

        public Builder setIncludeProtocol(Boolean includeProtocol) {
            this.includeProtocol = includeProtocol;
            return this;
        }

        public Boolean getIncludeQueryString() {
            return this.includeQueryString;
        }

        public Builder setIncludeQueryString(Boolean includeQueryString) {
            this.includeQueryString = includeQueryString;
            return this;
        }

        public List<String> getQueryStringBlacklistList() {
            return this.queryStringBlacklist;
        }

        public Builder addAllQueryStringBlacklist(List<String> queryStringBlacklist) {
            if (this.queryStringBlacklist == null) {
                this.queryStringBlacklist = new ArrayList<String>(queryStringBlacklist.size());
            }
            this.queryStringBlacklist.addAll(queryStringBlacklist);
            return this;
        }

        public Builder addQueryStringBlacklist(String queryStringBlacklist) {
            this.queryStringBlacklist.add(queryStringBlacklist);
            return this;
        }

        public List<String> getQueryStringWhitelistList() {
            return this.queryStringWhitelist;
        }

        public Builder addAllQueryStringWhitelist(List<String> queryStringWhitelist) {
            if (this.queryStringWhitelist == null) {
                this.queryStringWhitelist = new ArrayList<String>(queryStringWhitelist.size());
            }
            this.queryStringWhitelist.addAll(queryStringWhitelist);
            return this;
        }

        public Builder addQueryStringWhitelist(String queryStringWhitelist) {
            this.queryStringWhitelist.add(queryStringWhitelist);
            return this;
        }

        public CacheKeyPolicy build() {
            return new CacheKeyPolicy(this.includeHost, this.includeProtocol, this.includeQueryString, this.queryStringBlacklist, this.queryStringWhitelist);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setIncludeHost(this.includeHost);
            newBuilder.setIncludeProtocol(this.includeProtocol);
            newBuilder.setIncludeQueryString(this.includeQueryString);
            newBuilder.addAllQueryStringBlacklist(this.queryStringBlacklist);
            newBuilder.addAllQueryStringWhitelist(this.queryStringWhitelist);
            return newBuilder;
        }
    }
}

