/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.deprecated.DiskConfiguration;
import com.google.cloud.compute.deprecated.DiskId;
import com.google.cloud.compute.deprecated.InstanceId;
import com.google.cloud.compute.deprecated.LicenseId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DiskInfo
implements Serializable {
    static final Function<Disk, DiskInfo> FROM_PB_FUNCTION = new Function<Disk, DiskInfo>(){

        public DiskInfo apply(Disk pb) {
            return DiskInfo.fromPb(pb);
        }
    };
    static final Function<DiskInfo, Disk> TO_PB_FUNCTION = new Function<DiskInfo, Disk>(){

        public Disk apply(DiskInfo diskType) {
            return diskType.toPb();
        }
    };
    private static final long serialVersionUID = -7173418340679279619L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final DiskId diskId;
    private final DiskConfiguration configuration;
    private final Long creationTimestamp;
    private final CreationStatus creationStatus;
    private final String description;
    private final List<LicenseId> licenses;
    private final List<InstanceId> attachedInstances;
    private final Long lastAttachTimestamp;
    private final Long lastDetachTimestamp;

    DiskInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.configuration = builder.configuration;
        this.creationTimestamp = builder.creationTimestamp;
        this.creationStatus = builder.creationStatus;
        this.diskId = builder.diskId;
        this.description = builder.description;
        this.licenses = builder.licenses;
        this.attachedInstances = builder.attachedInstances;
        this.lastAttachTimestamp = builder.lastAttachTimestamp;
        this.lastDetachTimestamp = builder.lastDetachTimestamp;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public <T extends DiskConfiguration> T getConfiguration() {
        return (T)this.configuration;
    }

    public DiskId getDiskId() {
        return this.diskId;
    }

    public CreationStatus getCreationStatus() {
        return this.creationStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LicenseId> getLicenses() {
        return this.licenses;
    }

    public List<InstanceId> getAttachedInstances() {
        return this.attachedInstances;
    }

    public Long getLastAttachTimestamp() {
        return this.lastAttachTimestamp;
    }

    public Long getLastDetachTimestamp() {
        return this.lastDetachTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("diskId", (Object)this.diskId).add("configuration", (Object)this.configuration).add("creationTimestamp", (Object)this.creationTimestamp).add("creationStatus", (Object)this.creationStatus).add("description", (Object)this.description).add("licenses", this.licenses).add("attachedInstances", this.attachedInstances).add("lastAttachTimestamp", (Object)this.lastAttachTimestamp).add("lastDetachTimestamp", (Object)this.lastDetachTimestamp).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskId, this.configuration, this.creationTimestamp, this.creationStatus, this.description, this.licenses, this.attachedInstances, this.lastAttachTimestamp, this.lastDetachTimestamp});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(DiskInfo.class) && Objects.equals(this.toPb(), ((DiskInfo)obj).toPb());
    }

    public static Builder newBuilder(DiskId diskId, DiskConfiguration configuration) {
        return new BuilderImpl(diskId, configuration);
    }

    public static DiskInfo of(DiskId diskId, DiskConfiguration configuration) {
        return DiskInfo.newBuilder(diskId, configuration).build();
    }

    DiskInfo setProjectId(String projectId) {
        return this.toBuilder().setDiskId(this.diskId.setProjectId(projectId)).setConfiguration(this.configuration.setProjectId(projectId)).build();
    }

    Disk toPb() {
        Disk diskPb = this.configuration.toPb();
        if (this.generatedId != null) {
            diskPb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            diskPb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        diskPb.setZone(this.diskId.getZoneId().getSelfLink());
        if (this.creationStatus != null) {
            diskPb.setStatus(this.creationStatus.toString());
        }
        diskPb.setName(this.diskId.getDisk());
        diskPb.setDescription(this.description);
        diskPb.setSelfLink(this.diskId.getSelfLink());
        if (this.licenses != null) {
            diskPb.setLicenses(Lists.transform(this.licenses, LicenseId.TO_URL_FUNCTION));
        }
        if (this.attachedInstances != null) {
            diskPb.setUsers(Lists.transform(this.attachedInstances, InstanceId.TO_URL_FUNCTION));
        }
        if (this.lastAttachTimestamp != null) {
            diskPb.setLastAttachTimestamp(TIMESTAMP_FORMATTER.print(this.lastAttachTimestamp.longValue()));
        }
        if (this.lastDetachTimestamp != null) {
            diskPb.setLastDetachTimestamp(TIMESTAMP_FORMATTER.print(this.lastDetachTimestamp.longValue()));
        }
        return diskPb;
    }

    static DiskInfo fromPb(Disk diskPb) {
        return new BuilderImpl(diskPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private DiskId diskId;
        private DiskConfiguration configuration;
        private Long creationTimestamp;
        private CreationStatus creationStatus;
        private String description;
        private List<LicenseId> licenses;
        private List<InstanceId> attachedInstances;
        private Long lastAttachTimestamp;
        private Long lastDetachTimestamp;

        BuilderImpl(DiskId diskId, DiskConfiguration configuration) {
            this.diskId = (DiskId)Preconditions.checkNotNull((Object)diskId);
            this.configuration = (DiskConfiguration)Preconditions.checkNotNull((Object)configuration);
        }

        BuilderImpl(DiskInfo diskInfo) {
            this.generatedId = diskInfo.generatedId;
            this.configuration = diskInfo.configuration;
            this.creationTimestamp = diskInfo.creationTimestamp;
            this.creationStatus = diskInfo.creationStatus;
            this.diskId = diskInfo.diskId;
            this.description = diskInfo.description;
            this.licenses = diskInfo.licenses;
            this.attachedInstances = diskInfo.attachedInstances;
            this.lastAttachTimestamp = diskInfo.lastAttachTimestamp;
            this.lastDetachTimestamp = diskInfo.lastDetachTimestamp;
        }

        BuilderImpl(Disk diskPb) {
            if (diskPb.getId() != null) {
                this.generatedId = diskPb.getId().toString();
            }
            this.configuration = DiskConfiguration.fromPb(diskPb);
            if (diskPb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(diskPb.getCreationTimestamp());
            }
            if (diskPb.getStatus() != null) {
                this.creationStatus = CreationStatus.valueOf(diskPb.getStatus());
            }
            this.diskId = DiskId.fromUrl(diskPb.getSelfLink());
            this.description = diskPb.getDescription();
            if (diskPb.getLicenses() != null) {
                this.licenses = Lists.transform((List)diskPb.getLicenses(), LicenseId.FROM_URL_FUNCTION);
            }
            if (diskPb.getUsers() != null) {
                this.attachedInstances = Lists.transform((List)diskPb.getUsers(), InstanceId.FROM_URL_FUNCTION);
            }
            if (diskPb.getLastAttachTimestamp() != null) {
                this.lastAttachTimestamp = TIMESTAMP_FORMATTER.parseMillis(diskPb.getLastAttachTimestamp());
            }
            if (diskPb.getLastDetachTimestamp() != null) {
                this.lastDetachTimestamp = TIMESTAMP_FORMATTER.parseMillis(diskPb.getLastDetachTimestamp());
            }
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public BuilderImpl setConfiguration(DiskConfiguration configuration) {
            this.configuration = (DiskConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public BuilderImpl setDiskId(DiskId diskId) {
            this.diskId = (DiskId)Preconditions.checkNotNull((Object)diskId);
            return this;
        }

        @Override
        BuilderImpl setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        BuilderImpl setCreationStatus(CreationStatus creationStatus) {
            this.creationStatus = creationStatus;
            return this;
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        BuilderImpl setLicenses(List<LicenseId> licenses) {
            this.licenses = licenses != null ? ImmutableList.copyOf(licenses) : null;
            return this;
        }

        @Override
        BuilderImpl setAttachedInstances(List<InstanceId> attachedInstances) {
            this.attachedInstances = attachedInstances != null ? ImmutableList.copyOf(attachedInstances) : null;
            return this;
        }

        @Override
        BuilderImpl setLastAttachTimestamp(Long lastAttachTimestamp) {
            this.lastAttachTimestamp = lastAttachTimestamp;
            return this;
        }

        @Override
        BuilderImpl setLastDetachTimestamp(Long lastDetachTimestamp) {
            this.lastDetachTimestamp = lastDetachTimestamp;
            return this;
        }

        @Override
        public DiskInfo build() {
            return new DiskInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setGeneratedId(String var1);

        public abstract Builder setConfiguration(DiskConfiguration var1);

        public abstract Builder setDiskId(DiskId var1);

        abstract Builder setCreationTimestamp(Long var1);

        abstract Builder setCreationStatus(CreationStatus var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setLicenses(List<LicenseId> var1);

        abstract Builder setAttachedInstances(List<InstanceId> var1);

        abstract Builder setLastAttachTimestamp(Long var1);

        abstract Builder setLastDetachTimestamp(Long var1);

        public abstract DiskInfo build();
    }

    public static enum CreationStatus {
        CREATING,
        FAILED,
        READY,
        RESTORING;

    }
}

