/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Operation;
import com.google.cloud.Clock;
import com.google.cloud.WaitForOption;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Operation
implements Serializable {
    private static final long serialVersionUID = -8979001444590023899L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private transient Compute compute;
    private final ComputeOptions options;
    private final String generatedId;
    private final OperationId operationId;
    private final String clientOperationId;
    private final String operationType;
    private final String targetLink;
    private final String targetId;
    private final Status status;
    private final String statusMessage;
    private final String user;
    private final Integer progress;
    private final Long insertTime;
    private final Long startTime;
    private final Long endTime;
    private final List<OperationError> errors;
    private final List<OperationWarning> warnings;
    private final Integer httpErrorStatusCode;
    private final String httpErrorMessage;
    private final String description;

    private Operation(Builder builder) {
        this.compute = (Compute)Preconditions.checkNotNull((Object)builder.compute);
        this.options = (ComputeOptions)this.compute.options();
        this.generatedId = builder.generatedId;
        this.operationId = (OperationId)Preconditions.checkNotNull((Object)builder.operationId);
        this.clientOperationId = builder.clientOperationId;
        this.operationType = builder.operationType;
        this.targetLink = builder.targetLink;
        this.targetId = builder.targetId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.user = builder.user;
        this.progress = builder.progress;
        this.insertTime = builder.insertTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errors = builder.errors != null ? ImmutableList.copyOf((Collection)builder.errors) : null;
        this.warnings = builder.warnings != null ? ImmutableList.copyOf((Collection)builder.warnings) : null;
        this.httpErrorStatusCode = builder.httpErrorStatusCode;
        this.httpErrorMessage = builder.httpErrorMessage;
        this.description = builder.description;
    }

    public Compute compute() {
        return this.compute;
    }

    public String generatedId() {
        return this.generatedId;
    }

    public <T extends OperationId> T operationId() {
        return (T)this.operationId;
    }

    String clientOperationId() {
        return this.clientOperationId;
    }

    public String operationType() {
        return this.operationType;
    }

    public String targetLink() {
        return this.targetLink;
    }

    public String targetId() {
        return this.targetId;
    }

    public Status status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String user() {
        return this.user;
    }

    public Integer progress() {
        return this.progress;
    }

    public Long insertTime() {
        return this.insertTime;
    }

    public Long startTime() {
        return this.startTime;
    }

    public Long endTime() {
        return this.endTime;
    }

    public List<OperationError> errors() {
        return this.errors;
    }

    public List<OperationWarning> warnings() {
        return this.warnings;
    }

    public Integer httpErrorStatusCode() {
        return this.httpErrorStatusCode;
    }

    public String httpErrorMessage() {
        return this.httpErrorMessage;
    }

    public String description() {
        return this.description;
    }

    public boolean exists() {
        return this.reload(Compute.OperationOption.fields(new Compute.OperationField[0])) != null;
    }

    public boolean isDone() {
        Operation operation = this.compute.getOperation(this.operationId, Compute.OperationOption.fields(Compute.OperationField.STATUS));
        return operation == null || operation.status() == Status.DONE;
    }

    public Operation waitFor(WaitForOption ... waitOptions) throws InterruptedException, TimeoutException {
        WaitForOption.Timeout timeout = WaitForOption.Timeout.getOrDefault((WaitForOption[])waitOptions);
        WaitForOption.CheckingPeriod checkingPeriod = WaitForOption.CheckingPeriod.getOrDefault((WaitForOption[])waitOptions);
        long timeoutMillis = timeout.timeoutMillis();
        Clock clock = this.options.clock();
        long startTime = clock.millis();
        while (!this.isDone()) {
            if (timeoutMillis != -1L && clock.millis() - startTime >= timeoutMillis) {
                throw new TimeoutException();
            }
            checkingPeriod.sleep();
        }
        return this.reload(new Compute.OperationOption[0]);
    }

    public Operation reload(Compute.OperationOption ... options) {
        return this.compute.getOperation(this.operationId, options);
    }

    public boolean delete() {
        return this.compute.deleteOperation(this.operationId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("operationsId", (Object)this.operationId).add("clientOperationId", (Object)this.clientOperationId).add("operationType", (Object)this.operationType).add("targetLink", (Object)this.targetLink).add("targetId", (Object)this.targetId).add("status", (Object)this.status).add("statusMessage", (Object)this.statusMessage).add("user", (Object)this.user).add("progress", (Object)this.progress).add("insertTime", (Object)this.insertTime).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("errors", this.errors).add("warnings", this.warnings).add("httpErrorStatusCode", (Object)this.httpErrorStatusCode).add("httpErrorMessage", (Object)this.httpErrorMessage).add("description", (Object)this.description).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.operationId);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Operation.class)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    com.google.api.services.compute.model.Operation toPb() {
        com.google.api.services.compute.model.Operation operationPb = new com.google.api.services.compute.model.Operation();
        if (this.generatedId != null) {
            operationPb.setId(new BigInteger(this.generatedId));
        }
        operationPb.setName(this.operationId.operation());
        operationPb.setClientOperationId(this.clientOperationId);
        switch (this.operationId.type()) {
            case REGION: {
                operationPb.setRegion(((RegionOperationId)this.operationId()).regionId().selfLink());
                break;
            }
            case ZONE: {
                operationPb.setZone(((ZoneOperationId)this.operationId()).zoneId().selfLink());
            }
        }
        if (this.operationType != null) {
            operationPb.setOperationType(this.operationType);
        }
        operationPb.setTargetLink(this.targetLink);
        if (this.targetId != null) {
            operationPb.setTargetId(new BigInteger(this.targetId));
        }
        if (this.status != null) {
            operationPb.setStatus(this.status.name());
        }
        operationPb.setStatusMessage(this.statusMessage);
        operationPb.setUser(this.user);
        operationPb.setProgress(this.progress);
        if (this.insertTime != null) {
            operationPb.setInsertTime(TIMESTAMP_FORMATTER.print(this.insertTime.longValue()));
        }
        if (this.startTime != null) {
            operationPb.setStartTime(TIMESTAMP_FORMATTER.print(this.startTime.longValue()));
        }
        if (this.endTime != null) {
            operationPb.setEndTime(TIMESTAMP_FORMATTER.print(this.endTime.longValue()));
        }
        if (this.errors != null) {
            operationPb.setError(new Operation.Error().setErrors(Lists.transform(this.errors, OperationError.TO_PB_FUNCTION)));
        }
        if (this.warnings != null) {
            operationPb.setWarnings(Lists.transform(this.warnings, OperationWarning.TO_PB_FUNCTION));
        }
        operationPb.setHttpErrorStatusCode(this.httpErrorStatusCode);
        operationPb.setHttpErrorMessage(this.httpErrorMessage);
        operationPb.setSelfLink(this.operationId.selfLink());
        operationPb.setDescription(this.description);
        return operationPb;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Operation fromPb(Compute compute, com.google.api.services.compute.model.Operation operationPb) {
        return new Builder(compute, operationPb).build();
    }

    static final class Builder {
        private Compute compute;
        private String generatedId;
        private OperationId operationId;
        private String clientOperationId;
        private String operationType;
        private String targetLink;
        private String targetId;
        private Status status;
        private String statusMessage;
        private String user;
        private Integer progress;
        private Long insertTime;
        private Long startTime;
        private Long endTime;
        private List<OperationError> errors;
        private List<OperationWarning> warnings;
        private Integer httpErrorStatusCode;
        private String httpErrorMessage;
        private String description;

        Builder(Compute compute) {
            this.compute = compute;
        }

        Builder(Compute compute, com.google.api.services.compute.model.Operation operationPb) {
            this.compute = compute;
            if (operationPb.getId() != null) {
                this.generatedId = operationPb.getId().toString();
            }
            this.operationId = RegionOperationId.matchesUrl(operationPb.getSelfLink()) ? RegionOperationId.fromUrl(operationPb.getSelfLink()) : (ZoneOperationId.matchesUrl(operationPb.getSelfLink()) ? ZoneOperationId.fromUrl(operationPb.getSelfLink()) : GlobalOperationId.fromUrl(operationPb.getSelfLink()));
            this.clientOperationId = operationPb.getClientOperationId();
            this.operationType = operationPb.getOperationType();
            this.targetLink = operationPb.getTargetLink();
            if (operationPb.getTargetId() != null) {
                this.targetId = operationPb.getTargetId().toString();
            }
            if (operationPb.getStatus() != null) {
                this.status = Status.valueOf(operationPb.getStatus());
            }
            this.statusMessage = operationPb.getStatusMessage();
            this.user = operationPb.getUser();
            this.progress = operationPb.getProgress();
            if (operationPb.getInsertTime() != null) {
                this.insertTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getInsertTime());
            }
            if (operationPb.getStartTime() != null) {
                this.startTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getStartTime());
            }
            if (operationPb.getEndTime() != null) {
                this.endTime = TIMESTAMP_FORMATTER.parseMillis(operationPb.getEndTime());
            }
            if (operationPb.getError() != null && operationPb.getError().getErrors() != null) {
                this.errors = Lists.transform((List)operationPb.getError().getErrors(), OperationError.FROM_PB_FUNCTION);
            }
            if (operationPb.getWarnings() != null) {
                this.warnings = Lists.transform((List)operationPb.getWarnings(), OperationWarning.FROM_PB_FUNCTION);
            }
            this.httpErrorStatusCode = operationPb.getHttpErrorStatusCode();
            this.httpErrorMessage = operationPb.getHttpErrorMessage();
            this.description = operationPb.getDescription();
        }

        Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder operationId(OperationId operationId) {
            this.operationId = (OperationId)Preconditions.checkNotNull((Object)operationId);
            return this;
        }

        Builder clientOperationId(String clientOperationId) {
            this.clientOperationId = clientOperationId;
            return this;
        }

        Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        Builder targetLink(String targetLink) {
            this.targetLink = targetLink;
            return this;
        }

        Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        Builder status(Status status) {
            this.status = status;
            return this;
        }

        Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        Builder insertTime(Long insertTime) {
            this.insertTime = insertTime;
            return this;
        }

        Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder errors(List<OperationError> errors) {
            this.errors = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(errors)));
            return this;
        }

        Builder warnings(List<OperationWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(warnings)));
            return this;
        }

        Builder httpErrorStatusCode(Integer httpErrorStatusCode) {
            this.httpErrorStatusCode = httpErrorStatusCode;
            return this;
        }

        Builder httpErrorMessage(String httpErrorMessage) {
            this.httpErrorMessage = httpErrorMessage;
            return this;
        }

        Builder description(String description) {
            this.description = description;
            return this;
        }

        Operation build() {
            return new Operation(this);
        }
    }

    public static final class OperationWarning
    implements Serializable {
        static final Function<Operation.Warnings, OperationWarning> FROM_PB_FUNCTION = new Function<Operation.Warnings, OperationWarning>(){

            public OperationWarning apply(Operation.Warnings pb) {
                return OperationWarning.fromPb(pb);
            }
        };
        static final Function<OperationWarning, Operation.Warnings> TO_PB_FUNCTION = new Function<OperationWarning, Operation.Warnings>(){

            public Operation.Warnings apply(OperationWarning operation) {
                return operation.toPb();
            }
        };
        private static final long serialVersionUID = 4917326627380228928L;
        private final String code;
        private final String message;
        private final Map<String, String> metadata;

        OperationWarning(String code, String message, Map<String, String> metadata) {
            this.code = code;
            this.metadata = metadata != null ? ImmutableMap.copyOf(metadata) : null;
            this.message = message;
        }

        public String code() {
            return this.code;
        }

        public String message() {
            return this.message;
        }

        public Map<String, String> metadata() {
            return this.metadata;
        }

        Operation.Warnings toPb() {
            Operation.Warnings warningPb = new Operation.Warnings().setCode(this.code).setMessage(this.message);
            if (this.metadata != null) {
                ArrayList metadataPb = Lists.newArrayListWithCapacity((int)this.metadata.size());
                for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                    metadataPb.add(new Operation.Warnings.Data().setKey(entry.getKey()).setValue(entry.getValue()));
                }
                warningPb.setData((List)metadataPb);
            }
            return warningPb;
        }

        static OperationWarning fromPb(Operation.Warnings warningPb) {
            HashMap metadata = null;
            if (warningPb.getData() != null) {
                metadata = Maps.newHashMapWithExpectedSize((int)warningPb.getData().size());
                for (Operation.Warnings.Data data : warningPb.getData()) {
                    metadata.put(data.getKey(), data.getValue());
                }
            }
            return new OperationWarning(warningPb.getCode(), warningPb.getMessage(), metadata);
        }

        public boolean equals(Object obj) {
            return obj instanceof OperationWarning && Objects.equals(this.code, ((OperationWarning)obj).code) && Objects.equals(this.message, ((OperationWarning)obj).message) && Objects.equals(this.metadata, ((OperationWarning)obj).metadata);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("message", (Object)this.message).add("metadata", this.metadata).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.message, this.metadata);
        }
    }

    public static final class OperationError
    implements Serializable {
        static final Function<Operation.Error.Errors, OperationError> FROM_PB_FUNCTION = new Function<Operation.Error.Errors, OperationError>(){

            public OperationError apply(Operation.Error.Errors pb) {
                return OperationError.fromPb(pb);
            }
        };
        static final Function<OperationError, Operation.Error.Errors> TO_PB_FUNCTION = new Function<OperationError, Operation.Error.Errors>(){

            public Operation.Error.Errors apply(OperationError operation) {
                return operation.toPb();
            }
        };
        private static final long serialVersionUID = -1155314394806515873L;
        private final String code;
        private final String location;
        private final String message;

        OperationError(String code, String location, String message) {
            this.code = code;
            this.location = location;
            this.message = message;
        }

        public String code() {
            return this.code;
        }

        public String location() {
            return this.location;
        }

        public String message() {
            return this.message;
        }

        Operation.Error.Errors toPb() {
            return new Operation.Error.Errors().setCode(this.code).setLocation(this.location).setMessage(this.message);
        }

        static OperationError fromPb(Operation.Error.Errors errorPb) {
            return new OperationError(errorPb.getCode(), errorPb.getLocation(), errorPb.getMessage());
        }

        public boolean equals(Object obj) {
            return obj instanceof OperationError && Objects.equals(this.code, ((OperationError)obj).code) && Objects.equals(this.message, ((OperationError)obj).message) && Objects.equals(this.location, ((OperationError)obj).location);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("location", (Object)this.location).add("message", (Object)this.message).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.location, this.message);
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        DONE;

    }
}

