/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.ZoneId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InstanceId
extends ResourceId {
    static final Function<String, InstanceId> FROM_URL_FUNCTION = new Function<String, InstanceId>(){

        public InstanceId apply(String pb) {
            return InstanceId.fromUrl(pb);
        }
    };
    static final Function<InstanceId, String> TO_URL_FUNCTION = new Function<InstanceId, String>(){

        public String apply(InstanceId instanceId) {
            return instanceId.selfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)/instances/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)/instances/([^/]+)");
    private static final long serialVersionUID = -2787043125223159922L;
    private final String zone;
    private final String instance;

    private InstanceId(String project, String zone, String instance) {
        super(project);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
        this.instance = (String)Preconditions.checkNotNull((Object)instance);
    }

    public String instance() {
        return this.instance;
    }

    public String zone() {
        return this.zone;
    }

    public ZoneId zoneId() {
        return ZoneId.of(this.project(), this.zone);
    }

    @Override
    public String selfLink() {
        return super.selfLink() + "/zones/" + this.zone + "/instances/" + this.instance;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("zone", (Object)this.zone).add("instance", (Object)this.instance);
    }

    public int hashCode() {
        return Objects.hash(super.baseHashCode(), this.zone, this.instance);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InstanceId)) {
            return false;
        }
        InstanceId other = (InstanceId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone) && Objects.equals(this.instance, other.instance);
    }

    @Override
    InstanceId setProjectId(String projectId) {
        if (this.project() != null) {
            return this;
        }
        return InstanceId.of(projectId, this.zone, this.instance);
    }

    public static InstanceId of(ZoneId zoneId, String instance) {
        return new InstanceId(zoneId.project(), zoneId.zone(), instance);
    }

    public static InstanceId of(String zone, String instance) {
        return new InstanceId(null, zone, instance);
    }

    public static InstanceId of(String project, String zone, String instance) {
        return new InstanceId(project, zone, instance);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static InstanceId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid instance URL");
        }
        return InstanceId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

