/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.LicenseId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class AttachedDisk
implements Serializable {
    static final Function<com.google.api.services.compute.model.AttachedDisk, AttachedDisk> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.AttachedDisk, AttachedDisk>(){

        public AttachedDisk apply(com.google.api.services.compute.model.AttachedDisk pb) {
            return AttachedDisk.fromPb(pb);
        }
    };
    static final Function<AttachedDisk, com.google.api.services.compute.model.AttachedDisk> TO_PB_FUNCTION = new Function<AttachedDisk, com.google.api.services.compute.model.AttachedDisk>(){

        public com.google.api.services.compute.model.AttachedDisk apply(AttachedDisk attachedDisk) {
            return attachedDisk.toPb();
        }
    };
    private static final long serialVersionUID = 2969789134157943798L;
    private final String deviceName;
    private final Integer index;
    private final AttachedDiskConfiguration configuration;
    private final List<LicenseId> licenses;

    private AttachedDisk(Builder builder) {
        this.deviceName = builder.deviceName;
        this.index = builder.index;
        this.configuration = builder.configuration;
        this.licenses = builder.licenses;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Integer getIndex() {
        return this.index;
    }

    public <T extends AttachedDiskConfiguration> T getConfiguration() {
        return (T)this.configuration;
    }

    public List<LicenseId> getLicenses() {
        return this.licenses;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceName", (Object)this.deviceName).add("index", (Object)this.index).add("configuration", (Object)this.configuration).add("licenses", this.licenses).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.deviceName, this.index, this.configuration, this.licenses);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(AttachedDisk.class) && Objects.equals(this.toPb(), ((AttachedDisk)obj).toPb());
    }

    AttachedDisk setProjectId(String projectId) {
        return this.toBuilder().setConfiguration(this.configuration.setProjectId(projectId)).build();
    }

    com.google.api.services.compute.model.AttachedDisk toPb() {
        com.google.api.services.compute.model.AttachedDisk attachedDiskPb = this.configuration.toPb();
        attachedDiskPb.setDeviceName(this.deviceName);
        attachedDiskPb.setIndex(this.index);
        if (this.licenses != null) {
            attachedDiskPb.setLicenses(Lists.transform(this.licenses, LicenseId.TO_URL_FUNCTION));
        }
        return attachedDiskPb;
    }

    public static Builder newBuilder(AttachedDiskConfiguration configuration) {
        return new Builder(configuration);
    }

    public static AttachedDisk of(AttachedDiskConfiguration configuration) {
        return AttachedDisk.newBuilder(configuration).build();
    }

    public static AttachedDisk of(String deviceName, AttachedDiskConfiguration configuration) {
        return AttachedDisk.newBuilder(configuration).setDeviceName(deviceName).build();
    }

    static AttachedDisk fromPb(com.google.api.services.compute.model.AttachedDisk diskPb) {
        Object configuration = AttachedDiskConfiguration.fromPb(diskPb);
        Builder builder = AttachedDisk.newBuilder(configuration);
        builder.setDeviceName(diskPb.getDeviceName());
        builder.setIndex(diskPb.getIndex());
        if (diskPb.getLicenses() != null) {
            builder.setLicenses(Lists.transform((List)diskPb.getLicenses(), LicenseId.FROM_URL_FUNCTION));
        }
        return builder.build();
    }

    public static final class Builder {
        private String deviceName;
        private Integer index;
        private AttachedDiskConfiguration configuration;
        private List<LicenseId> licenses;

        Builder(AttachedDiskConfiguration configuration) {
            this.configuration = (AttachedDiskConfiguration)Preconditions.checkNotNull((Object)configuration);
        }

        Builder(AttachedDisk attachedDisk) {
            this.deviceName = attachedDisk.deviceName;
            this.index = attachedDisk.index;
            this.configuration = attachedDisk.configuration;
            this.licenses = attachedDisk.licenses;
        }

        public Builder setDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public Builder setConfiguration(AttachedDiskConfiguration configuration) {
            this.configuration = (AttachedDiskConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        Builder setLicenses(List<LicenseId> licenses) {
            this.licenses = licenses;
            return this;
        }

        public AttachedDisk build() {
            return new AttachedDisk(this);
        }
    }

    public static final class ScratchDiskConfiguration
    extends AttachedDiskConfiguration {
        private static final long serialVersionUID = -8445453507234691254L;
        private final DiskTypeId diskType;

        private ScratchDiskConfiguration(Builder builder) {
            super(AttachedDiskConfiguration.Type.SCRATCH, builder.interfaceType, false, true);
            this.diskType = builder.diskType;
        }

        public DiskTypeId getDiskType() {
            return this.diskType;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("diskType", (Object)this.diskType);
        }

        public int hashCode() {
            return Objects.hash(this.baseHashCode());
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(ScratchDiskConfiguration.class) && this.baseEquals((ScratchDiskConfiguration)obj);
        }

        @Override
        ScratchDiskConfiguration setProjectId(String projectId) {
            if (this.diskType.getProject() != null) {
                return this;
            }
            return this.toBuilder().setDiskType(this.diskType.setProjectId(projectId)).build();
        }

        @Override
        com.google.api.services.compute.model.AttachedDisk toPb() {
            com.google.api.services.compute.model.AttachedDisk attachedDiskPb = super.toPb();
            if (this.diskType != null) {
                AttachedDiskInitializeParams initializeParamsPb = new AttachedDiskInitializeParams();
                initializeParamsPb.setDiskType(this.diskType.getSelfLink());
                attachedDiskPb.setInitializeParams(initializeParamsPb);
            }
            return attachedDiskPb;
        }

        public static Builder newBuilder(DiskTypeId diskType) {
            return new Builder().setDiskType(diskType);
        }

        public static ScratchDiskConfiguration of(DiskTypeId diskType) {
            return ScratchDiskConfiguration.newBuilder(diskType).build();
        }

        static ScratchDiskConfiguration fromPb(com.google.api.services.compute.model.AttachedDisk diskPb) {
            Builder builder = new Builder();
            if (diskPb.getInterface() != null) {
                builder.setInterfaceType(AttachedDiskConfiguration.InterfaceType.valueOf(diskPb.getInterface()));
            }
            if (diskPb.getInitializeParams() != null && diskPb.getInitializeParams().getDiskType() != null) {
                builder.setDiskType(DiskTypeId.fromUrl(diskPb.getInitializeParams().getDiskType()));
            }
            return builder.build();
        }

        public static final class Builder {
            private DiskTypeId diskType;
            private AttachedDiskConfiguration.InterfaceType interfaceType;

            private Builder() {
            }

            private Builder(ScratchDiskConfiguration configuration) {
                this.diskType = configuration.diskType;
                this.interfaceType = configuration.getInterfaceType();
            }

            public Builder setDiskType(DiskTypeId diskType) {
                this.diskType = diskType;
                return this;
            }

            public Builder setInterfaceType(AttachedDiskConfiguration.InterfaceType interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            public ScratchDiskConfiguration build() {
                return new ScratchDiskConfiguration(this);
            }
        }
    }

    public static final class CreateDiskConfiguration
    extends AttachedDiskConfiguration {
        private static final long serialVersionUID = 961995522284348824L;
        private final String diskName;
        private final DiskTypeId diskType;
        private final Long diskSizeGb;
        private final ImageId sourceImage;

        private CreateDiskConfiguration(Builder builder) {
            super(AttachedDiskConfiguration.Type.PERSISTENT, null, true, builder.autoDelete);
            this.diskName = builder.diskName;
            this.diskType = builder.diskType;
            this.diskSizeGb = builder.diskSizeGb;
            this.sourceImage = builder.sourceImage;
        }

        public String getDiskName() {
            return this.diskName;
        }

        public DiskTypeId getDiskType() {
            return this.diskType;
        }

        public Long getDiskSizeGb() {
            return this.diskSizeGb;
        }

        public ImageId getSourceImage() {
            return this.sourceImage;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("diskName", (Object)this.diskName).add("diskType", (Object)this.diskType).add("diskSizeGb", (Object)this.diskSizeGb).add("sourceImage", (Object)this.sourceImage);
        }

        public int hashCode() {
            return Objects.hash(this.baseHashCode(), this.diskName, this.diskType, this.diskSizeGb, this.sourceImage);
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(CreateDiskConfiguration.class) && this.baseEquals((CreateDiskConfiguration)obj);
        }

        @Override
        CreateDiskConfiguration setProjectId(String projectId) {
            Builder builder = this.toBuilder();
            if (builder.diskType != null) {
                builder.setDiskType(this.diskType.setProjectId(projectId));
            }
            if (builder.sourceImage != null) {
                builder.setSourceImage(this.sourceImage.setProjectId(projectId));
            }
            return builder.build();
        }

        @Override
        com.google.api.services.compute.model.AttachedDisk toPb() {
            AttachedDiskInitializeParams initializeParamsPb = new AttachedDiskInitializeParams();
            initializeParamsPb.setDiskName(this.diskName);
            initializeParamsPb.setDiskSizeGb(this.diskSizeGb);
            initializeParamsPb.setSourceImage(this.sourceImage.getSelfLink());
            if (this.diskType != null) {
                initializeParamsPb.setDiskType(this.diskType.getSelfLink());
            }
            com.google.api.services.compute.model.AttachedDisk attachedDiskPb = super.toPb();
            attachedDiskPb.setInitializeParams(initializeParamsPb);
            return attachedDiskPb;
        }

        public static Builder newBuilder(ImageId sourceImage) {
            return new Builder(sourceImage);
        }

        public static CreateDiskConfiguration of(ImageId sourceImage) {
            return CreateDiskConfiguration.newBuilder(sourceImage).build();
        }

        static CreateDiskConfiguration fromPb(com.google.api.services.compute.model.AttachedDisk diskPb) {
            AttachedDiskInitializeParams initializeParamsPb = diskPb.getInitializeParams();
            Builder builder = CreateDiskConfiguration.newBuilder(ImageId.fromUrl(initializeParamsPb.getSourceImage()));
            if (initializeParamsPb.getDiskType() != null) {
                builder.setDiskType(DiskTypeId.fromUrl(initializeParamsPb.getDiskType()));
            }
            builder.setDiskName(initializeParamsPb.getDiskName());
            builder.setDiskSizeGb(initializeParamsPb.getDiskSizeGb());
            builder.setAutoDelete(diskPb.getAutoDelete());
            if (initializeParamsPb.getDiskType() != null) {
                builder.setDiskType(DiskTypeId.fromUrl(initializeParamsPb.getDiskType()));
            }
            return builder.build();
        }

        public static final class Builder {
            private String diskName;
            private DiskTypeId diskType;
            private Long diskSizeGb;
            private ImageId sourceImage;
            private Boolean autoDelete;

            private Builder(ImageId sourceImage) {
                this.sourceImage = (ImageId)Preconditions.checkNotNull((Object)sourceImage);
            }

            private Builder(CreateDiskConfiguration configuration) {
                this.diskName = configuration.diskName;
                this.diskType = configuration.diskType;
                this.diskSizeGb = configuration.diskSizeGb;
                this.sourceImage = configuration.sourceImage;
                this.autoDelete = configuration.autoDelete();
            }

            public Builder setDiskName(String diskName) {
                this.diskName = diskName;
                return this;
            }

            public Builder setDiskType(DiskTypeId diskType) {
                this.diskType = diskType;
                return this;
            }

            public Builder setDiskSizeGb(Long diskSizeGb) {
                this.diskSizeGb = diskSizeGb;
                return this;
            }

            public Builder setSourceImage(ImageId sourceImage) {
                this.sourceImage = (ImageId)Preconditions.checkNotNull((Object)sourceImage);
                return this;
            }

            public Builder setAutoDelete(Boolean autoDelete) {
                this.autoDelete = autoDelete;
                return this;
            }

            public CreateDiskConfiguration build() {
                return new CreateDiskConfiguration(this);
            }
        }
    }

    public static final class PersistentDiskConfiguration
    extends AttachedDiskConfiguration {
        private static final long serialVersionUID = 6367613188140104726L;
        private final DiskId sourceDisk;
        private final Mode mode;

        private PersistentDiskConfiguration(Builder builder) {
            super(AttachedDiskConfiguration.Type.PERSISTENT, null, builder.boot, builder.autoDelete);
            this.sourceDisk = builder.sourceDisk;
            this.mode = builder.mode;
        }

        public DiskId getSourceDisk() {
            return this.sourceDisk;
        }

        public Mode getMode() {
            return this.mode;
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("sourceDisk", (Object)this.sourceDisk).add("mode", (Object)this.mode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.baseHashCode(), this.sourceDisk, this.mode});
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(PersistentDiskConfiguration.class) && this.baseEquals((PersistentDiskConfiguration)obj);
        }

        @Override
        PersistentDiskConfiguration setProjectId(String projectId) {
            if (this.sourceDisk.getProject() != null) {
                return this;
            }
            return this.toBuilder().setSourceDisk(this.sourceDisk.setProjectId(projectId)).build();
        }

        @Override
        com.google.api.services.compute.model.AttachedDisk toPb() {
            com.google.api.services.compute.model.AttachedDisk attachedDiskPb = super.toPb();
            attachedDiskPb.setSource(this.sourceDisk.getSelfLink());
            attachedDiskPb.setMode(this.mode != null ? this.mode.toString() : null);
            return attachedDiskPb;
        }

        public static Builder newBuilder(DiskId sourceDisk) {
            return new Builder(sourceDisk);
        }

        public static PersistentDiskConfiguration of(DiskId sourceDisk) {
            return PersistentDiskConfiguration.newBuilder(sourceDisk).build();
        }

        static PersistentDiskConfiguration fromPb(com.google.api.services.compute.model.AttachedDisk diskPb) {
            Builder builder = new Builder(DiskId.fromUrl(diskPb.getSource()));
            if (diskPb.getMode() != null) {
                builder.setMode(Mode.valueOf(diskPb.getMode()));
            }
            if (diskPb.getBoot() != null) {
                builder.setBoot(diskPb.getBoot());
            }
            if (diskPb.getAutoDelete() != null) {
                builder.setAutoDelete(diskPb.getAutoDelete());
            }
            return builder.build();
        }

        public static final class Builder {
            private DiskId sourceDisk;
            private Mode mode;
            private Boolean boot;
            private Boolean autoDelete;

            private Builder(DiskId sourceDisk) {
                this.sourceDisk = (DiskId)Preconditions.checkNotNull((Object)sourceDisk);
            }

            private Builder(PersistentDiskConfiguration configuration) {
                this.sourceDisk = configuration.sourceDisk;
                this.mode = configuration.mode;
                this.boot = configuration.boot();
                this.autoDelete = configuration.autoDelete();
            }

            public Builder setSourceDisk(DiskId sourceDisk) {
                this.sourceDisk = (DiskId)Preconditions.checkNotNull((Object)sourceDisk);
                return this;
            }

            public Builder setMode(Mode mode) {
                this.mode = mode;
                return this;
            }

            public Builder setBoot(boolean boot) {
                this.boot = boot;
                return this;
            }

            public Builder setAutoDelete(boolean autoDelete) {
                this.autoDelete = autoDelete;
                return this;
            }

            public PersistentDiskConfiguration build() {
                return new PersistentDiskConfiguration(this);
            }
        }

        public static enum Mode {
            READ_WRITE,
            READ_ONLY;

        }
    }

    public static abstract class AttachedDiskConfiguration
    implements Serializable {
        private static final long serialVersionUID = 8813134841283115565L;
        private final Type type;
        private final InterfaceType interfaceType;
        private final Boolean boot;
        private final Boolean autoDelete;

        AttachedDiskConfiguration(Type type, InterfaceType interfaceType, Boolean boot, Boolean autoDelete) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            this.interfaceType = interfaceType;
            this.boot = boot;
            this.autoDelete = autoDelete;
        }

        public Type getType() {
            return this.type;
        }

        public InterfaceType getInterfaceType() {
            return this.interfaceType;
        }

        public Boolean boot() {
            return this.boot;
        }

        public Boolean autoDelete() {
            return this.autoDelete;
        }

        MoreObjects.ToStringHelper toStringHelper() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("interfaceType", (Object)this.interfaceType).add("boot", (Object)this.boot).add("autoDelete", (Object)this.autoDelete);
        }

        public String toString() {
            return this.toStringHelper().toString();
        }

        final int baseHashCode() {
            return Objects.hash(new Object[]{this.type, this.interfaceType});
        }

        final boolean baseEquals(AttachedDiskConfiguration diskConfiguration) {
            return Objects.equals(this.toPb(), diskConfiguration.toPb());
        }

        abstract AttachedDiskConfiguration setProjectId(String var1);

        com.google.api.services.compute.model.AttachedDisk toPb() {
            com.google.api.services.compute.model.AttachedDisk attachedDiskPb = new com.google.api.services.compute.model.AttachedDisk();
            attachedDiskPb.setType(this.type.name());
            if (this.interfaceType != null) {
                attachedDiskPb.setInterface(this.interfaceType.name());
            }
            attachedDiskPb.setBoot(this.boot);
            attachedDiskPb.setAutoDelete(this.autoDelete);
            return attachedDiskPb;
        }

        static <T extends AttachedDiskConfiguration> T fromPb(com.google.api.services.compute.model.AttachedDisk diskPb) {
            switch (Type.valueOf(diskPb.getType())) {
                case PERSISTENT: {
                    if (diskPb.getSource() == null) {
                        return (T)CreateDiskConfiguration.fromPb(diskPb);
                    }
                    return (T)PersistentDiskConfiguration.fromPb(diskPb);
                }
                case SCRATCH: {
                    return (T)ScratchDiskConfiguration.fromPb(diskPb);
                }
            }
            throw new IllegalArgumentException("Unrecognized attached disk type");
        }

        public static enum InterfaceType {
            SCSI,
            NVME;

        }

        public static enum Type {
            PERSISTENT,
            SCRATCH;

        }
    }
}

