/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Instance;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.ServiceAccount;
import com.google.cloud.compute.Tags;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class InstanceInfo
implements Serializable {
    static final Function<Instance, InstanceInfo> FROM_PB_FUNCTION = new Function<Instance, InstanceInfo>(){

        public InstanceInfo apply(Instance pb) {
            return InstanceInfo.fromPb(pb);
        }
    };
    static final Function<InstanceInfo, Instance> TO_PB_FUNCTION = new Function<InstanceInfo, Instance>(){

        public Instance apply(InstanceInfo instance) {
            return instance.toPb();
        }
    };
    private static final long serialVersionUID = -6601223112628977168L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final InstanceId instanceId;
    private final Long creationTimestamp;
    private final String description;
    private final Status status;
    private final String statusMessage;
    private final Tags tags;
    private final MachineTypeId machineType;
    private final Boolean canIpForward;
    private final List<NetworkInterface> networkInterfaces;
    private final List<AttachedDisk> attachedDisks;
    private final Metadata metadata;
    private final List<ServiceAccount> serviceAccounts;
    private final SchedulingOptions schedulingOptions;
    private final String cpuPlatform;

    InstanceInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.instanceId = builder.instanceId;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.machineType = builder.machineType;
        this.canIpForward = builder.canIpForward;
        this.networkInterfaces = builder.networkInterfaces;
        this.attachedDisks = builder.attachedDisks;
        this.metadata = builder.metadata;
        this.serviceAccounts = builder.serviceAccounts;
        this.schedulingOptions = builder.schedulingOptions;
        this.cpuPlatform = builder.cpuPlatform;
    }

    public String generatedId() {
        return this.generatedId;
    }

    public InstanceId instanceId() {
        return this.instanceId;
    }

    public Long creationTimestamp() {
        return this.creationTimestamp;
    }

    public String description() {
        return this.description;
    }

    public Status status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Tags tags() {
        return this.tags;
    }

    public MachineTypeId machineType() {
        return this.machineType;
    }

    public Boolean canIpForward() {
        return this.canIpForward;
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public List<AttachedDisk> attachedDisks() {
        return this.attachedDisks;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public List<ServiceAccount> serviceAccounts() {
        return this.serviceAccounts;
    }

    public SchedulingOptions schedulingOptions() {
        return this.schedulingOptions;
    }

    public String cpuPlatform() {
        return this.cpuPlatform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("instanceId", (Object)this.instanceId).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("status", (Object)this.status).add("statusMessage", (Object)this.statusMessage).add("tags", (Object)this.tags).add("machineType", (Object)this.machineType).add("canIpForward", (Object)this.canIpForward).add("networkInterfaces", this.networkInterfaces).add("attachedDisks", this.attachedDisks).add("metadata", (Object)this.metadata).add("serviceAccounts", this.serviceAccounts).add("schedulingOptions", (Object)this.schedulingOptions).add("cpuPlatform", (Object)this.cpuPlatform).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.generatedId, this.instanceId, this.creationTimestamp, this.description, this.status, this.statusMessage, this.tags, this.machineType, this.canIpForward, this.networkInterfaces, this.attachedDisks, this.metadata, this.serviceAccounts, this.schedulingOptions, this.cpuPlatform});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(InstanceInfo.class) && Objects.equals(this.toPb(), ((InstanceInfo)obj).toPb());
    }

    InstanceInfo setProjectId(final String projectId) {
        Builder builder = this.toBuilder();
        builder.networkInterfaces(Lists.transform(this.networkInterfaces, (Function)new Function<NetworkInterface, NetworkInterface>(){

            public NetworkInterface apply(NetworkInterface networkInterface) {
                return networkInterface.setProjectId(projectId);
            }
        }));
        builder.attachedDisks(Lists.transform(this.attachedDisks, (Function)new Function<AttachedDisk, AttachedDisk>(){

            public AttachedDisk apply(AttachedDisk attachedDisk) {
                return attachedDisk.setProjectId(projectId);
            }
        }));
        return builder.instanceId(this.instanceId.setProjectId(projectId)).machineType(this.machineType.setProjectId(projectId)).build();
    }

    Instance toPb() {
        Instance instancePb = new Instance();
        if (this.generatedId != null) {
            instancePb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            instancePb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        instancePb.setName(this.instanceId.instance());
        instancePb.setDescription(this.description);
        instancePb.setSelfLink(this.instanceId.selfLink());
        instancePb.setZone(this.instanceId.zoneId().selfLink());
        if (this.status != null) {
            instancePb.setStatus(this.status.name());
        }
        instancePb.setStatusMessage(this.statusMessage);
        if (this.tags != null) {
            instancePb.setTags(this.tags.toPb());
        }
        if (this.machineType != null) {
            instancePb.setMachineType(this.machineType.selfLink());
        }
        instancePb.setCanIpForward(this.canIpForward);
        if (this.networkInterfaces != null) {
            instancePb.setNetworkInterfaces(Lists.transform(this.networkInterfaces, NetworkInterface.TO_PB_FUNCTION));
        }
        if (this.attachedDisks != null) {
            instancePb.setDisks(Lists.transform(this.attachedDisks, AttachedDisk.TO_PB_FUNCTION));
        }
        if (this.metadata != null) {
            instancePb.setMetadata(this.metadata.toPb());
        }
        if (this.serviceAccounts != null) {
            instancePb.setServiceAccounts(Lists.transform(this.serviceAccounts, ServiceAccount.TO_PB_FUNCTION));
        }
        if (this.schedulingOptions != null) {
            instancePb.setScheduling(this.schedulingOptions.toPb());
        }
        instancePb.setCpuPlatform(this.cpuPlatform);
        return instancePb;
    }

    public static Builder builder(InstanceId instanceId, MachineTypeId machineType) {
        return new BuilderImpl(instanceId).machineType(machineType);
    }

    public static InstanceInfo of(InstanceId instanceId, MachineTypeId machineType, AttachedDisk disk, NetworkInterface networkInterface) {
        return InstanceInfo.builder(instanceId, machineType).attachedDisks((List<AttachedDisk>)ImmutableList.of((Object)disk)).networkInterfaces((List<NetworkInterface>)ImmutableList.of((Object)networkInterface)).build();
    }

    static InstanceInfo fromPb(Instance instancePb) {
        return new BuilderImpl(instancePb).build();
    }

    public static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private InstanceId instanceId;
        private Long creationTimestamp;
        private String description;
        private Status status;
        private String statusMessage;
        private Tags tags;
        private MachineTypeId machineType;
        private Boolean canIpForward;
        private List<NetworkInterface> networkInterfaces;
        private List<AttachedDisk> attachedDisks;
        private Metadata metadata;
        private List<ServiceAccount> serviceAccounts;
        private SchedulingOptions schedulingOptions;
        private String cpuPlatform;

        BuilderImpl(InstanceId instanceId) {
            this.instanceId = (InstanceId)Preconditions.checkNotNull((Object)instanceId);
        }

        BuilderImpl(InstanceInfo instance) {
            this.generatedId = instance.generatedId;
            this.instanceId = instance.instanceId;
            this.creationTimestamp = instance.creationTimestamp;
            this.description = instance.description;
            this.status = instance.status;
            this.statusMessage = instance.statusMessage;
            this.tags = instance.tags;
            this.machineType = instance.machineType;
            this.canIpForward = instance.canIpForward;
            this.networkInterfaces = instance.networkInterfaces;
            this.attachedDisks = instance.attachedDisks;
            this.metadata = instance.metadata;
            this.serviceAccounts = instance.serviceAccounts;
            this.schedulingOptions = instance.schedulingOptions;
            this.cpuPlatform = instance.cpuPlatform;
        }

        BuilderImpl(Instance instancePb) {
            if (instancePb.getId() != null) {
                this.generatedId = instancePb.getId().toString();
            }
            this.instanceId = InstanceId.fromUrl(instancePb.getSelfLink());
            if (instancePb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(instancePb.getCreationTimestamp());
            }
            this.description = instancePb.getDescription();
            if (instancePb.getStatus() != null) {
                this.status = Status.valueOf(instancePb.getStatus());
            }
            this.statusMessage = instancePb.getStatusMessage();
            if (instancePb.getTags() != null) {
                this.tags = Tags.fromPb(instancePb.getTags());
            }
            if (instancePb.getMachineType() != null) {
                this.machineType = MachineTypeId.fromUrl(instancePb.getMachineType());
            }
            this.canIpForward = instancePb.getCanIpForward();
            if (instancePb.getNetworkInterfaces() != null) {
                this.networkInterfaces = Lists.transform((List)instancePb.getNetworkInterfaces(), NetworkInterface.FROM_PB_FUNCTION);
            }
            if (instancePb.getDisks() != null) {
                this.attachedDisks = Lists.transform((List)instancePb.getDisks(), AttachedDisk.FROM_PB_FUNCTION);
            }
            if (instancePb.getMetadata() != null) {
                this.metadata = Metadata.fromPb(instancePb.getMetadata());
            }
            if (instancePb.getServiceAccounts() != null) {
                this.serviceAccounts = Lists.transform((List)instancePb.getServiceAccounts(), ServiceAccount.FROM_PB_FUNCTION);
            }
            if (instancePb.getScheduling() != null) {
                this.schedulingOptions = SchedulingOptions.fromPb(instancePb.getScheduling());
            }
            this.cpuPlatform = instancePb.getCpuPlatform();
        }

        @Override
        Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public Builder instanceId(InstanceId instanceId) {
            this.instanceId = (InstanceId)Preconditions.checkNotNull((Object)instanceId);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        Builder status(Status status) {
            this.status = status;
            return this;
        }

        @Override
        Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder machineType(MachineTypeId machineType) {
            this.machineType = (MachineTypeId)Preconditions.checkNotNull((Object)machineType);
            return this;
        }

        @Override
        public Builder canIpForward(Boolean canIpForward) {
            this.canIpForward = canIpForward;
            return this;
        }

        @Override
        public Builder networkInterfaces(List<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(networkInterfaces)));
            return this;
        }

        @Override
        public Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces = Arrays.asList(networkInterfaces);
            return this;
        }

        @Override
        public Builder attachedDisks(List<AttachedDisk> attachedDisks) {
            this.attachedDisks = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(attachedDisks)));
            return this;
        }

        @Override
        public Builder attachedDisks(AttachedDisk ... attachedDisks) {
            this.attachedDisks = Arrays.asList(attachedDisks);
            return this;
        }

        @Override
        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public Builder serviceAccounts(List<ServiceAccount> serviceAccounts) {
            this.serviceAccounts = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(serviceAccounts)));
            return this;
        }

        @Override
        public Builder schedulingOptions(SchedulingOptions schedulingOptions) {
            this.schedulingOptions = schedulingOptions;
            return this;
        }

        @Override
        Builder cpuPlatform(String cpuPlatform) {
            this.cpuPlatform = cpuPlatform;
            return this;
        }

        @Override
        public InstanceInfo build() {
            Preconditions.checkNotNull(this.attachedDisks);
            Preconditions.checkNotNull(this.networkInterfaces);
            return new InstanceInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder generatedId(String var1);

        public abstract Builder instanceId(InstanceId var1);

        abstract Builder creationTimestamp(Long var1);

        public abstract Builder description(String var1);

        abstract Builder status(Status var1);

        abstract Builder statusMessage(String var1);

        public abstract Builder tags(Tags var1);

        public abstract Builder machineType(MachineTypeId var1);

        public abstract Builder canIpForward(Boolean var1);

        public abstract Builder networkInterfaces(List<NetworkInterface> var1);

        public abstract Builder networkInterfaces(NetworkInterface ... var1);

        public abstract Builder attachedDisks(List<AttachedDisk> var1);

        public abstract Builder attachedDisks(AttachedDisk ... var1);

        public abstract Builder metadata(Metadata var1);

        public abstract Builder serviceAccounts(List<ServiceAccount> var1);

        public abstract Builder schedulingOptions(SchedulingOptions var1);

        abstract Builder cpuPlatform(String var1);

        public abstract InstanceInfo build();
    }

    public static enum Status {
        PROVISIONING,
        STAGING,
        RUNNING,
        STOPPING,
        TERMINATED;

    }
}

