/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Objects;

public class Image
extends ImageInfo {
    private static final long serialVersionUID = 4623766590317494020L;
    private final ComputeOptions options;
    private transient Compute compute;

    Image(Compute compute, ImageInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.options();
    }

    public boolean exists() {
        return this.reload(Compute.ImageOption.fields(new Compute.ImageField[0])) != null;
    }

    public Image reload(Compute.ImageOption ... options) {
        return this.compute.getImage(this.imageId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteImage(this.imageId(), options);
    }

    public Operation deprecate(DeprecationStatus<ImageId> deprecationStatus, Compute.OperationOption ... options) {
        return this.compute.deprecate(this.imageId(), deprecationStatus, options);
    }

    public Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Image.class)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Image fromPb(Compute compute, com.google.api.services.compute.model.Image imagePb) {
        return new Image(compute, new ImageInfo.BuilderImpl(imagePb));
    }

    public static class Builder
    extends ImageInfo.Builder {
        private final Compute compute;
        private final ImageInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, ImageId imageId, ImageConfiguration configuration) {
            this.compute = compute;
            this.infoBuilder = new ImageInfo.BuilderImpl();
            this.infoBuilder.imageId(imageId);
            this.infoBuilder.configuration(configuration);
        }

        Builder(Image image) {
            this.compute = image.compute;
            this.infoBuilder = new ImageInfo.BuilderImpl(image);
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.infoBuilder.creationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder imageId(ImageId imageId) {
            this.infoBuilder.imageId(imageId);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        public Builder configuration(ImageConfiguration configuration) {
            this.infoBuilder.configuration(configuration);
            return this;
        }

        @Override
        Builder status(ImageInfo.Status status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        Builder diskSizeGb(Long diskSizeGb) {
            this.infoBuilder.diskSizeGb(diskSizeGb);
            return this;
        }

        @Override
        Builder licenses(List<LicenseId> licenses) {
            this.infoBuilder.licenses((List)licenses);
            return this;
        }

        @Override
        Builder deprecationStatus(DeprecationStatus<ImageId> deprecationStatus) {
            this.infoBuilder.deprecationStatus((DeprecationStatus)deprecationStatus);
            return this;
        }

        @Override
        public Image build() {
            return new Image(this.compute, this.infoBuilder);
        }
    }
}

