/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DeprecationStatus<T extends ResourceId>
implements Serializable {
    private static final long serialVersionUID = -2695077634793679794L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter TIMESTAMP_PARSER = ISODateTimeFormat.dateTimeParser();
    private final String deleted;
    private final String deprecated;
    private final String obsolete;
    private final T replacement;
    private final Status status;

    DeprecationStatus(Builder<T> builder) {
        this.deleted = ((Builder)builder).deleted;
        this.deprecated = ((Builder)builder).deprecated;
        this.obsolete = ((Builder)builder).obsolete;
        this.replacement = ((Builder)builder).replacement;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)((Builder)builder).status)));
    }

    public String deleted() {
        return this.deleted;
    }

    public String deprecated() {
        return this.deprecated;
    }

    public String obsolete() {
        return this.obsolete;
    }

    public Long deletedMillis() {
        try {
            return this.deleted != null ? Long.valueOf(TIMESTAMP_PARSER.parseMillis(this.deleted)) : null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public Long deprecatedMillis() {
        try {
            return this.deprecated != null ? Long.valueOf(TIMESTAMP_PARSER.parseMillis(this.deprecated)) : null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public Long obsoleteMillis() {
        try {
            return this.obsolete != null ? Long.valueOf(TIMESTAMP_PARSER.parseMillis(this.obsolete)) : null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public T replacement() {
        return this.replacement;
    }

    public Status status() {
        return this.status;
    }

    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deleted", (Object)this.deleted).add("deprecated", (Object)this.deprecated).add("obsolete", (Object)this.obsolete).add("replacement", this.replacement).add("status", (Object)this.status).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deleted, this.deprecated, this.obsolete, this.replacement, this.status});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DeprecationStatus && Objects.equals(this.toPb(), ((DeprecationStatus)obj).toPb());
    }

    com.google.api.services.compute.model.DeprecationStatus toPb() {
        com.google.api.services.compute.model.DeprecationStatus deprecationStatusPb = new com.google.api.services.compute.model.DeprecationStatus();
        deprecationStatusPb.setDeleted(this.deleted);
        deprecationStatusPb.setDeprecated(this.deprecated);
        deprecationStatusPb.setObsolete(this.obsolete);
        deprecationStatusPb.setReplacement(((ResourceId)this.replacement).selfLink());
        deprecationStatusPb.setState(this.status.name());
        return deprecationStatusPb;
    }

    public static <T extends ResourceId> Builder<T> builder(Status status) {
        return new Builder().status(status);
    }

    public static <T extends ResourceId> Builder<T> builder(Status status, T replacement) {
        return new Builder().status(status).replacement(replacement);
    }

    public static <T extends ResourceId> DeprecationStatus<T> of(Status status, T replacement) {
        return DeprecationStatus.builder(status, replacement).build();
    }

    static <T extends ResourceId> DeprecationStatus<T> fromPb(com.google.api.services.compute.model.DeprecationStatus deprecationStatusPb, Function<String, T> fromUrl) {
        Builder<ResourceId> builder = new Builder<ResourceId>();
        builder.deleted(deprecationStatusPb.getDeleted());
        builder.deprecated(deprecationStatusPb.getDeprecated());
        builder.obsolete(deprecationStatusPb.getObsolete());
        if (deprecationStatusPb.getReplacement() != null) {
            builder.replacement((ResourceId)fromUrl.apply((Object)deprecationStatusPb.getReplacement()));
        }
        if (deprecationStatusPb.getState() != null) {
            builder.status(Status.valueOf(deprecationStatusPb.getState()));
        }
        return builder.build();
    }

    public static final class Builder<T extends ResourceId> {
        private String deleted;
        private String deprecated;
        private String obsolete;
        private T replacement;
        private Status status;

        Builder() {
        }

        Builder(DeprecationStatus<T> deprecationStatus) {
            this.deleted = ((DeprecationStatus)deprecationStatus).deleted;
            this.deprecated = ((DeprecationStatus)deprecationStatus).deprecated;
            this.obsolete = ((DeprecationStatus)deprecationStatus).obsolete;
            this.replacement = ((DeprecationStatus)deprecationStatus).replacement;
            this.status = ((DeprecationStatus)deprecationStatus).status;
        }

        Builder<T> deleted(String deleted) {
            this.deleted = deleted;
            return this;
        }

        Builder<T> deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        Builder<T> obsolete(String obsolete) {
            this.obsolete = obsolete;
            return this;
        }

        public Builder<T> deleted(long deleted) {
            this.deleted = TIMESTAMP_FORMATTER.print(deleted);
            return this;
        }

        public Builder<T> deprecated(long deprecated) {
            this.deprecated = TIMESTAMP_FORMATTER.print(deprecated);
            return this;
        }

        public Builder<T> obsolete(long obsolete) {
            this.obsolete = TIMESTAMP_FORMATTER.print(obsolete);
            return this;
        }

        public Builder<T> replacement(T replacement) {
            this.replacement = replacement;
            return this;
        }

        public Builder<T> status(Status status) {
            this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
            return this;
        }

        public DeprecationStatus<T> build() {
            return new DeprecationStatus(this);
        }
    }

    public static enum Status {
        DEPRECATED,
        OBSOLETE,
        DELETED;

    }
}

