/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ServiceAccount
implements Serializable {
    static final Function<com.google.api.services.compute.model.ServiceAccount, ServiceAccount> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.ServiceAccount, ServiceAccount>(){

        public ServiceAccount apply(com.google.api.services.compute.model.ServiceAccount pb) {
            return ServiceAccount.fromPb(pb);
        }
    };
    static final Function<ServiceAccount, com.google.api.services.compute.model.ServiceAccount> TO_PB_FUNCTION = new Function<ServiceAccount, com.google.api.services.compute.model.ServiceAccount>(){

        public com.google.api.services.compute.model.ServiceAccount apply(ServiceAccount metadata) {
            return metadata.toPb();
        }
    };
    private static final long serialVersionUID = 4199610694227857331L;
    private final String email;
    private final List<String> scopes;

    private ServiceAccount(String email, List<String> scopes) {
        this.email = email;
        this.scopes = ImmutableList.copyOf(scopes);
    }

    public String getEmail() {
        return this.email;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("email", (Object)this.email).add("scopes", this.scopes).toString();
    }

    public int hashCode() {
        return Objects.hash(this.email, this.scopes);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ServiceAccount && Objects.equals(this.toPb(), ((ServiceAccount)obj).toPb());
    }

    com.google.api.services.compute.model.ServiceAccount toPb() {
        com.google.api.services.compute.model.ServiceAccount serviceAccountPb = new com.google.api.services.compute.model.ServiceAccount();
        serviceAccountPb.setEmail(this.email);
        serviceAccountPb.setScopes(this.scopes);
        return serviceAccountPb;
    }

    public static ServiceAccount of(String email, List<String> scopes) {
        return new ServiceAccount(email, scopes);
    }

    public static ServiceAccount of(String email, String ... scopes) {
        return ServiceAccount.of(email, Arrays.asList(scopes));
    }

    static ServiceAccount fromPb(com.google.api.services.compute.model.ServiceAccount accountPb) {
        return new ServiceAccount(accountPb.getEmail(), accountPb.getScopes());
    }
}

