/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImageId
extends ResourceId {
    static final Function<String, ImageId> FROM_URL_FUNCTION = new Function<String, ImageId>(){

        public ImageId apply(String pb) {
            return ImageId.fromUrl(pb);
        }
    };
    static final Function<ImageId, String> TO_URL_FUNCTION = new Function<ImageId, String>(){

        public String apply(ImageId imageId) {
            return imageId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/global/images/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/images/([^/]+)");
    private static final long serialVersionUID = 6434553917859414341L;
    private final String image;

    private ImageId(String project, String image) {
        super(project);
        this.image = (String)Preconditions.checkNotNull((Object)image);
    }

    public String getImage() {
        return this.image;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/global/images/" + this.image;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("image", (Object)this.image);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.image);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageId)) {
            return false;
        }
        ImageId other = (ImageId)obj;
        return this.baseEquals(other) && Objects.equals(this.image, other.image);
    }

    @Override
    ImageId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return ImageId.of(projectId, this.image);
    }

    public static ImageId of(String image) {
        return new ImageId(null, image);
    }

    public static ImageId of(String project, String image) {
        return new ImageId(project, image);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static ImageId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid image URL");
        }
        return ImageId.of(matcher.group(1), matcher.group(2));
    }
}

