/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.ZoneId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiskId
extends ResourceId {
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)/disks/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)/disks/([^/]+)");
    private static final long serialVersionUID = -8761290740495870787L;
    private final String zone;
    private final String disk;

    private DiskId(String project, String zone, String disk) {
        super(project);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
        this.disk = (String)Preconditions.checkNotNull((Object)disk);
    }

    public String getZone() {
        return this.zone;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.getProject(), this.zone);
    }

    public String getDisk() {
        return this.disk;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/zones/" + this.zone + "/disks/" + this.disk;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("zone", (Object)this.zone).add("disk", (Object)this.disk);
    }

    public int hashCode() {
        return Objects.hash(super.baseHashCode(), this.zone, this.disk);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskId)) {
            return false;
        }
        DiskId other = (DiskId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone) && Objects.equals(this.disk, other.disk);
    }

    @Override
    DiskId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return DiskId.of(projectId, this.zone, this.disk);
    }

    public static DiskId of(ZoneId zoneId, String disk) {
        return new DiskId(zoneId.getProject(), zoneId.getZone(), disk);
    }

    public static DiskId of(String zone, String disk) {
        return new DiskId(null, zone, disk);
    }

    public static DiskId of(String project, String zone, String disk) {
        return new DiskId(project, zone, disk);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static DiskId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid disk URL");
        }
        return DiskId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

