/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GetGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GlobalOperationClient;
import com.google.cloud.compute.v1.ListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationAggregatedList;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.ProjectGlobalOperationName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.WaitGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.stub.GlobalOperationStub;
import com.google.cloud.compute.v1.stub.GlobalOperationStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonGlobalOperationStub
extends GlobalOperationStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList> aggregatedListGlobalOperationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalOperations.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/operations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)OperationAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalOperations.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/operations/{operation}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalOperationName.newFactory()).setResourceNameField("operation").build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetGlobalOperationHttpRequest, Operation> getGlobalOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalOperations.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/operations/{operation}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalOperationName.newFactory()).setResourceNameField("operation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListGlobalOperationsHttpRequest, OperationList> listGlobalOperationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalOperations.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/operations")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)OperationList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<WaitGlobalOperationHttpRequest, Operation> waitGlobalOperationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalOperations.wait").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/operations/{operation}/wait")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalOperationName.newFactory()).setResourceNameField("operation").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList> aggregatedListGlobalOperationsCallable;
    private final UnaryCallable<AggregatedListGlobalOperationsHttpRequest, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsPagedCallable;
    private final UnaryCallable<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationCallable;
    private final UnaryCallable<GetGlobalOperationHttpRequest, Operation> getGlobalOperationCallable;
    private final UnaryCallable<ListGlobalOperationsHttpRequest, OperationList> listGlobalOperationsCallable;
    private final UnaryCallable<ListGlobalOperationsHttpRequest, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsPagedCallable;
    private final UnaryCallable<WaitGlobalOperationHttpRequest, Operation> waitGlobalOperationCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGlobalOperationStub create(GlobalOperationStubSettings settings) throws IOException {
        return new HttpJsonGlobalOperationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGlobalOperationStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGlobalOperationStub(GlobalOperationStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonGlobalOperationStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGlobalOperationStub(GlobalOperationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGlobalOperationStub(GlobalOperationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGlobalOperationCallableFactory());
    }

    protected HttpJsonGlobalOperationStub(GlobalOperationStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListGlobalOperationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListGlobalOperationsMethodDescriptor).build();
        HttpJsonCallSettings deleteGlobalOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGlobalOperationMethodDescriptor).build();
        HttpJsonCallSettings getGlobalOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGlobalOperationMethodDescriptor).build();
        HttpJsonCallSettings listGlobalOperationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGlobalOperationsMethodDescriptor).build();
        HttpJsonCallSettings waitGlobalOperationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(waitGlobalOperationMethodDescriptor).build();
        this.aggregatedListGlobalOperationsCallable = callableFactory.createUnaryCallable(aggregatedListGlobalOperationsTransportSettings, settings.aggregatedListGlobalOperationsSettings(), clientContext);
        this.aggregatedListGlobalOperationsPagedCallable = callableFactory.createPagedCallable(aggregatedListGlobalOperationsTransportSettings, settings.aggregatedListGlobalOperationsSettings(), clientContext);
        this.deleteGlobalOperationCallable = callableFactory.createUnaryCallable(deleteGlobalOperationTransportSettings, settings.deleteGlobalOperationSettings(), clientContext);
        this.getGlobalOperationCallable = callableFactory.createUnaryCallable(getGlobalOperationTransportSettings, settings.getGlobalOperationSettings(), clientContext);
        this.listGlobalOperationsCallable = callableFactory.createUnaryCallable(listGlobalOperationsTransportSettings, settings.listGlobalOperationsSettings(), clientContext);
        this.listGlobalOperationsPagedCallable = callableFactory.createPagedCallable(listGlobalOperationsTransportSettings, settings.listGlobalOperationsSettings(), clientContext);
        this.waitGlobalOperationCallable = callableFactory.createUnaryCallable(waitGlobalOperationTransportSettings, settings.waitGlobalOperationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListGlobalOperationsHttpRequest, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsPagedCallable() {
        return this.aggregatedListGlobalOperationsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList> aggregatedListGlobalOperationsCallable() {
        return this.aggregatedListGlobalOperationsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationCallable() {
        return this.deleteGlobalOperationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetGlobalOperationHttpRequest, Operation> getGlobalOperationCallable() {
        return this.getGlobalOperationCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListGlobalOperationsHttpRequest, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsPagedCallable() {
        return this.listGlobalOperationsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListGlobalOperationsHttpRequest, OperationList> listGlobalOperationsCallable() {
        return this.listGlobalOperationsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<WaitGlobalOperationHttpRequest, Operation> waitGlobalOperationCallable() {
        return this.waitGlobalOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

