/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetInstance
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String instance;
    private final String kind;
    private final String name;
    private final String natPolicy;
    private final String selfLink;
    private final String zone;
    private static final TargetInstance DEFAULT_INSTANCE = new TargetInstance();

    private TargetInstance() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.instance = null;
        this.kind = null;
        this.name = null;
        this.natPolicy = null;
        this.selfLink = null;
        this.zone = null;
    }

    private TargetInstance(String creationTimestamp, String description, String id, String instance, String kind, String name, String natPolicy, String selfLink, String zone) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.instance = instance;
        this.kind = kind;
        this.name = name;
        this.natPolicy = natPolicy;
        this.selfLink = selfLink;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("instance".equals(fieldName)) {
            return this.instance;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("natPolicy".equals(fieldName)) {
            return this.natPolicy;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("zone".equals(fieldName)) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNatPolicy() {
        return this.natPolicy;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetInstance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetInstance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetInstance{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", instance=" + this.instance + ", kind=" + this.kind + ", name=" + this.name + ", natPolicy=" + this.natPolicy + ", selfLink=" + this.selfLink + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetInstance) {
            TargetInstance that = (TargetInstance)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.natPolicy, that.getNatPolicy()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.instance, this.kind, this.name, this.natPolicy, this.selfLink, this.zone);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private String instance;
        private String kind;
        private String name;
        private String natPolicy;
        private String selfLink;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(TargetInstance other) {
            if (other == TargetInstance.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNatPolicy() != null) {
                this.natPolicy = other.natPolicy;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(TargetInstance source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.instance = source.instance;
            this.kind = source.kind;
            this.name = source.name;
            this.natPolicy = source.natPolicy;
            this.selfLink = source.selfLink;
            this.zone = source.zone;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNatPolicy() {
            return this.natPolicy;
        }

        public Builder setNatPolicy(String natPolicy) {
            this.natPolicy = natPolicy;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public TargetInstance build() {
            return new TargetInstance(this.creationTimestamp, this.description, this.id, this.instance, this.kind, this.name, this.natPolicy, this.selfLink, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setInstance(this.instance);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNatPolicy(this.natPolicy);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

