/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SslCertificateManagedSslCertificate
implements ApiMessage {
    private final Map<String, String> domainStatus;
    private final List<String> domains;
    private final String status;
    private static final SslCertificateManagedSslCertificate DEFAULT_INSTANCE = new SslCertificateManagedSslCertificate();

    private SslCertificateManagedSslCertificate() {
        this.domainStatus = null;
        this.domains = null;
        this.status = null;
    }

    private SslCertificateManagedSslCertificate(Map<String, String> domainStatus, List<String> domains, String status) {
        this.domainStatus = domainStatus;
        this.domains = domains;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("domainStatus".equals(fieldName)) {
            return this.domainStatus;
        }
        if ("domains".equals(fieldName)) {
            return this.domains;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Map<String, String> getDomainStatusMap() {
        return this.domainStatus;
    }

    public List<String> getDomainsList() {
        return this.domains;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SslCertificateManagedSslCertificate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SslCertificateManagedSslCertificate getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SslCertificateManagedSslCertificate{domainStatus=" + this.domainStatus + ", domains=" + this.domains + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SslCertificateManagedSslCertificate) {
            SslCertificateManagedSslCertificate that = (SslCertificateManagedSslCertificate)o;
            return Objects.equals(this.domainStatus, that.getDomainStatusMap()) && Objects.equals(this.domains, that.getDomainsList()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.domainStatus, this.domains, this.status);
    }

    public static class Builder {
        private Map<String, String> domainStatus;
        private List<String> domains;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(SslCertificateManagedSslCertificate other) {
            if (other == SslCertificateManagedSslCertificate.getDefaultInstance()) {
                return this;
            }
            if (other.getDomainStatusMap() != null) {
                this.domainStatus = other.domainStatus;
            }
            if (other.getDomainsList() != null) {
                this.domains = other.domains;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(SslCertificateManagedSslCertificate source) {
            this.domainStatus = source.domainStatus;
            this.domains = source.domains;
            this.status = source.status;
        }

        public Map<String, String> getDomainStatusMap() {
            return this.domainStatus;
        }

        public Builder putAllDomainStatus(Map<String, String> domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        public List<String> getDomainsList() {
            return this.domains;
        }

        public Builder addAllDomains(List<String> domains) {
            if (this.domains == null) {
                this.domains = new LinkedList<String>();
            }
            this.domains.addAll(domains);
            return this;
        }

        public Builder addDomains(String domains) {
            if (this.domains == null) {
                this.domains = new LinkedList<String>();
            }
            this.domains.add(domains);
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public SslCertificateManagedSslCertificate build() {
            return new SslCertificateManagedSslCertificate(this.domainStatus, this.domains, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.putAllDomainStatus(this.domainStatus);
            newBuilder.addAllDomains(this.domains);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

