/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionNodeTemplateName
implements ResourceName {
    private final String nodeTemplate;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/nodeTemplates/{nodeTemplate}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionNodeTemplateName(Builder builder) {
        this.nodeTemplate = (String)Preconditions.checkNotNull((Object)builder.getNodeTemplate());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionNodeTemplateName of(String nodeTemplate, String project, String region) {
        return ProjectRegionNodeTemplateName.newBuilder().setNodeTemplate(nodeTemplate).setProject(project).setRegion(region).build();
    }

    public static String format(String nodeTemplate, String project, String region) {
        return ProjectRegionNodeTemplateName.of(nodeTemplate, project, region).toString();
    }

    public String getNodeTemplate() {
        return this.nodeTemplate;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionNodeTemplateName projectRegionNodeTemplateName = this;
            synchronized (projectRegionNodeTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"nodeTemplate", (Object)this.nodeTemplate);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionNodeTemplateName> newFactory() {
        return new ResourceNameFactory<ProjectRegionNodeTemplateName>(){

            public ProjectRegionNodeTemplateName parse(String formattedString) {
                return ProjectRegionNodeTemplateName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionNodeTemplateName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionNodeTemplateName.parse: formattedString not in valid format");
        return ProjectRegionNodeTemplateName.of((String)matchMap.get("nodeTemplate"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"nodeTemplate", this.nodeTemplate, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionNodeTemplateName) {
            ProjectRegionNodeTemplateName that = (ProjectRegionNodeTemplateName)o;
            return Objects.equals(this.nodeTemplate, that.getNodeTemplate()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeTemplate, this.project, this.region);
    }

    public static class Builder {
        private String nodeTemplate;
        private String project;
        private String region;

        public String getNodeTemplate() {
            return this.nodeTemplate;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setNodeTemplate(String nodeTemplate) {
            this.nodeTemplate = nodeTemplate;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionNodeTemplateName projectRegionNodeTemplateName) {
            this.nodeTemplate = projectRegionNodeTemplateName.nodeTemplate;
            this.project = projectRegionNodeTemplateName.project;
            this.region = projectRegionNodeTemplateName.region;
        }

        public ProjectRegionNodeTemplateName build() {
            return new ProjectRegionNodeTemplateName(this);
        }
    }
}

