/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.LogConfigCounterOptionsCustomField;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class LogConfigCounterOptions
implements ApiMessage {
    private final List<LogConfigCounterOptionsCustomField> customFields;
    private final String field;
    private final String metric;
    private static final LogConfigCounterOptions DEFAULT_INSTANCE = new LogConfigCounterOptions();

    private LogConfigCounterOptions() {
        this.customFields = null;
        this.field = null;
        this.metric = null;
    }

    private LogConfigCounterOptions(List<LogConfigCounterOptionsCustomField> customFields, String field, String metric) {
        this.customFields = customFields;
        this.field = field;
        this.metric = metric;
    }

    public Object getFieldValue(String fieldName) {
        if ("customFields".equals(fieldName)) {
            return this.customFields;
        }
        if ("field".equals(fieldName)) {
            return this.field;
        }
        if ("metric".equals(fieldName)) {
            return this.metric;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<LogConfigCounterOptionsCustomField> getCustomFieldsList() {
        return this.customFields;
    }

    public String getField() {
        return this.field;
    }

    public String getMetric() {
        return this.metric;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LogConfigCounterOptions prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static LogConfigCounterOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "LogConfigCounterOptions{customFields=" + this.customFields + ", field=" + this.field + ", metric=" + this.metric + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LogConfigCounterOptions) {
            LogConfigCounterOptions that = (LogConfigCounterOptions)o;
            return Objects.equals(this.customFields, that.getCustomFieldsList()) && Objects.equals(this.field, that.getField()) && Objects.equals(this.metric, that.getMetric());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.customFields, this.field, this.metric);
    }

    public static class Builder {
        private List<LogConfigCounterOptionsCustomField> customFields;
        private String field;
        private String metric;

        Builder() {
        }

        public Builder mergeFrom(LogConfigCounterOptions other) {
            if (other == LogConfigCounterOptions.getDefaultInstance()) {
                return this;
            }
            if (other.getCustomFieldsList() != null) {
                this.customFields = other.customFields;
            }
            if (other.getField() != null) {
                this.field = other.field;
            }
            if (other.getMetric() != null) {
                this.metric = other.metric;
            }
            return this;
        }

        Builder(LogConfigCounterOptions source) {
            this.customFields = source.customFields;
            this.field = source.field;
            this.metric = source.metric;
        }

        public List<LogConfigCounterOptionsCustomField> getCustomFieldsList() {
            return this.customFields;
        }

        public Builder addAllCustomFields(List<LogConfigCounterOptionsCustomField> customFields) {
            if (this.customFields == null) {
                this.customFields = new LinkedList<LogConfigCounterOptionsCustomField>();
            }
            this.customFields.addAll(customFields);
            return this;
        }

        public Builder addCustomFields(LogConfigCounterOptionsCustomField customFields) {
            if (this.customFields == null) {
                this.customFields = new LinkedList<LogConfigCounterOptionsCustomField>();
            }
            this.customFields.add(customFields);
            return this;
        }

        public String getField() {
            return this.field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public String getMetric() {
            return this.metric;
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        public LogConfigCounterOptions build() {
            return new LogConfigCounterOptions(this.customFields, this.field, this.metric);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllCustomFields(this.customFields);
            newBuilder.setField(this.field);
            newBuilder.setMetric(this.metric);
            return newBuilder;
        }
    }
}

