/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpHeaderOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpHeaderAction
implements ApiMessage {
    private final List<HttpHeaderOption> requestHeadersToAdd;
    private final List<String> requestHeadersToRemove;
    private final List<HttpHeaderOption> responseHeadersToAdd;
    private final List<String> responseHeadersToRemove;
    private static final HttpHeaderAction DEFAULT_INSTANCE = new HttpHeaderAction();

    private HttpHeaderAction() {
        this.requestHeadersToAdd = null;
        this.requestHeadersToRemove = null;
        this.responseHeadersToAdd = null;
        this.responseHeadersToRemove = null;
    }

    private HttpHeaderAction(List<HttpHeaderOption> requestHeadersToAdd, List<String> requestHeadersToRemove, List<HttpHeaderOption> responseHeadersToAdd, List<String> responseHeadersToRemove) {
        this.requestHeadersToAdd = requestHeadersToAdd;
        this.requestHeadersToRemove = requestHeadersToRemove;
        this.responseHeadersToAdd = responseHeadersToAdd;
        this.responseHeadersToRemove = responseHeadersToRemove;
    }

    public Object getFieldValue(String fieldName) {
        if ("requestHeadersToAdd".equals(fieldName)) {
            return this.requestHeadersToAdd;
        }
        if ("requestHeadersToRemove".equals(fieldName)) {
            return this.requestHeadersToRemove;
        }
        if ("responseHeadersToAdd".equals(fieldName)) {
            return this.responseHeadersToAdd;
        }
        if ("responseHeadersToRemove".equals(fieldName)) {
            return this.responseHeadersToRemove;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<HttpHeaderOption> getRequestHeadersToAddList() {
        return this.requestHeadersToAdd;
    }

    public List<String> getRequestHeadersToRemoveList() {
        return this.requestHeadersToRemove;
    }

    public List<HttpHeaderOption> getResponseHeadersToAddList() {
        return this.responseHeadersToAdd;
    }

    public List<String> getResponseHeadersToRemoveList() {
        return this.responseHeadersToRemove;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpHeaderAction prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpHeaderAction getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpHeaderAction{requestHeadersToAdd=" + this.requestHeadersToAdd + ", requestHeadersToRemove=" + this.requestHeadersToRemove + ", responseHeadersToAdd=" + this.responseHeadersToAdd + ", responseHeadersToRemove=" + this.responseHeadersToRemove + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpHeaderAction) {
            HttpHeaderAction that = (HttpHeaderAction)o;
            return Objects.equals(this.requestHeadersToAdd, that.getRequestHeadersToAddList()) && Objects.equals(this.requestHeadersToRemove, that.getRequestHeadersToRemoveList()) && Objects.equals(this.responseHeadersToAdd, that.getResponseHeadersToAddList()) && Objects.equals(this.responseHeadersToRemove, that.getResponseHeadersToRemoveList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.requestHeadersToAdd, this.requestHeadersToRemove, this.responseHeadersToAdd, this.responseHeadersToRemove);
    }

    public static class Builder {
        private List<HttpHeaderOption> requestHeadersToAdd;
        private List<String> requestHeadersToRemove;
        private List<HttpHeaderOption> responseHeadersToAdd;
        private List<String> responseHeadersToRemove;

        Builder() {
        }

        public Builder mergeFrom(HttpHeaderAction other) {
            if (other == HttpHeaderAction.getDefaultInstance()) {
                return this;
            }
            if (other.getRequestHeadersToAddList() != null) {
                this.requestHeadersToAdd = other.requestHeadersToAdd;
            }
            if (other.getRequestHeadersToRemoveList() != null) {
                this.requestHeadersToRemove = other.requestHeadersToRemove;
            }
            if (other.getResponseHeadersToAddList() != null) {
                this.responseHeadersToAdd = other.responseHeadersToAdd;
            }
            if (other.getResponseHeadersToRemoveList() != null) {
                this.responseHeadersToRemove = other.responseHeadersToRemove;
            }
            return this;
        }

        Builder(HttpHeaderAction source) {
            this.requestHeadersToAdd = source.requestHeadersToAdd;
            this.requestHeadersToRemove = source.requestHeadersToRemove;
            this.responseHeadersToAdd = source.responseHeadersToAdd;
            this.responseHeadersToRemove = source.responseHeadersToRemove;
        }

        public List<HttpHeaderOption> getRequestHeadersToAddList() {
            return this.requestHeadersToAdd;
        }

        public Builder addAllRequestHeadersToAdd(List<HttpHeaderOption> requestHeadersToAdd) {
            if (this.requestHeadersToAdd == null) {
                this.requestHeadersToAdd = new LinkedList<HttpHeaderOption>();
            }
            this.requestHeadersToAdd.addAll(requestHeadersToAdd);
            return this;
        }

        public Builder addRequestHeadersToAdd(HttpHeaderOption requestHeadersToAdd) {
            if (this.requestHeadersToAdd == null) {
                this.requestHeadersToAdd = new LinkedList<HttpHeaderOption>();
            }
            this.requestHeadersToAdd.add(requestHeadersToAdd);
            return this;
        }

        public List<String> getRequestHeadersToRemoveList() {
            return this.requestHeadersToRemove;
        }

        public Builder addAllRequestHeadersToRemove(List<String> requestHeadersToRemove) {
            if (this.requestHeadersToRemove == null) {
                this.requestHeadersToRemove = new LinkedList<String>();
            }
            this.requestHeadersToRemove.addAll(requestHeadersToRemove);
            return this;
        }

        public Builder addRequestHeadersToRemove(String requestHeadersToRemove) {
            if (this.requestHeadersToRemove == null) {
                this.requestHeadersToRemove = new LinkedList<String>();
            }
            this.requestHeadersToRemove.add(requestHeadersToRemove);
            return this;
        }

        public List<HttpHeaderOption> getResponseHeadersToAddList() {
            return this.responseHeadersToAdd;
        }

        public Builder addAllResponseHeadersToAdd(List<HttpHeaderOption> responseHeadersToAdd) {
            if (this.responseHeadersToAdd == null) {
                this.responseHeadersToAdd = new LinkedList<HttpHeaderOption>();
            }
            this.responseHeadersToAdd.addAll(responseHeadersToAdd);
            return this;
        }

        public Builder addResponseHeadersToAdd(HttpHeaderOption responseHeadersToAdd) {
            if (this.responseHeadersToAdd == null) {
                this.responseHeadersToAdd = new LinkedList<HttpHeaderOption>();
            }
            this.responseHeadersToAdd.add(responseHeadersToAdd);
            return this;
        }

        public List<String> getResponseHeadersToRemoveList() {
            return this.responseHeadersToRemove;
        }

        public Builder addAllResponseHeadersToRemove(List<String> responseHeadersToRemove) {
            if (this.responseHeadersToRemove == null) {
                this.responseHeadersToRemove = new LinkedList<String>();
            }
            this.responseHeadersToRemove.addAll(responseHeadersToRemove);
            return this;
        }

        public Builder addResponseHeadersToRemove(String responseHeadersToRemove) {
            if (this.responseHeadersToRemove == null) {
                this.responseHeadersToRemove = new LinkedList<String>();
            }
            this.responseHeadersToRemove.add(responseHeadersToRemove);
            return this;
        }

        public HttpHeaderAction build() {
            return new HttpHeaderAction(this.requestHeadersToAdd, this.requestHeadersToRemove, this.responseHeadersToAdd, this.responseHeadersToRemove);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllRequestHeadersToAdd(this.requestHeadersToAdd);
            newBuilder.addAllRequestHeadersToRemove(this.requestHeadersToRemove);
            newBuilder.addAllResponseHeadersToAdd(this.responseHeadersToAdd);
            newBuilder.addAllResponseHeadersToRemove(this.responseHeadersToRemove);
            return newBuilder;
        }
    }
}

