/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.DeleteRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetHealthRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.InsertRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ListRegionBackendServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.RegionBackendServiceClient;
import com.google.cloud.compute.v1.UpdateRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionBackendServiceStub;
import com.google.cloud.compute.v1.stub.RegionBackendServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionBackendServiceStubSettings
extends StubSettings<RegionBackendServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionBackendServiceHttpRequest, Operation> deleteRegionBackendServiceSettings;
    private final UnaryCallSettings<GetRegionBackendServiceHttpRequest, BackendService> getRegionBackendServiceSettings;
    private final UnaryCallSettings<GetHealthRegionBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthRegionBackendServiceSettings;
    private final UnaryCallSettings<InsertRegionBackendServiceHttpRequest, Operation> insertRegionBackendServiceSettings;
    private final PagedCallSettings<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> listRegionBackendServicesSettings;
    private final UnaryCallSettings<PatchRegionBackendServiceHttpRequest, Operation> patchRegionBackendServiceSettings;
    private final UnaryCallSettings<UpdateRegionBackendServiceHttpRequest, Operation> updateRegionBackendServiceSettings;
    private static final PagedListDescriptor<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService> LIST_REGION_BACKEND_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionBackendServicesHttpRequest injectToken(ListRegionBackendServicesHttpRequest payload, String token) {
            return ListRegionBackendServicesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionBackendServicesHttpRequest injectPageSize(ListRegionBackendServicesHttpRequest payload, int pageSize) {
            return ListRegionBackendServicesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionBackendServicesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendService> extractResources(BackendServiceList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> LIST_REGION_BACKEND_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse>(){

        public ApiFuture<RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionBackendServicesHttpRequest, BackendServiceList> callable, ListRegionBackendServicesHttpRequest request, ApiCallContext context, ApiFuture<BackendServiceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_BACKEND_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionBackendServiceClient.ListRegionBackendServicesPagedResponse.createAsync((PageContext<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionBackendServiceHttpRequest, Operation> deleteRegionBackendServiceSettings() {
        return this.deleteRegionBackendServiceSettings;
    }

    public UnaryCallSettings<GetRegionBackendServiceHttpRequest, BackendService> getRegionBackendServiceSettings() {
        return this.getRegionBackendServiceSettings;
    }

    public UnaryCallSettings<GetHealthRegionBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthRegionBackendServiceSettings() {
        return this.getHealthRegionBackendServiceSettings;
    }

    public UnaryCallSettings<InsertRegionBackendServiceHttpRequest, Operation> insertRegionBackendServiceSettings() {
        return this.insertRegionBackendServiceSettings;
    }

    public PagedCallSettings<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> listRegionBackendServicesSettings() {
        return this.listRegionBackendServicesSettings;
    }

    public UnaryCallSettings<PatchRegionBackendServiceHttpRequest, Operation> patchRegionBackendServiceSettings() {
        return this.patchRegionBackendServiceSettings;
    }

    public UnaryCallSettings<UpdateRegionBackendServiceHttpRequest, Operation> updateRegionBackendServiceSettings() {
        return this.updateRegionBackendServiceSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionBackendServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionBackendServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionBackendServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionBackendServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionBackendServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionBackendServiceSettings = settingsBuilder.deleteRegionBackendServiceSettings().build();
        this.getRegionBackendServiceSettings = settingsBuilder.getRegionBackendServiceSettings().build();
        this.getHealthRegionBackendServiceSettings = settingsBuilder.getHealthRegionBackendServiceSettings().build();
        this.insertRegionBackendServiceSettings = settingsBuilder.insertRegionBackendServiceSettings().build();
        this.listRegionBackendServicesSettings = settingsBuilder.listRegionBackendServicesSettings().build();
        this.patchRegionBackendServiceSettings = settingsBuilder.patchRegionBackendServiceSettings().build();
        this.updateRegionBackendServiceSettings = settingsBuilder.updateRegionBackendServiceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionBackendServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionBackendServiceHttpRequest, Operation> deleteRegionBackendServiceSettings;
        private final UnaryCallSettings.Builder<GetRegionBackendServiceHttpRequest, BackendService> getRegionBackendServiceSettings;
        private final UnaryCallSettings.Builder<GetHealthRegionBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthRegionBackendServiceSettings;
        private final UnaryCallSettings.Builder<InsertRegionBackendServiceHttpRequest, Operation> insertRegionBackendServiceSettings;
        private final PagedCallSettings.Builder<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> listRegionBackendServicesSettings;
        private final UnaryCallSettings.Builder<PatchRegionBackendServiceHttpRequest, Operation> patchRegionBackendServiceSettings;
        private final UnaryCallSettings.Builder<UpdateRegionBackendServiceHttpRequest, Operation> updateRegionBackendServiceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionBackendServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_BACKEND_SERVICES_PAGE_STR_FACT);
            this.patchRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegionBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionBackendServiceSettings, this.getRegionBackendServiceSettings, this.getHealthRegionBackendServiceSettings, this.insertRegionBackendServiceSettings, this.listRegionBackendServicesSettings, this.patchRegionBackendServiceSettings, this.updateRegionBackendServiceSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionBackendServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionBackendServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionBackendServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionBackendServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHealthRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionBackendServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateRegionBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionBackendServiceStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionBackendServiceSettings = settings.deleteRegionBackendServiceSettings.toBuilder();
            this.getRegionBackendServiceSettings = settings.getRegionBackendServiceSettings.toBuilder();
            this.getHealthRegionBackendServiceSettings = settings.getHealthRegionBackendServiceSettings.toBuilder();
            this.insertRegionBackendServiceSettings = settings.insertRegionBackendServiceSettings.toBuilder();
            this.listRegionBackendServicesSettings = settings.listRegionBackendServicesSettings.toBuilder();
            this.patchRegionBackendServiceSettings = settings.patchRegionBackendServiceSettings.toBuilder();
            this.updateRegionBackendServiceSettings = settings.updateRegionBackendServiceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionBackendServiceSettings, this.getRegionBackendServiceSettings, this.getHealthRegionBackendServiceSettings, this.insertRegionBackendServiceSettings, this.listRegionBackendServicesSettings, this.patchRegionBackendServiceSettings, this.updateRegionBackendServiceSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionBackendServiceHttpRequest, Operation> deleteRegionBackendServiceSettings() {
            return this.deleteRegionBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<GetRegionBackendServiceHttpRequest, BackendService> getRegionBackendServiceSettings() {
            return this.getRegionBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<GetHealthRegionBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthRegionBackendServiceSettings() {
            return this.getHealthRegionBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionBackendServiceHttpRequest, Operation> insertRegionBackendServiceSettings() {
            return this.insertRegionBackendServiceSettings;
        }

        public PagedCallSettings.Builder<ListRegionBackendServicesHttpRequest, BackendServiceList, RegionBackendServiceClient.ListRegionBackendServicesPagedResponse> listRegionBackendServicesSettings() {
            return this.listRegionBackendServicesSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionBackendServiceHttpRequest, Operation> patchRegionBackendServiceSettings() {
            return this.patchRegionBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionBackendServiceHttpRequest, Operation> updateRegionBackendServiceSettings() {
            return this.updateRegionBackendServiceSettings;
        }

        public RegionBackendServiceStubSettings build() throws IOException {
            return new RegionBackendServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

