/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.WafExpressionSetExpression;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class WafExpressionSet
implements ApiMessage {
    private final List<String> aliases;
    private final List<WafExpressionSetExpression> expressions;
    private final String id;
    private static final WafExpressionSet DEFAULT_INSTANCE = new WafExpressionSet();

    private WafExpressionSet() {
        this.aliases = null;
        this.expressions = null;
        this.id = null;
    }

    private WafExpressionSet(List<String> aliases, List<WafExpressionSetExpression> expressions, String id) {
        this.aliases = aliases;
        this.expressions = expressions;
        this.id = id;
    }

    public Object getFieldValue(String fieldName) {
        if ("aliases".equals(fieldName)) {
            return this.aliases;
        }
        if ("expressions".equals(fieldName)) {
            return this.expressions;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getAliasesList() {
        return this.aliases;
    }

    public List<WafExpressionSetExpression> getExpressionsList() {
        return this.expressions;
    }

    public String getId() {
        return this.id;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(WafExpressionSet prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static WafExpressionSet getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "WafExpressionSet{aliases=" + this.aliases + ", expressions=" + this.expressions + ", id=" + this.id + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WafExpressionSet) {
            WafExpressionSet that = (WafExpressionSet)o;
            return Objects.equals(this.aliases, that.getAliasesList()) && Objects.equals(this.expressions, that.getExpressionsList()) && Objects.equals(this.id, that.getId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.expressions, this.id);
    }

    public static class Builder {
        private List<String> aliases;
        private List<WafExpressionSetExpression> expressions;
        private String id;

        Builder() {
        }

        public Builder mergeFrom(WafExpressionSet other) {
            if (other == WafExpressionSet.getDefaultInstance()) {
                return this;
            }
            if (other.getAliasesList() != null) {
                this.aliases = other.aliases;
            }
            if (other.getExpressionsList() != null) {
                this.expressions = other.expressions;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            return this;
        }

        Builder(WafExpressionSet source) {
            this.aliases = source.aliases;
            this.expressions = source.expressions;
            this.id = source.id;
        }

        public List<String> getAliasesList() {
            return this.aliases;
        }

        public Builder addAllAliases(List<String> aliases) {
            if (this.aliases == null) {
                this.aliases = new LinkedList<String>();
            }
            this.aliases.addAll(aliases);
            return this;
        }

        public Builder addAliases(String aliases) {
            if (this.aliases == null) {
                this.aliases = new LinkedList<String>();
            }
            this.aliases.add(aliases);
            return this;
        }

        public List<WafExpressionSetExpression> getExpressionsList() {
            return this.expressions;
        }

        public Builder addAllExpressions(List<WafExpressionSetExpression> expressions) {
            if (this.expressions == null) {
                this.expressions = new LinkedList<WafExpressionSetExpression>();
            }
            this.expressions.addAll(expressions);
            return this;
        }

        public Builder addExpressions(WafExpressionSetExpression expressions) {
            if (this.expressions == null) {
                this.expressions = new LinkedList<WafExpressionSetExpression>();
            }
            this.expressions.add(expressions);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public WafExpressionSet build() {
            return new WafExpressionSet(this.aliases, this.expressions, this.id);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAliases(this.aliases);
            newBuilder.addAllExpressions(this.expressions);
            newBuilder.setId(this.id);
            return newBuilder;
        }
    }
}

