/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GRPCHealthCheck
implements ApiMessage {
    private final String grpcServiceName;
    private final Integer port;
    private final String portName;
    private final String portSpecification;
    private static final GRPCHealthCheck DEFAULT_INSTANCE = new GRPCHealthCheck();

    private GRPCHealthCheck() {
        this.grpcServiceName = null;
        this.port = null;
        this.portName = null;
        this.portSpecification = null;
    }

    private GRPCHealthCheck(String grpcServiceName, Integer port, String portName, String portSpecification) {
        this.grpcServiceName = grpcServiceName;
        this.port = port;
        this.portName = portName;
        this.portSpecification = portSpecification;
    }

    public Object getFieldValue(String fieldName) {
        if ("grpcServiceName".equals(fieldName)) {
            return this.grpcServiceName;
        }
        if ("port".equals(fieldName)) {
            return this.port;
        }
        if ("portName".equals(fieldName)) {
            return this.portName;
        }
        if ("portSpecification".equals(fieldName)) {
            return this.portSpecification;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getGrpcServiceName() {
        return this.grpcServiceName;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getPortSpecification() {
        return this.portSpecification;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GRPCHealthCheck prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GRPCHealthCheck getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GRPCHealthCheck{grpcServiceName=" + this.grpcServiceName + ", port=" + this.port + ", portName=" + this.portName + ", portSpecification=" + this.portSpecification + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GRPCHealthCheck) {
            GRPCHealthCheck that = (GRPCHealthCheck)o;
            return Objects.equals(this.grpcServiceName, that.getGrpcServiceName()) && Objects.equals(this.port, that.getPort()) && Objects.equals(this.portName, that.getPortName()) && Objects.equals(this.portSpecification, that.getPortSpecification());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.grpcServiceName, this.port, this.portName, this.portSpecification);
    }

    public static class Builder {
        private String grpcServiceName;
        private Integer port;
        private String portName;
        private String portSpecification;

        Builder() {
        }

        public Builder mergeFrom(GRPCHealthCheck other) {
            if (other == GRPCHealthCheck.getDefaultInstance()) {
                return this;
            }
            if (other.getGrpcServiceName() != null) {
                this.grpcServiceName = other.grpcServiceName;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            if (other.getPortName() != null) {
                this.portName = other.portName;
            }
            if (other.getPortSpecification() != null) {
                this.portSpecification = other.portSpecification;
            }
            return this;
        }

        Builder(GRPCHealthCheck source) {
            this.grpcServiceName = source.grpcServiceName;
            this.port = source.port;
            this.portName = source.portName;
            this.portSpecification = source.portSpecification;
        }

        public String getGrpcServiceName() {
            return this.grpcServiceName;
        }

        public Builder setGrpcServiceName(String grpcServiceName) {
            this.grpcServiceName = grpcServiceName;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public String getPortName() {
            return this.portName;
        }

        public Builder setPortName(String portName) {
            this.portName = portName;
            return this;
        }

        public String getPortSpecification() {
            return this.portSpecification;
        }

        public Builder setPortSpecification(String portSpecification) {
            this.portSpecification = portSpecification;
            return this;
        }

        public GRPCHealthCheck build() {
            return new GRPCHealthCheck(this.grpcServiceName, this.port, this.portName, this.portSpecification);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setGrpcServiceName(this.grpcServiceName);
            newBuilder.setPort(this.port);
            newBuilder.setPortName(this.portName);
            newBuilder.setPortSpecification(this.portSpecification);
            return newBuilder;
        }
    }
}

