/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteRouteHttpRequest;
import com.google.cloud.compute.v1.GetRouteHttpRequest;
import com.google.cloud.compute.v1.InsertRouteHttpRequest;
import com.google.cloud.compute.v1.ListRoutesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalRouteName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouteClient;
import com.google.cloud.compute.v1.RouteList;
import com.google.cloud.compute.v1.stub.HttpJsonRouteCallableFactory;
import com.google.cloud.compute.v1.stub.RouteStub;
import com.google.cloud.compute.v1.stub.RouteStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRouteStub
extends RouteStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteRouteHttpRequest, Operation> deleteRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routes.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/routes/{route}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalRouteName.newFactory()).setResourceNameField("route").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetRouteHttpRequest, Route> getRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routes.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/routes/{route}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalRouteName.newFactory()).setResourceNameField("route").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Route.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertRouteHttpRequest, Operation> insertRouteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routes.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/routes")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListRoutesHttpRequest, RouteList> listRoutesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.routes.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/routes")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)RouteList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteRouteHttpRequest, Operation> deleteRouteCallable;
    private final UnaryCallable<GetRouteHttpRequest, Route> getRouteCallable;
    private final UnaryCallable<InsertRouteHttpRequest, Operation> insertRouteCallable;
    private final UnaryCallable<ListRoutesHttpRequest, RouteList> listRoutesCallable;
    private final UnaryCallable<ListRoutesHttpRequest, RouteClient.ListRoutesPagedResponse> listRoutesPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRouteStub create(RouteStubSettings settings) throws IOException {
        return new HttpJsonRouteStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRouteStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRouteStub(RouteStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRouteStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRouteStub(RouteStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRouteStub(RouteStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRouteCallableFactory());
    }

    protected HttpJsonRouteStub(RouteStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRouteMethodDescriptor).build();
        HttpJsonCallSettings getRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRouteMethodDescriptor).build();
        HttpJsonCallSettings insertRouteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertRouteMethodDescriptor).build();
        HttpJsonCallSettings listRoutesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRoutesMethodDescriptor).build();
        this.deleteRouteCallable = callableFactory.createUnaryCallable(deleteRouteTransportSettings, settings.deleteRouteSettings(), clientContext);
        this.getRouteCallable = callableFactory.createUnaryCallable(getRouteTransportSettings, settings.getRouteSettings(), clientContext);
        this.insertRouteCallable = callableFactory.createUnaryCallable(insertRouteTransportSettings, settings.insertRouteSettings(), clientContext);
        this.listRoutesCallable = callableFactory.createUnaryCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.listRoutesPagedCallable = callableFactory.createPagedCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteRouteHttpRequest, Operation> deleteRouteCallable() {
        return this.deleteRouteCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetRouteHttpRequest, Route> getRouteCallable() {
        return this.getRouteCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertRouteHttpRequest, Operation> insertRouteCallable() {
        return this.insertRouteCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRoutesHttpRequest, RouteClient.ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.listRoutesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListRoutesHttpRequest, RouteList> listRoutesCallable() {
        return this.listRoutesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

