/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionResourcePolicyName;
import com.google.cloud.compute.v1.ProjectRegionResourcePolicyResourceName;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyClient;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonResourcePolicyCallableFactory;
import com.google.cloud.compute.v1.stub.ResourcePolicyStub;
import com.google.cloud.compute.v1.stub.ResourcePolicyStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonResourcePolicyStub
extends ResourcePolicyStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList> aggregatedListResourcePoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/resourcePolicies")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ResourcePolicyAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies/{resourcePolicy}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionResourcePolicyName.newFactory()).setResourceNameField("resourcePolicy").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies/{resourcePolicy}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionResourcePolicyName.newFactory()).setResourceNameField("resourcePolicy").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ResourcePolicy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"optionsRequestedPolicyVersion"})).setResourceNameFactory(ProjectRegionResourcePolicyResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListResourcePoliciesHttpRequest, ResourcePolicyList> listResourcePoliciesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectRegionName.newFactory()).setResourceNameField("region").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ResourcePolicyList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionResourcePolicyResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.resourcePolicies.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/regions/{region}/resourcePolicies/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectRegionResourcePolicyResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList> aggregatedListResourcePoliciesCallable;
    private final UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesPagedCallable;
    private final UnaryCallable<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicyCallable;
    private final UnaryCallable<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicyCallable;
    private final UnaryCallable<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicyCallable;
    private final UnaryCallable<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicyCallable;
    private final UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyList> listResourcePoliciesCallable;
    private final UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesPagedCallable;
    private final UnaryCallable<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicyCallable;
    private final UnaryCallable<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicyCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonResourcePolicyStub create(ResourcePolicyStubSettings settings) throws IOException {
        return new HttpJsonResourcePolicyStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonResourcePolicyStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonResourcePolicyStub(ResourcePolicyStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonResourcePolicyStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonResourcePolicyStub(ResourcePolicyStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonResourcePolicyStub(ResourcePolicyStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonResourcePolicyCallableFactory());
    }

    protected HttpJsonResourcePolicyStub(ResourcePolicyStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListResourcePoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListResourcePoliciesMethodDescriptor).build();
        HttpJsonCallSettings deleteResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteResourcePolicyMethodDescriptor).build();
        HttpJsonCallSettings getResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getResourcePolicyMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyResourcePolicyMethodDescriptor).build();
        HttpJsonCallSettings insertResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertResourcePolicyMethodDescriptor).build();
        HttpJsonCallSettings listResourcePoliciesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listResourcePoliciesMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyResourcePolicyMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsResourcePolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsResourcePolicyMethodDescriptor).build();
        this.aggregatedListResourcePoliciesCallable = callableFactory.createUnaryCallable(aggregatedListResourcePoliciesTransportSettings, settings.aggregatedListResourcePoliciesSettings(), clientContext);
        this.aggregatedListResourcePoliciesPagedCallable = callableFactory.createPagedCallable(aggregatedListResourcePoliciesTransportSettings, settings.aggregatedListResourcePoliciesSettings(), clientContext);
        this.deleteResourcePolicyCallable = callableFactory.createUnaryCallable(deleteResourcePolicyTransportSettings, settings.deleteResourcePolicySettings(), clientContext);
        this.getResourcePolicyCallable = callableFactory.createUnaryCallable(getResourcePolicyTransportSettings, settings.getResourcePolicySettings(), clientContext);
        this.getIamPolicyResourcePolicyCallable = callableFactory.createUnaryCallable(getIamPolicyResourcePolicyTransportSettings, settings.getIamPolicyResourcePolicySettings(), clientContext);
        this.insertResourcePolicyCallable = callableFactory.createUnaryCallable(insertResourcePolicyTransportSettings, settings.insertResourcePolicySettings(), clientContext);
        this.listResourcePoliciesCallable = callableFactory.createUnaryCallable(listResourcePoliciesTransportSettings, settings.listResourcePoliciesSettings(), clientContext);
        this.listResourcePoliciesPagedCallable = callableFactory.createPagedCallable(listResourcePoliciesTransportSettings, settings.listResourcePoliciesSettings(), clientContext);
        this.setIamPolicyResourcePolicyCallable = callableFactory.createUnaryCallable(setIamPolicyResourcePolicyTransportSettings, settings.setIamPolicyResourcePolicySettings(), clientContext);
        this.testIamPermissionsResourcePolicyCallable = callableFactory.createUnaryCallable(testIamPermissionsResourcePolicyTransportSettings, settings.testIamPermissionsResourcePolicySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyClient.AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesPagedCallable() {
        return this.aggregatedListResourcePoliciesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList> aggregatedListResourcePoliciesCallable() {
        return this.aggregatedListResourcePoliciesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicyCallable() {
        return this.deleteResourcePolicyCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicyCallable() {
        return this.getResourcePolicyCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicyCallable() {
        return this.getIamPolicyResourcePolicyCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicyCallable() {
        return this.insertResourcePolicyCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyClient.ListResourcePoliciesPagedResponse> listResourcePoliciesPagedCallable() {
        return this.listResourcePoliciesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyList> listResourcePoliciesCallable() {
        return this.listResourcePoliciesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicyCallable() {
        return this.setIamPolicyResourcePolicyCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicyCallable() {
        return this.testIamPermissionsResourcePolicyCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

