/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SslCertificateSelfManagedSslCertificate
implements ApiMessage {
    private final String certificate;
    private final String privateKey;
    private static final SslCertificateSelfManagedSslCertificate DEFAULT_INSTANCE = new SslCertificateSelfManagedSslCertificate();

    private SslCertificateSelfManagedSslCertificate() {
        this.certificate = null;
        this.privateKey = null;
    }

    private SslCertificateSelfManagedSslCertificate(String certificate, String privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public Object getFieldValue(String fieldName) {
        if ("certificate".equals(fieldName)) {
            return this.certificate;
        }
        if ("privateKey".equals(fieldName)) {
            return this.privateKey;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SslCertificateSelfManagedSslCertificate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SslCertificateSelfManagedSslCertificate getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SslCertificateSelfManagedSslCertificate{certificate=" + this.certificate + ", privateKey=" + this.privateKey + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SslCertificateSelfManagedSslCertificate) {
            SslCertificateSelfManagedSslCertificate that = (SslCertificateSelfManagedSslCertificate)o;
            return Objects.equals(this.certificate, that.getCertificate()) && Objects.equals(this.privateKey, that.getPrivateKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.privateKey);
    }

    public static class Builder {
        private String certificate;
        private String privateKey;

        Builder() {
        }

        public Builder mergeFrom(SslCertificateSelfManagedSslCertificate other) {
            if (other == SslCertificateSelfManagedSslCertificate.getDefaultInstance()) {
                return this;
            }
            if (other.getCertificate() != null) {
                this.certificate = other.certificate;
            }
            if (other.getPrivateKey() != null) {
                this.privateKey = other.privateKey;
            }
            return this;
        }

        Builder(SslCertificateSelfManagedSslCertificate source) {
            this.certificate = source.certificate;
            this.privateKey = source.privateKey;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public Builder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public SslCertificateSelfManagedSslCertificate build() {
            return new SslCertificateSelfManagedSslCertificate(this.certificate, this.privateKey);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCertificate(this.certificate);
            newBuilder.setPrivateKey(this.privateKey);
            return newBuilder;
        }
    }
}

