/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.GetRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.InsertRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.ListRegionNotificationEndpointsHttpRequest;
import com.google.cloud.compute.v1.NotificationEndpoint;
import com.google.cloud.compute.v1.NotificationEndpointList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionNotificationEndpointName;
import com.google.cloud.compute.v1.RegionNotificationEndpointSettings;
import com.google.cloud.compute.v1.stub.RegionNotificationEndpointStub;
import com.google.cloud.compute.v1.stub.RegionNotificationEndpointStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionNotificationEndpointClient
implements BackgroundResource {
    private final RegionNotificationEndpointSettings settings;
    private final RegionNotificationEndpointStub stub;

    public static final RegionNotificationEndpointClient create() throws IOException {
        return RegionNotificationEndpointClient.create(RegionNotificationEndpointSettings.newBuilder().build());
    }

    public static final RegionNotificationEndpointClient create(RegionNotificationEndpointSettings settings) throws IOException {
        return new RegionNotificationEndpointClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionNotificationEndpointClient create(RegionNotificationEndpointStub stub) {
        return new RegionNotificationEndpointClient(stub);
    }

    protected RegionNotificationEndpointClient(RegionNotificationEndpointSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionNotificationEndpointStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionNotificationEndpointClient(RegionNotificationEndpointStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionNotificationEndpointSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNotificationEndpointStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionNotificationEndpoint(ProjectRegionNotificationEndpointName notificationEndpoint) {
        DeleteRegionNotificationEndpointHttpRequest request = DeleteRegionNotificationEndpointHttpRequest.newBuilder().setNotificationEndpoint(notificationEndpoint == null ? null : notificationEndpoint.toString()).build();
        return this.deleteRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final Operation deleteRegionNotificationEndpoint(String notificationEndpoint) {
        DeleteRegionNotificationEndpointHttpRequest request = DeleteRegionNotificationEndpointHttpRequest.newBuilder().setNotificationEndpoint(notificationEndpoint).build();
        return this.deleteRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final Operation deleteRegionNotificationEndpoint(DeleteRegionNotificationEndpointHttpRequest request) {
        return (Operation)this.deleteRegionNotificationEndpointCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionNotificationEndpointHttpRequest, Operation> deleteRegionNotificationEndpointCallable() {
        return this.stub.deleteRegionNotificationEndpointCallable();
    }

    @BetaApi
    public final NotificationEndpoint getRegionNotificationEndpoint(ProjectRegionNotificationEndpointName notificationEndpoint) {
        GetRegionNotificationEndpointHttpRequest request = GetRegionNotificationEndpointHttpRequest.newBuilder().setNotificationEndpoint(notificationEndpoint == null ? null : notificationEndpoint.toString()).build();
        return this.getRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final NotificationEndpoint getRegionNotificationEndpoint(String notificationEndpoint) {
        GetRegionNotificationEndpointHttpRequest request = GetRegionNotificationEndpointHttpRequest.newBuilder().setNotificationEndpoint(notificationEndpoint).build();
        return this.getRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final NotificationEndpoint getRegionNotificationEndpoint(GetRegionNotificationEndpointHttpRequest request) {
        return (NotificationEndpoint)this.getRegionNotificationEndpointCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionNotificationEndpointHttpRequest, NotificationEndpoint> getRegionNotificationEndpointCallable() {
        return this.stub.getRegionNotificationEndpointCallable();
    }

    @BetaApi
    public final Operation insertRegionNotificationEndpoint(ProjectRegionName region, NotificationEndpoint notificationEndpointResource) {
        InsertRegionNotificationEndpointHttpRequest request = InsertRegionNotificationEndpointHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setNotificationEndpointResource(notificationEndpointResource).build();
        return this.insertRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final Operation insertRegionNotificationEndpoint(String region, NotificationEndpoint notificationEndpointResource) {
        InsertRegionNotificationEndpointHttpRequest request = InsertRegionNotificationEndpointHttpRequest.newBuilder().setRegion(region).setNotificationEndpointResource(notificationEndpointResource).build();
        return this.insertRegionNotificationEndpoint(request);
    }

    @BetaApi
    public final Operation insertRegionNotificationEndpoint(InsertRegionNotificationEndpointHttpRequest request) {
        return (Operation)this.insertRegionNotificationEndpointCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionNotificationEndpointHttpRequest, Operation> insertRegionNotificationEndpointCallable() {
        return this.stub.insertRegionNotificationEndpointCallable();
    }

    @BetaApi
    public final ListRegionNotificationEndpointsPagedResponse listRegionNotificationEndpoints(ProjectRegionName region) {
        ListRegionNotificationEndpointsHttpRequest request = ListRegionNotificationEndpointsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionNotificationEndpoints(request);
    }

    @BetaApi
    public final ListRegionNotificationEndpointsPagedResponse listRegionNotificationEndpoints(String region) {
        ListRegionNotificationEndpointsHttpRequest request = ListRegionNotificationEndpointsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionNotificationEndpoints(request);
    }

    @BetaApi
    public final ListRegionNotificationEndpointsPagedResponse listRegionNotificationEndpoints(ListRegionNotificationEndpointsHttpRequest request) {
        return (ListRegionNotificationEndpointsPagedResponse)((Object)this.listRegionNotificationEndpointsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionNotificationEndpointsHttpRequest, ListRegionNotificationEndpointsPagedResponse> listRegionNotificationEndpointsPagedCallable() {
        return this.stub.listRegionNotificationEndpointsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList> listRegionNotificationEndpointsCallable() {
        return this.stub.listRegionNotificationEndpointsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionNotificationEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint, ListRegionNotificationEndpointsPage, ListRegionNotificationEndpointsFixedSizeCollection> {
        private ListRegionNotificationEndpointsFixedSizeCollection(List<ListRegionNotificationEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionNotificationEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListRegionNotificationEndpointsFixedSizeCollection(null, 0);
        }

        protected ListRegionNotificationEndpointsFixedSizeCollection createCollection(List<ListRegionNotificationEndpointsPage> pages, int collectionSize) {
            return new ListRegionNotificationEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionNotificationEndpointsPage
    extends AbstractPage<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint, ListRegionNotificationEndpointsPage> {
        private ListRegionNotificationEndpointsPage(PageContext<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint> context, NotificationEndpointList response) {
            super(context, (Object)response);
        }

        private static ListRegionNotificationEndpointsPage createEmptyPage() {
            return new ListRegionNotificationEndpointsPage(null, null);
        }

        protected ListRegionNotificationEndpointsPage createPage(PageContext<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint> context, NotificationEndpointList response) {
            return new ListRegionNotificationEndpointsPage(context, response);
        }

        public ApiFuture<ListRegionNotificationEndpointsPage> createPageAsync(PageContext<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint> context, ApiFuture<NotificationEndpointList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionNotificationEndpointsPagedResponse
    extends AbstractPagedListResponse<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint, ListRegionNotificationEndpointsPage, ListRegionNotificationEndpointsFixedSizeCollection> {
        public static ApiFuture<ListRegionNotificationEndpointsPagedResponse> createAsync(PageContext<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint> context, ApiFuture<NotificationEndpointList> futureResponse) {
            ApiFuture<ListRegionNotificationEndpointsPage> futurePage = ListRegionNotificationEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionNotificationEndpointsPage, ListRegionNotificationEndpointsPagedResponse>(){

                public ListRegionNotificationEndpointsPagedResponse apply(ListRegionNotificationEndpointsPage input) {
                    return new ListRegionNotificationEndpointsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionNotificationEndpointsPagedResponse(ListRegionNotificationEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionNotificationEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }
}

