/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PerInstanceConfig;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RegionInstanceGroupManagersListInstanceConfigsResp
implements ApiMessage {
    private final List<PerInstanceConfig> items;
    private final String nextPageToken;
    private final Warning warning;
    private static final RegionInstanceGroupManagersListInstanceConfigsResp DEFAULT_INSTANCE = new RegionInstanceGroupManagersListInstanceConfigsResp();

    private RegionInstanceGroupManagersListInstanceConfigsResp() {
        this.items = null;
        this.nextPageToken = null;
        this.warning = null;
    }

    private RegionInstanceGroupManagersListInstanceConfigsResp(List<PerInstanceConfig> items, String nextPageToken, Warning warning) {
        this.items = items;
        this.nextPageToken = nextPageToken;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("items".equals(fieldName)) {
            return this.items;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<PerInstanceConfig> getItemsList() {
        return this.items;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RegionInstanceGroupManagersListInstanceConfigsResp prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RegionInstanceGroupManagersListInstanceConfigsResp getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RegionInstanceGroupManagersListInstanceConfigsResp{items=" + this.items + ", nextPageToken=" + this.nextPageToken + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegionInstanceGroupManagersListInstanceConfigsResp) {
            RegionInstanceGroupManagersListInstanceConfigsResp that = (RegionInstanceGroupManagersListInstanceConfigsResp)o;
            return Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken, this.warning);
    }

    public static class Builder {
        private List<PerInstanceConfig> items;
        private String nextPageToken;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(RegionInstanceGroupManagersListInstanceConfigsResp other) {
            if (other == RegionInstanceGroupManagersListInstanceConfigsResp.getDefaultInstance()) {
                return this;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(RegionInstanceGroupManagersListInstanceConfigsResp source) {
            this.items = source.items;
            this.nextPageToken = source.nextPageToken;
            this.warning = source.warning;
        }

        public List<PerInstanceConfig> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<PerInstanceConfig> items) {
            if (this.items == null) {
                this.items = new LinkedList<PerInstanceConfig>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(PerInstanceConfig items) {
            if (this.items == null) {
                this.items = new LinkedList<PerInstanceConfig>();
            }
            this.items.add(items);
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public RegionInstanceGroupManagersListInstanceConfigsResp build() {
            return new RegionInstanceGroupManagersListInstanceConfigsResp(this.items, this.nextPageToken, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllItems(this.items);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

