/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HealthStatusForNetworkEndpoint;
import com.google.cloud.compute.v1.NetworkEndpoint;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpointWithHealthStatus
implements ApiMessage {
    private final List<HealthStatusForNetworkEndpoint> healths;
    private final NetworkEndpoint networkEndpoint;
    private static final NetworkEndpointWithHealthStatus DEFAULT_INSTANCE = new NetworkEndpointWithHealthStatus();

    private NetworkEndpointWithHealthStatus() {
        this.healths = null;
        this.networkEndpoint = null;
    }

    private NetworkEndpointWithHealthStatus(List<HealthStatusForNetworkEndpoint> healths, NetworkEndpoint networkEndpoint) {
        this.healths = healths;
        this.networkEndpoint = networkEndpoint;
    }

    public Object getFieldValue(String fieldName) {
        if ("healths".equals(fieldName)) {
            return this.healths;
        }
        if ("networkEndpoint".equals(fieldName)) {
            return this.networkEndpoint;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<HealthStatusForNetworkEndpoint> getHealthsList() {
        return this.healths;
    }

    public NetworkEndpoint getNetworkEndpoint() {
        return this.networkEndpoint;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpointWithHealthStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpointWithHealthStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpointWithHealthStatus{healths=" + this.healths + ", networkEndpoint=" + this.networkEndpoint + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpointWithHealthStatus) {
            NetworkEndpointWithHealthStatus that = (NetworkEndpointWithHealthStatus)o;
            return Objects.equals(this.healths, that.getHealthsList()) && Objects.equals(this.networkEndpoint, that.getNetworkEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healths, this.networkEndpoint);
    }

    public static class Builder {
        private List<HealthStatusForNetworkEndpoint> healths;
        private NetworkEndpoint networkEndpoint;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpointWithHealthStatus other) {
            if (other == NetworkEndpointWithHealthStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getHealthsList() != null) {
                this.healths = other.healths;
            }
            if (other.getNetworkEndpoint() != null) {
                this.networkEndpoint = other.networkEndpoint;
            }
            return this;
        }

        Builder(NetworkEndpointWithHealthStatus source) {
            this.healths = source.healths;
            this.networkEndpoint = source.networkEndpoint;
        }

        public List<HealthStatusForNetworkEndpoint> getHealthsList() {
            return this.healths;
        }

        public Builder addAllHealths(List<HealthStatusForNetworkEndpoint> healths) {
            if (this.healths == null) {
                this.healths = new LinkedList<HealthStatusForNetworkEndpoint>();
            }
            this.healths.addAll(healths);
            return this;
        }

        public Builder addHealths(HealthStatusForNetworkEndpoint healths) {
            if (this.healths == null) {
                this.healths = new LinkedList<HealthStatusForNetworkEndpoint>();
            }
            this.healths.add(healths);
            return this;
        }

        public NetworkEndpoint getNetworkEndpoint() {
            return this.networkEndpoint;
        }

        public Builder setNetworkEndpoint(NetworkEndpoint networkEndpoint) {
            this.networkEndpoint = networkEndpoint;
            return this;
        }

        public NetworkEndpointWithHealthStatus build() {
            return new NetworkEndpointWithHealthStatus(this.healths, this.networkEndpoint);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllHealths(this.healths);
            newBuilder.setNetworkEndpoint(this.networkEndpoint);
            return newBuilder;
        }
    }
}

