/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.ExternalVpnGateway;
import com.google.cloud.compute.v1.ExternalVpnGatewayList;
import com.google.cloud.compute.v1.ExternalVpnGatewaySettings;
import com.google.cloud.compute.v1.GetExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.InsertExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.ListExternalVpnGatewaysHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalExternalVpnGatewayName;
import com.google.cloud.compute.v1.ProjectGlobalExternalVpnGatewayResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetLabelsExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsExternalVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ExternalVpnGatewayStub;
import com.google.cloud.compute.v1.stub.ExternalVpnGatewayStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExternalVpnGatewayClient
implements BackgroundResource {
    private final ExternalVpnGatewaySettings settings;
    private final ExternalVpnGatewayStub stub;

    public static final ExternalVpnGatewayClient create() throws IOException {
        return ExternalVpnGatewayClient.create(ExternalVpnGatewaySettings.newBuilder().build());
    }

    public static final ExternalVpnGatewayClient create(ExternalVpnGatewaySettings settings) throws IOException {
        return new ExternalVpnGatewayClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ExternalVpnGatewayClient create(ExternalVpnGatewayStub stub) {
        return new ExternalVpnGatewayClient(stub);
    }

    protected ExternalVpnGatewayClient(ExternalVpnGatewaySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExternalVpnGatewayStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ExternalVpnGatewayClient(ExternalVpnGatewayStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExternalVpnGatewaySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ExternalVpnGatewayStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteExternalVpnGateway(ProjectGlobalExternalVpnGatewayName externalVpnGateway) {
        DeleteExternalVpnGatewayHttpRequest request = DeleteExternalVpnGatewayHttpRequest.newBuilder().setExternalVpnGateway(externalVpnGateway == null ? null : externalVpnGateway.toString()).build();
        return this.deleteExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation deleteExternalVpnGateway(String externalVpnGateway) {
        DeleteExternalVpnGatewayHttpRequest request = DeleteExternalVpnGatewayHttpRequest.newBuilder().setExternalVpnGateway(externalVpnGateway).build();
        return this.deleteExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation deleteExternalVpnGateway(DeleteExternalVpnGatewayHttpRequest request) {
        return (Operation)this.deleteExternalVpnGatewayCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteExternalVpnGatewayHttpRequest, Operation> deleteExternalVpnGatewayCallable() {
        return this.stub.deleteExternalVpnGatewayCallable();
    }

    @BetaApi
    public final ExternalVpnGateway getExternalVpnGateway(ProjectGlobalExternalVpnGatewayName externalVpnGateway) {
        GetExternalVpnGatewayHttpRequest request = GetExternalVpnGatewayHttpRequest.newBuilder().setExternalVpnGateway(externalVpnGateway == null ? null : externalVpnGateway.toString()).build();
        return this.getExternalVpnGateway(request);
    }

    @BetaApi
    public final ExternalVpnGateway getExternalVpnGateway(String externalVpnGateway) {
        GetExternalVpnGatewayHttpRequest request = GetExternalVpnGatewayHttpRequest.newBuilder().setExternalVpnGateway(externalVpnGateway).build();
        return this.getExternalVpnGateway(request);
    }

    @BetaApi
    public final ExternalVpnGateway getExternalVpnGateway(GetExternalVpnGatewayHttpRequest request) {
        return (ExternalVpnGateway)this.getExternalVpnGatewayCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetExternalVpnGatewayHttpRequest, ExternalVpnGateway> getExternalVpnGatewayCallable() {
        return this.stub.getExternalVpnGatewayCallable();
    }

    @BetaApi
    public final Operation insertExternalVpnGateway(ProjectName project, ExternalVpnGateway externalVpnGatewayResource) {
        InsertExternalVpnGatewayHttpRequest request = InsertExternalVpnGatewayHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setExternalVpnGatewayResource(externalVpnGatewayResource).build();
        return this.insertExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation insertExternalVpnGateway(String project, ExternalVpnGateway externalVpnGatewayResource) {
        InsertExternalVpnGatewayHttpRequest request = InsertExternalVpnGatewayHttpRequest.newBuilder().setProject(project).setExternalVpnGatewayResource(externalVpnGatewayResource).build();
        return this.insertExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation insertExternalVpnGateway(InsertExternalVpnGatewayHttpRequest request) {
        return (Operation)this.insertExternalVpnGatewayCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertExternalVpnGatewayHttpRequest, Operation> insertExternalVpnGatewayCallable() {
        return this.stub.insertExternalVpnGatewayCallable();
    }

    @BetaApi
    public final ListExternalVpnGatewaysPagedResponse listExternalVpnGateways(ProjectName project) {
        ListExternalVpnGatewaysHttpRequest request = ListExternalVpnGatewaysHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listExternalVpnGateways(request);
    }

    @BetaApi
    public final ListExternalVpnGatewaysPagedResponse listExternalVpnGateways(String project) {
        ListExternalVpnGatewaysHttpRequest request = ListExternalVpnGatewaysHttpRequest.newBuilder().setProject(project).build();
        return this.listExternalVpnGateways(request);
    }

    @BetaApi
    public final ListExternalVpnGatewaysPagedResponse listExternalVpnGateways(ListExternalVpnGatewaysHttpRequest request) {
        return (ListExternalVpnGatewaysPagedResponse)((Object)this.listExternalVpnGatewaysPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListExternalVpnGatewaysHttpRequest, ListExternalVpnGatewaysPagedResponse> listExternalVpnGatewaysPagedCallable() {
        return this.stub.listExternalVpnGatewaysPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList> listExternalVpnGatewaysCallable() {
        return this.stub.listExternalVpnGatewaysCallable();
    }

    @BetaApi
    public final Operation setLabelsExternalVpnGateway(ProjectGlobalExternalVpnGatewayResourceName resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsExternalVpnGatewayHttpRequest request = SetLabelsExternalVpnGatewayHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation setLabelsExternalVpnGateway(String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsExternalVpnGatewayHttpRequest request = SetLabelsExternalVpnGatewayHttpRequest.newBuilder().setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsExternalVpnGateway(request);
    }

    @BetaApi
    public final Operation setLabelsExternalVpnGateway(SetLabelsExternalVpnGatewayHttpRequest request) {
        return (Operation)this.setLabelsExternalVpnGatewayCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsExternalVpnGatewayHttpRequest, Operation> setLabelsExternalVpnGatewayCallable() {
        return this.stub.setLabelsExternalVpnGatewayCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsExternalVpnGateway(ProjectGlobalExternalVpnGatewayResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsExternalVpnGatewayHttpRequest request = TestIamPermissionsExternalVpnGatewayHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsExternalVpnGateway(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsExternalVpnGateway(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsExternalVpnGatewayHttpRequest request = TestIamPermissionsExternalVpnGatewayHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsExternalVpnGateway(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsExternalVpnGateway(TestIamPermissionsExternalVpnGatewayHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsExternalVpnGatewayCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsExternalVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsExternalVpnGatewayCallable() {
        return this.stub.testIamPermissionsExternalVpnGatewayCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListExternalVpnGatewaysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListExternalVpnGatewaysPage, ListExternalVpnGatewaysFixedSizeCollection> {
        private ListExternalVpnGatewaysFixedSizeCollection(List<ListExternalVpnGatewaysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExternalVpnGatewaysFixedSizeCollection createEmptyCollection() {
            return new ListExternalVpnGatewaysFixedSizeCollection(null, 0);
        }

        protected ListExternalVpnGatewaysFixedSizeCollection createCollection(List<ListExternalVpnGatewaysPage> pages, int collectionSize) {
            return new ListExternalVpnGatewaysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExternalVpnGatewaysPage
    extends AbstractPage<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListExternalVpnGatewaysPage> {
        private ListExternalVpnGatewaysPage(PageContext<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ExternalVpnGatewayList response) {
            super(context, (Object)response);
        }

        private static ListExternalVpnGatewaysPage createEmptyPage() {
            return new ListExternalVpnGatewaysPage(null, null);
        }

        protected ListExternalVpnGatewaysPage createPage(PageContext<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ExternalVpnGatewayList response) {
            return new ListExternalVpnGatewaysPage(context, response);
        }

        public ApiFuture<ListExternalVpnGatewaysPage> createPageAsync(PageContext<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ApiFuture<ExternalVpnGatewayList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExternalVpnGatewaysPagedResponse
    extends AbstractPagedListResponse<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListExternalVpnGatewaysPage, ListExternalVpnGatewaysFixedSizeCollection> {
        public static ApiFuture<ListExternalVpnGatewaysPagedResponse> createAsync(PageContext<ListExternalVpnGatewaysHttpRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ApiFuture<ExternalVpnGatewayList> futureResponse) {
            ApiFuture<ListExternalVpnGatewaysPage> futurePage = ListExternalVpnGatewaysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListExternalVpnGatewaysPage, ListExternalVpnGatewaysPagedResponse>(){

                public ListExternalVpnGatewaysPagedResponse apply(ListExternalVpnGatewaysPage input) {
                    return new ListExternalVpnGatewaysPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListExternalVpnGatewaysPagedResponse(ListExternalVpnGatewaysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExternalVpnGatewaysFixedSizeCollection.createEmptyCollection());
        }
    }
}

