/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.GetRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkEndpointGroupHttpRequest;
import com.google.cloud.compute.v1.ListRegionNetworkEndpointGroupsHttpRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionNetworkEndpointGroupClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionNetworkEndpointGroupStub;
import com.google.cloud.compute.v1.stub.RegionNetworkEndpointGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionNetworkEndpointGroupStubSettings
extends StubSettings<RegionNetworkEndpointGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionNetworkEndpointGroupHttpRequest, Operation> deleteRegionNetworkEndpointGroupSettings;
    private final UnaryCallSettings<GetRegionNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getRegionNetworkEndpointGroupSettings;
    private final UnaryCallSettings<InsertRegionNetworkEndpointGroupHttpRequest, Operation> insertRegionNetworkEndpointGroupSettings;
    private final PagedCallSettings<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> listRegionNetworkEndpointGroupsSettings;
    private static final PagedListDescriptor<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup> LIST_REGION_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionNetworkEndpointGroupsHttpRequest injectToken(ListRegionNetworkEndpointGroupsHttpRequest payload, String token) {
            return ListRegionNetworkEndpointGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionNetworkEndpointGroupsHttpRequest injectPageSize(ListRegionNetworkEndpointGroupsHttpRequest payload, int pageSize) {
            return ListRegionNetworkEndpointGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionNetworkEndpointGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroup> extractResources(NetworkEndpointGroupList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> LIST_REGION_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse>(){

        public ApiFuture<RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList> callable, ListRegionNetworkEndpointGroupsHttpRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_NETWORK_ENDPOINT_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse.createAsync((PageContext<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, NetworkEndpointGroup>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionNetworkEndpointGroupHttpRequest, Operation> deleteRegionNetworkEndpointGroupSettings() {
        return this.deleteRegionNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<GetRegionNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getRegionNetworkEndpointGroupSettings() {
        return this.getRegionNetworkEndpointGroupSettings;
    }

    public UnaryCallSettings<InsertRegionNetworkEndpointGroupHttpRequest, Operation> insertRegionNetworkEndpointGroupSettings() {
        return this.insertRegionNetworkEndpointGroupSettings;
    }

    public PagedCallSettings<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> listRegionNetworkEndpointGroupsSettings() {
        return this.listRegionNetworkEndpointGroupsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNetworkEndpointGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionNetworkEndpointGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionNetworkEndpointGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionNetworkEndpointGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionNetworkEndpointGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionNetworkEndpointGroupSettings = settingsBuilder.deleteRegionNetworkEndpointGroupSettings().build();
        this.getRegionNetworkEndpointGroupSettings = settingsBuilder.getRegionNetworkEndpointGroupSettings().build();
        this.insertRegionNetworkEndpointGroupSettings = settingsBuilder.insertRegionNetworkEndpointGroupSettings().build();
        this.listRegionNetworkEndpointGroupsSettings = settingsBuilder.listRegionNetworkEndpointGroupsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionNetworkEndpointGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionNetworkEndpointGroupHttpRequest, Operation> deleteRegionNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<GetRegionNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getRegionNetworkEndpointGroupSettings;
        private final UnaryCallSettings.Builder<InsertRegionNetworkEndpointGroupHttpRequest, Operation> insertRegionNetworkEndpointGroupSettings;
        private final PagedCallSettings.Builder<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> listRegionNetworkEndpointGroupsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionNetworkEndpointGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionNetworkEndpointGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_NETWORK_ENDPOINT_GROUPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionNetworkEndpointGroupSettings, this.getRegionNetworkEndpointGroupSettings, this.insertRegionNetworkEndpointGroupSettings, this.listRegionNetworkEndpointGroupsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionNetworkEndpointGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionNetworkEndpointGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionNetworkEndpointGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionNetworkEndpointGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionNetworkEndpointGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionNetworkEndpointGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionNetworkEndpointGroupStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionNetworkEndpointGroupSettings = settings.deleteRegionNetworkEndpointGroupSettings.toBuilder();
            this.getRegionNetworkEndpointGroupSettings = settings.getRegionNetworkEndpointGroupSettings.toBuilder();
            this.insertRegionNetworkEndpointGroupSettings = settings.insertRegionNetworkEndpointGroupSettings.toBuilder();
            this.listRegionNetworkEndpointGroupsSettings = settings.listRegionNetworkEndpointGroupsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionNetworkEndpointGroupSettings, this.getRegionNetworkEndpointGroupSettings, this.insertRegionNetworkEndpointGroupSettings, this.listRegionNetworkEndpointGroupsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionNetworkEndpointGroupHttpRequest, Operation> deleteRegionNetworkEndpointGroupSettings() {
            return this.deleteRegionNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<GetRegionNetworkEndpointGroupHttpRequest, NetworkEndpointGroup> getRegionNetworkEndpointGroupSettings() {
            return this.getRegionNetworkEndpointGroupSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionNetworkEndpointGroupHttpRequest, Operation> insertRegionNetworkEndpointGroupSettings() {
            return this.insertRegionNetworkEndpointGroupSettings;
        }

        public PagedCallSettings.Builder<ListRegionNetworkEndpointGroupsHttpRequest, NetworkEndpointGroupList, RegionNetworkEndpointGroupClient.ListRegionNetworkEndpointGroupsPagedResponse> listRegionNetworkEndpointGroupsSettings() {
            return this.listRegionNetworkEndpointGroupsSettings;
        }

        public RegionNetworkEndpointGroupStubSettings build() throws IOException {
            return new RegionNetworkEndpointGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

