/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.AutoscalerAggregatedList;
import com.google.cloud.compute.v1.AutoscalerClient;
import com.google.cloud.compute.v1.AutoscalerList;
import com.google.cloud.compute.v1.DeleteAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneAutoscalerName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.UpdateAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.AutoscalerStub;
import com.google.cloud.compute.v1.stub.AutoscalerStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonAutoscalerCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonAutoscalerStub
extends AutoscalerStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList> aggregatedListAutoscalersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "includeAllScopes", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)AutoscalerAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers/{autoscaler}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneAutoscalerName.newFactory()).setResourceNameField("autoscaler").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers/{autoscaler}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneAutoscalerName.newFactory()).setResourceNameField("autoscaler").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Autoscaler.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertAutoscalerHttpRequest, Operation> insertAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListAutoscalersHttpRequest, AutoscalerList> listAutoscalersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)AutoscalerList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchAutoscalerHttpRequest, Operation> patchAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"autoscaler", "requestId"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.autoscalers.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}/autoscalers")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"autoscaler", "requestId"})).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList> aggregatedListAutoscalersCallable;
    private final UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersPagedCallable;
    private final UnaryCallable<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerCallable;
    private final UnaryCallable<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerCallable;
    private final UnaryCallable<InsertAutoscalerHttpRequest, Operation> insertAutoscalerCallable;
    private final UnaryCallable<ListAutoscalersHttpRequest, AutoscalerList> listAutoscalersCallable;
    private final UnaryCallable<ListAutoscalersHttpRequest, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersPagedCallable;
    private final UnaryCallable<PatchAutoscalerHttpRequest, Operation> patchAutoscalerCallable;
    private final UnaryCallable<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAutoscalerStub create(AutoscalerStubSettings settings) throws IOException {
        return new HttpJsonAutoscalerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAutoscalerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAutoscalerStub(AutoscalerStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonAutoscalerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAutoscalerStub(AutoscalerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAutoscalerStub(AutoscalerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAutoscalerCallableFactory());
    }

    protected HttpJsonAutoscalerStub(AutoscalerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListAutoscalersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListAutoscalersMethodDescriptor).build();
        HttpJsonCallSettings deleteAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings getAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings insertAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings listAutoscalersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAutoscalersMethodDescriptor).build();
        HttpJsonCallSettings patchAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchAutoscalerMethodDescriptor).build();
        HttpJsonCallSettings updateAutoscalerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAutoscalerMethodDescriptor).build();
        this.aggregatedListAutoscalersCallable = callableFactory.createUnaryCallable(aggregatedListAutoscalersTransportSettings, settings.aggregatedListAutoscalersSettings(), clientContext);
        this.aggregatedListAutoscalersPagedCallable = callableFactory.createPagedCallable(aggregatedListAutoscalersTransportSettings, settings.aggregatedListAutoscalersSettings(), clientContext);
        this.deleteAutoscalerCallable = callableFactory.createUnaryCallable(deleteAutoscalerTransportSettings, settings.deleteAutoscalerSettings(), clientContext);
        this.getAutoscalerCallable = callableFactory.createUnaryCallable(getAutoscalerTransportSettings, settings.getAutoscalerSettings(), clientContext);
        this.insertAutoscalerCallable = callableFactory.createUnaryCallable(insertAutoscalerTransportSettings, settings.insertAutoscalerSettings(), clientContext);
        this.listAutoscalersCallable = callableFactory.createUnaryCallable(listAutoscalersTransportSettings, settings.listAutoscalersSettings(), clientContext);
        this.listAutoscalersPagedCallable = callableFactory.createPagedCallable(listAutoscalersTransportSettings, settings.listAutoscalersSettings(), clientContext);
        this.patchAutoscalerCallable = callableFactory.createUnaryCallable(patchAutoscalerTransportSettings, settings.patchAutoscalerSettings(), clientContext);
        this.updateAutoscalerCallable = callableFactory.createUnaryCallable(updateAutoscalerTransportSettings, settings.updateAutoscalerSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersPagedCallable() {
        return this.aggregatedListAutoscalersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList> aggregatedListAutoscalersCallable() {
        return this.aggregatedListAutoscalersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerCallable() {
        return this.deleteAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerCallable() {
        return this.getAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertAutoscalerHttpRequest, Operation> insertAutoscalerCallable() {
        return this.insertAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListAutoscalersHttpRequest, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersPagedCallable() {
        return this.listAutoscalersPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListAutoscalersHttpRequest, AutoscalerList> listAutoscalersCallable() {
        return this.listAutoscalersCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchAutoscalerHttpRequest, Operation> patchAutoscalerCallable() {
        return this.patchAutoscalerCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerCallable() {
        return this.updateAutoscalerCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

