/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpProxiesHttpRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetHttpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalTargetHttpProxyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectTargetHttpProxyName;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.TargetHttpProxySettings;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.TargetHttpProxyStub;
import com.google.cloud.compute.v1.stub.TargetHttpProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetHttpProxyClient
implements BackgroundResource {
    private final TargetHttpProxySettings settings;
    private final TargetHttpProxyStub stub;

    public static final TargetHttpProxyClient create() throws IOException {
        return TargetHttpProxyClient.create(TargetHttpProxySettings.newBuilder().build());
    }

    public static final TargetHttpProxyClient create(TargetHttpProxySettings settings) throws IOException {
        return new TargetHttpProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetHttpProxyClient create(TargetHttpProxyStub stub) {
        return new TargetHttpProxyClient(stub);
    }

    protected TargetHttpProxyClient(TargetHttpProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetHttpProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetHttpProxyClient(TargetHttpProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetHttpProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListTargetHttpProxiesPagedResponse aggregatedListTargetHttpProxies(Boolean includeAllScopes, ProjectName project) {
        AggregatedListTargetHttpProxiesHttpRequest request = AggregatedListTargetHttpProxiesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListTargetHttpProxies(request);
    }

    @BetaApi
    public final AggregatedListTargetHttpProxiesPagedResponse aggregatedListTargetHttpProxies(Boolean includeAllScopes, String project) {
        AggregatedListTargetHttpProxiesHttpRequest request = AggregatedListTargetHttpProxiesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListTargetHttpProxies(request);
    }

    @BetaApi
    public final AggregatedListTargetHttpProxiesPagedResponse aggregatedListTargetHttpProxies(AggregatedListTargetHttpProxiesHttpRequest request) {
        return (AggregatedListTargetHttpProxiesPagedResponse)((Object)this.aggregatedListTargetHttpProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetHttpProxiesHttpRequest, AggregatedListTargetHttpProxiesPagedResponse> aggregatedListTargetHttpProxiesPagedCallable() {
        return this.stub.aggregatedListTargetHttpProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList> aggregatedListTargetHttpProxiesCallable() {
        return this.stub.aggregatedListTargetHttpProxiesCallable();
    }

    @BetaApi
    public final Operation deleteTargetHttpProxy(ProjectGlobalTargetHttpProxyName targetHttpProxy) {
        DeleteTargetHttpProxyHttpRequest request = DeleteTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).build();
        return this.deleteTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetHttpProxy(String targetHttpProxy) {
        DeleteTargetHttpProxyHttpRequest request = DeleteTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).build();
        return this.deleteTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetHttpProxy(DeleteTargetHttpProxyHttpRequest request) {
        return (Operation)this.deleteTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetHttpProxyHttpRequest, Operation> deleteTargetHttpProxyCallable() {
        return this.stub.deleteTargetHttpProxyCallable();
    }

    @BetaApi
    public final TargetHttpProxy getTargetHttpProxy(ProjectGlobalTargetHttpProxyName targetHttpProxy) {
        GetTargetHttpProxyHttpRequest request = GetTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).build();
        return this.getTargetHttpProxy(request);
    }

    @BetaApi
    public final TargetHttpProxy getTargetHttpProxy(String targetHttpProxy) {
        GetTargetHttpProxyHttpRequest request = GetTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).build();
        return this.getTargetHttpProxy(request);
    }

    @BetaApi
    public final TargetHttpProxy getTargetHttpProxy(GetTargetHttpProxyHttpRequest request) {
        return (TargetHttpProxy)this.getTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetHttpProxyHttpRequest, TargetHttpProxy> getTargetHttpProxyCallable() {
        return this.stub.getTargetHttpProxyCallable();
    }

    @BetaApi
    public final Operation insertTargetHttpProxy(ProjectName project, TargetHttpProxy targetHttpProxyResource) {
        InsertTargetHttpProxyHttpRequest request = InsertTargetHttpProxyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation insertTargetHttpProxy(String project, TargetHttpProxy targetHttpProxyResource) {
        InsertTargetHttpProxyHttpRequest request = InsertTargetHttpProxyHttpRequest.newBuilder().setProject(project).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation insertTargetHttpProxy(InsertTargetHttpProxyHttpRequest request) {
        return (Operation)this.insertTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetHttpProxyHttpRequest, Operation> insertTargetHttpProxyCallable() {
        return this.stub.insertTargetHttpProxyCallable();
    }

    @BetaApi
    public final ListTargetHttpProxiesPagedResponse listTargetHttpProxies(ProjectName project) {
        ListTargetHttpProxiesHttpRequest request = ListTargetHttpProxiesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTargetHttpProxies(request);
    }

    @BetaApi
    public final ListTargetHttpProxiesPagedResponse listTargetHttpProxies(String project) {
        ListTargetHttpProxiesHttpRequest request = ListTargetHttpProxiesHttpRequest.newBuilder().setProject(project).build();
        return this.listTargetHttpProxies(request);
    }

    @BetaApi
    public final ListTargetHttpProxiesPagedResponse listTargetHttpProxies(ListTargetHttpProxiesHttpRequest request) {
        return (ListTargetHttpProxiesPagedResponse)((Object)this.listTargetHttpProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetHttpProxiesHttpRequest, ListTargetHttpProxiesPagedResponse> listTargetHttpProxiesPagedCallable() {
        return this.stub.listTargetHttpProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList> listTargetHttpProxiesCallable() {
        return this.stub.listTargetHttpProxiesCallable();
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpProxy(ProjectTargetHttpProxyName targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpProxyHttpRequest request = SetUrlMapTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpProxy(String targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpProxyHttpRequest request = SetUrlMapTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapTargetHttpProxy(SetUrlMapTargetHttpProxyHttpRequest request) {
        return (Operation)this.setUrlMapTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetUrlMapTargetHttpProxyHttpRequest, Operation> setUrlMapTargetHttpProxyCallable() {
        return this.stub.setUrlMapTargetHttpProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetHttpProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListTargetHttpProxiesPage, ListTargetHttpProxiesFixedSizeCollection> {
        private ListTargetHttpProxiesFixedSizeCollection(List<ListTargetHttpProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetHttpProxiesFixedSizeCollection createEmptyCollection() {
            return new ListTargetHttpProxiesFixedSizeCollection(null, 0);
        }

        protected ListTargetHttpProxiesFixedSizeCollection createCollection(List<ListTargetHttpProxiesPage> pages, int collectionSize) {
            return new ListTargetHttpProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetHttpProxiesPage
    extends AbstractPage<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListTargetHttpProxiesPage> {
        private ListTargetHttpProxiesPage(PageContext<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            super(context, (Object)response);
        }

        private static ListTargetHttpProxiesPage createEmptyPage() {
            return new ListTargetHttpProxiesPage(null, null);
        }

        protected ListTargetHttpProxiesPage createPage(PageContext<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            return new ListTargetHttpProxiesPage(context, response);
        }

        public ApiFuture<ListTargetHttpProxiesPage> createPageAsync(PageContext<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetHttpProxiesPagedResponse
    extends AbstractPagedListResponse<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListTargetHttpProxiesPage, ListTargetHttpProxiesFixedSizeCollection> {
        public static ApiFuture<ListTargetHttpProxiesPagedResponse> createAsync(PageContext<ListTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            ApiFuture<ListTargetHttpProxiesPage> futurePage = ListTargetHttpProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetHttpProxiesPage, ListTargetHttpProxiesPagedResponse>(){

                public ListTargetHttpProxiesPagedResponse apply(ListTargetHttpProxiesPage input) {
                    return new ListTargetHttpProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetHttpProxiesPagedResponse(ListTargetHttpProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetHttpProxiesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListTargetHttpProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList, AggregatedListTargetHttpProxiesPage, AggregatedListTargetHttpProxiesFixedSizeCollection> {
        private AggregatedListTargetHttpProxiesFixedSizeCollection(List<AggregatedListTargetHttpProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListTargetHttpProxiesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListTargetHttpProxiesFixedSizeCollection(null, 0);
        }

        protected AggregatedListTargetHttpProxiesFixedSizeCollection createCollection(List<AggregatedListTargetHttpProxiesPage> pages, int collectionSize) {
            return new AggregatedListTargetHttpProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListTargetHttpProxiesPage
    extends AbstractPage<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList, AggregatedListTargetHttpProxiesPage> {
        private AggregatedListTargetHttpProxiesPage(PageContext<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList> context, TargetHttpProxyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListTargetHttpProxiesPage createEmptyPage() {
            return new AggregatedListTargetHttpProxiesPage(null, null);
        }

        protected AggregatedListTargetHttpProxiesPage createPage(PageContext<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList> context, TargetHttpProxyAggregatedList response) {
            return new AggregatedListTargetHttpProxiesPage(context, response);
        }

        public ApiFuture<AggregatedListTargetHttpProxiesPage> createPageAsync(PageContext<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList> context, ApiFuture<TargetHttpProxyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListTargetHttpProxiesPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList, AggregatedListTargetHttpProxiesPage, AggregatedListTargetHttpProxiesFixedSizeCollection> {
        public static ApiFuture<AggregatedListTargetHttpProxiesPagedResponse> createAsync(PageContext<AggregatedListTargetHttpProxiesHttpRequest, TargetHttpProxyAggregatedList, TargetHttpProxiesScopedList> context, ApiFuture<TargetHttpProxyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListTargetHttpProxiesPage> futurePage = AggregatedListTargetHttpProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListTargetHttpProxiesPage, AggregatedListTargetHttpProxiesPagedResponse>(){

                public AggregatedListTargetHttpProxiesPagedResponse apply(AggregatedListTargetHttpProxiesPage input) {
                    return new AggregatedListTargetHttpProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListTargetHttpProxiesPagedResponse(AggregatedListTargetHttpProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListTargetHttpProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

