/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionNotificationEndpointName
implements ResourceName {
    private final String notificationEndpoint;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionNotificationEndpointName(Builder builder) {
        this.notificationEndpoint = (String)Preconditions.checkNotNull((Object)builder.getNotificationEndpoint());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionNotificationEndpointName of(String notificationEndpoint, String project, String region) {
        return ProjectRegionNotificationEndpointName.newBuilder().setNotificationEndpoint(notificationEndpoint).setProject(project).setRegion(region).build();
    }

    public static String format(String notificationEndpoint, String project, String region) {
        return ProjectRegionNotificationEndpointName.of(notificationEndpoint, project, region).toString();
    }

    public String getNotificationEndpoint() {
        return this.notificationEndpoint;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionNotificationEndpointName projectRegionNotificationEndpointName = this;
            synchronized (projectRegionNotificationEndpointName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"notificationEndpoint", (Object)this.notificationEndpoint);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionNotificationEndpointName> newFactory() {
        return new ResourceNameFactory<ProjectRegionNotificationEndpointName>(){

            public ProjectRegionNotificationEndpointName parse(String formattedString) {
                return ProjectRegionNotificationEndpointName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionNotificationEndpointName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionNotificationEndpointName.parse: formattedString not in valid format");
        return ProjectRegionNotificationEndpointName.of((String)matchMap.get("notificationEndpoint"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"notificationEndpoint", this.notificationEndpoint, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionNotificationEndpointName) {
            ProjectRegionNotificationEndpointName that = (ProjectRegionNotificationEndpointName)o;
            return Objects.equals(this.notificationEndpoint, that.getNotificationEndpoint()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.notificationEndpoint, this.project, this.region);
    }

    public static class Builder {
        private String notificationEndpoint;
        private String project;
        private String region;

        public String getNotificationEndpoint() {
            return this.notificationEndpoint;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setNotificationEndpoint(String notificationEndpoint) {
            this.notificationEndpoint = notificationEndpoint;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionNotificationEndpointName projectRegionNotificationEndpointName) {
            this.notificationEndpoint = projectRegionNotificationEndpointName.notificationEndpoint;
            this.project = projectRegionNotificationEndpointName.project;
            this.region = projectRegionNotificationEndpointName.region;
        }

        public ProjectRegionNotificationEndpointName build() {
            return new ProjectRegionNotificationEndpointName(this);
        }
    }
}

