/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPacketMirroringsHttpRequest;
import com.google.cloud.compute.v1.DeletePacketMirroringHttpRequest;
import com.google.cloud.compute.v1.GetPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.InsertPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.ListPacketMirroringsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PacketMirroring;
import com.google.cloud.compute.v1.PacketMirroringAggregatedList;
import com.google.cloud.compute.v1.PacketMirroringList;
import com.google.cloud.compute.v1.PacketMirroringSettings;
import com.google.cloud.compute.v1.PacketMirroringsScopedList;
import com.google.cloud.compute.v1.PatchPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionPacketMirroringName;
import com.google.cloud.compute.v1.ProjectRegionPacketMirroringResourceName;
import com.google.cloud.compute.v1.TestIamPermissionsPacketMirroringHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.PacketMirroringStub;
import com.google.cloud.compute.v1.stub.PacketMirroringStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PacketMirroringClient
implements BackgroundResource {
    private final PacketMirroringSettings settings;
    private final PacketMirroringStub stub;

    public static final PacketMirroringClient create() throws IOException {
        return PacketMirroringClient.create(PacketMirroringSettings.newBuilder().build());
    }

    public static final PacketMirroringClient create(PacketMirroringSettings settings) throws IOException {
        return new PacketMirroringClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PacketMirroringClient create(PacketMirroringStub stub) {
        return new PacketMirroringClient(stub);
    }

    protected PacketMirroringClient(PacketMirroringSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PacketMirroringStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PacketMirroringClient(PacketMirroringStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PacketMirroringSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PacketMirroringStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListPacketMirroringsPagedResponse aggregatedListPacketMirrorings(Boolean includeAllScopes, ProjectName project) {
        AggregatedListPacketMirroringsHttpRequest request = AggregatedListPacketMirroringsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListPacketMirrorings(request);
    }

    @BetaApi
    public final AggregatedListPacketMirroringsPagedResponse aggregatedListPacketMirrorings(Boolean includeAllScopes, String project) {
        AggregatedListPacketMirroringsHttpRequest request = AggregatedListPacketMirroringsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListPacketMirrorings(request);
    }

    @BetaApi
    public final AggregatedListPacketMirroringsPagedResponse aggregatedListPacketMirrorings(AggregatedListPacketMirroringsHttpRequest request) {
        return (AggregatedListPacketMirroringsPagedResponse)((Object)this.aggregatedListPacketMirroringsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListPacketMirroringsHttpRequest, AggregatedListPacketMirroringsPagedResponse> aggregatedListPacketMirroringsPagedCallable() {
        return this.stub.aggregatedListPacketMirroringsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList> aggregatedListPacketMirroringsCallable() {
        return this.stub.aggregatedListPacketMirroringsCallable();
    }

    @BetaApi
    public final Operation deletePacketMirroring(ProjectRegionPacketMirroringName packetMirroring) {
        DeletePacketMirroringHttpRequest request = DeletePacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring == null ? null : packetMirroring.toString()).build();
        return this.deletePacketMirroring(request);
    }

    @BetaApi
    public final Operation deletePacketMirroring(String packetMirroring) {
        DeletePacketMirroringHttpRequest request = DeletePacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring).build();
        return this.deletePacketMirroring(request);
    }

    @BetaApi
    public final Operation deletePacketMirroring(DeletePacketMirroringHttpRequest request) {
        return (Operation)this.deletePacketMirroringCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeletePacketMirroringHttpRequest, Operation> deletePacketMirroringCallable() {
        return this.stub.deletePacketMirroringCallable();
    }

    @BetaApi
    public final PacketMirroring getPacketMirroring(ProjectRegionPacketMirroringName packetMirroring) {
        GetPacketMirroringHttpRequest request = GetPacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring == null ? null : packetMirroring.toString()).build();
        return this.getPacketMirroring(request);
    }

    @BetaApi
    public final PacketMirroring getPacketMirroring(String packetMirroring) {
        GetPacketMirroringHttpRequest request = GetPacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring).build();
        return this.getPacketMirroring(request);
    }

    @BetaApi
    public final PacketMirroring getPacketMirroring(GetPacketMirroringHttpRequest request) {
        return (PacketMirroring)this.getPacketMirroringCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetPacketMirroringHttpRequest, PacketMirroring> getPacketMirroringCallable() {
        return this.stub.getPacketMirroringCallable();
    }

    @BetaApi
    public final Operation insertPacketMirroring(ProjectRegionName region, PacketMirroring packetMirroringResource) {
        InsertPacketMirroringHttpRequest request = InsertPacketMirroringHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setPacketMirroringResource(packetMirroringResource).build();
        return this.insertPacketMirroring(request);
    }

    @BetaApi
    public final Operation insertPacketMirroring(String region, PacketMirroring packetMirroringResource) {
        InsertPacketMirroringHttpRequest request = InsertPacketMirroringHttpRequest.newBuilder().setRegion(region).setPacketMirroringResource(packetMirroringResource).build();
        return this.insertPacketMirroring(request);
    }

    @BetaApi
    public final Operation insertPacketMirroring(InsertPacketMirroringHttpRequest request) {
        return (Operation)this.insertPacketMirroringCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertPacketMirroringHttpRequest, Operation> insertPacketMirroringCallable() {
        return this.stub.insertPacketMirroringCallable();
    }

    @BetaApi
    public final ListPacketMirroringsPagedResponse listPacketMirrorings(ProjectRegionName region) {
        ListPacketMirroringsHttpRequest request = ListPacketMirroringsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listPacketMirrorings(request);
    }

    @BetaApi
    public final ListPacketMirroringsPagedResponse listPacketMirrorings(String region) {
        ListPacketMirroringsHttpRequest request = ListPacketMirroringsHttpRequest.newBuilder().setRegion(region).build();
        return this.listPacketMirrorings(request);
    }

    @BetaApi
    public final ListPacketMirroringsPagedResponse listPacketMirrorings(ListPacketMirroringsHttpRequest request) {
        return (ListPacketMirroringsPagedResponse)((Object)this.listPacketMirroringsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListPacketMirroringsHttpRequest, ListPacketMirroringsPagedResponse> listPacketMirroringsPagedCallable() {
        return this.stub.listPacketMirroringsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListPacketMirroringsHttpRequest, PacketMirroringList> listPacketMirroringsCallable() {
        return this.stub.listPacketMirroringsCallable();
    }

    @BetaApi
    public final Operation patchPacketMirroring(ProjectRegionPacketMirroringName packetMirroring, PacketMirroring packetMirroringResource, List<String> fieldMask) {
        PatchPacketMirroringHttpRequest request = PatchPacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring == null ? null : packetMirroring.toString()).setPacketMirroringResource(packetMirroringResource).addAllFieldMask(fieldMask).build();
        return this.patchPacketMirroring(request);
    }

    @BetaApi
    public final Operation patchPacketMirroring(String packetMirroring, PacketMirroring packetMirroringResource, List<String> fieldMask) {
        PatchPacketMirroringHttpRequest request = PatchPacketMirroringHttpRequest.newBuilder().setPacketMirroring(packetMirroring).setPacketMirroringResource(packetMirroringResource).addAllFieldMask(fieldMask).build();
        return this.patchPacketMirroring(request);
    }

    @BetaApi
    public final Operation patchPacketMirroring(PatchPacketMirroringHttpRequest request) {
        return (Operation)this.patchPacketMirroringCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchPacketMirroringHttpRequest, Operation> patchPacketMirroringCallable() {
        return this.stub.patchPacketMirroringCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsPacketMirroring(ProjectRegionPacketMirroringResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsPacketMirroringHttpRequest request = TestIamPermissionsPacketMirroringHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsPacketMirroring(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsPacketMirroring(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsPacketMirroringHttpRequest request = TestIamPermissionsPacketMirroringHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsPacketMirroring(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsPacketMirroring(TestIamPermissionsPacketMirroringHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsPacketMirroringCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsPacketMirroringHttpRequest, TestPermissionsResponse> testIamPermissionsPacketMirroringCallable() {
        return this.stub.testIamPermissionsPacketMirroringCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPacketMirroringsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring, ListPacketMirroringsPage, ListPacketMirroringsFixedSizeCollection> {
        private ListPacketMirroringsFixedSizeCollection(List<ListPacketMirroringsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPacketMirroringsFixedSizeCollection createEmptyCollection() {
            return new ListPacketMirroringsFixedSizeCollection(null, 0);
        }

        protected ListPacketMirroringsFixedSizeCollection createCollection(List<ListPacketMirroringsPage> pages, int collectionSize) {
            return new ListPacketMirroringsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPacketMirroringsPage
    extends AbstractPage<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring, ListPacketMirroringsPage> {
        private ListPacketMirroringsPage(PageContext<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring> context, PacketMirroringList response) {
            super(context, (Object)response);
        }

        private static ListPacketMirroringsPage createEmptyPage() {
            return new ListPacketMirroringsPage(null, null);
        }

        protected ListPacketMirroringsPage createPage(PageContext<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring> context, PacketMirroringList response) {
            return new ListPacketMirroringsPage(context, response);
        }

        public ApiFuture<ListPacketMirroringsPage> createPageAsync(PageContext<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring> context, ApiFuture<PacketMirroringList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPacketMirroringsPagedResponse
    extends AbstractPagedListResponse<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring, ListPacketMirroringsPage, ListPacketMirroringsFixedSizeCollection> {
        public static ApiFuture<ListPacketMirroringsPagedResponse> createAsync(PageContext<ListPacketMirroringsHttpRequest, PacketMirroringList, PacketMirroring> context, ApiFuture<PacketMirroringList> futureResponse) {
            ApiFuture<ListPacketMirroringsPage> futurePage = ListPacketMirroringsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPacketMirroringsPage, ListPacketMirroringsPagedResponse>(){

                public ListPacketMirroringsPagedResponse apply(ListPacketMirroringsPage input) {
                    return new ListPacketMirroringsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPacketMirroringsPagedResponse(ListPacketMirroringsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPacketMirroringsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListPacketMirroringsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList, AggregatedListPacketMirroringsPage, AggregatedListPacketMirroringsFixedSizeCollection> {
        private AggregatedListPacketMirroringsFixedSizeCollection(List<AggregatedListPacketMirroringsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListPacketMirroringsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListPacketMirroringsFixedSizeCollection(null, 0);
        }

        protected AggregatedListPacketMirroringsFixedSizeCollection createCollection(List<AggregatedListPacketMirroringsPage> pages, int collectionSize) {
            return new AggregatedListPacketMirroringsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPacketMirroringsPage
    extends AbstractPage<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList, AggregatedListPacketMirroringsPage> {
        private AggregatedListPacketMirroringsPage(PageContext<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList> context, PacketMirroringAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPacketMirroringsPage createEmptyPage() {
            return new AggregatedListPacketMirroringsPage(null, null);
        }

        protected AggregatedListPacketMirroringsPage createPage(PageContext<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList> context, PacketMirroringAggregatedList response) {
            return new AggregatedListPacketMirroringsPage(context, response);
        }

        public ApiFuture<AggregatedListPacketMirroringsPage> createPageAsync(PageContext<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList> context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPacketMirroringsPagedResponse
    extends AbstractPagedListResponse<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList, AggregatedListPacketMirroringsPage, AggregatedListPacketMirroringsFixedSizeCollection> {
        public static ApiFuture<AggregatedListPacketMirroringsPagedResponse> createAsync(PageContext<AggregatedListPacketMirroringsHttpRequest, PacketMirroringAggregatedList, PacketMirroringsScopedList> context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPacketMirroringsPage> futurePage = AggregatedListPacketMirroringsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPacketMirroringsPage, AggregatedListPacketMirroringsPagedResponse>(){

                public AggregatedListPacketMirroringsPagedResponse apply(AggregatedListPacketMirroringsPage input) {
                    return new AggregatedListPacketMirroringsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPacketMirroringsPagedResponse(AggregatedListPacketMirroringsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListPacketMirroringsFixedSizeCollection.createEmptyCollection());
        }
    }
}

