/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpHeaderMatch;
import com.google.cloud.compute.v1.HttpQueryParameterMatch;
import com.google.cloud.compute.v1.MetadataFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpRouteRuleMatch
implements ApiMessage {
    private final String fullPathMatch;
    private final List<HttpHeaderMatch> headerMatches;
    private final Boolean ignoreCase;
    private final List<MetadataFilter> metadataFilters;
    private final String prefixMatch;
    private final List<HttpQueryParameterMatch> queryParameterMatches;
    private final String regexMatch;
    private static final HttpRouteRuleMatch DEFAULT_INSTANCE = new HttpRouteRuleMatch();

    private HttpRouteRuleMatch() {
        this.fullPathMatch = null;
        this.headerMatches = null;
        this.ignoreCase = null;
        this.metadataFilters = null;
        this.prefixMatch = null;
        this.queryParameterMatches = null;
        this.regexMatch = null;
    }

    private HttpRouteRuleMatch(String fullPathMatch, List<HttpHeaderMatch> headerMatches, Boolean ignoreCase, List<MetadataFilter> metadataFilters, String prefixMatch, List<HttpQueryParameterMatch> queryParameterMatches, String regexMatch) {
        this.fullPathMatch = fullPathMatch;
        this.headerMatches = headerMatches;
        this.ignoreCase = ignoreCase;
        this.metadataFilters = metadataFilters;
        this.prefixMatch = prefixMatch;
        this.queryParameterMatches = queryParameterMatches;
        this.regexMatch = regexMatch;
    }

    public Object getFieldValue(String fieldName) {
        if ("fullPathMatch".equals(fieldName)) {
            return this.fullPathMatch;
        }
        if ("headerMatches".equals(fieldName)) {
            return this.headerMatches;
        }
        if ("ignoreCase".equals(fieldName)) {
            return this.ignoreCase;
        }
        if ("metadataFilters".equals(fieldName)) {
            return this.metadataFilters;
        }
        if ("prefixMatch".equals(fieldName)) {
            return this.prefixMatch;
        }
        if ("queryParameterMatches".equals(fieldName)) {
            return this.queryParameterMatches;
        }
        if ("regexMatch".equals(fieldName)) {
            return this.regexMatch;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFullPathMatch() {
        return this.fullPathMatch;
    }

    public List<HttpHeaderMatch> getHeaderMatchesList() {
        return this.headerMatches;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public List<MetadataFilter> getMetadataFiltersList() {
        return this.metadataFilters;
    }

    public String getPrefixMatch() {
        return this.prefixMatch;
    }

    public List<HttpQueryParameterMatch> getQueryParameterMatchesList() {
        return this.queryParameterMatches;
    }

    public String getRegexMatch() {
        return this.regexMatch;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpRouteRuleMatch prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpRouteRuleMatch getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpRouteRuleMatch{fullPathMatch=" + this.fullPathMatch + ", headerMatches=" + this.headerMatches + ", ignoreCase=" + this.ignoreCase + ", metadataFilters=" + this.metadataFilters + ", prefixMatch=" + this.prefixMatch + ", queryParameterMatches=" + this.queryParameterMatches + ", regexMatch=" + this.regexMatch + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRouteRuleMatch) {
            HttpRouteRuleMatch that = (HttpRouteRuleMatch)o;
            return Objects.equals(this.fullPathMatch, that.getFullPathMatch()) && Objects.equals(this.headerMatches, that.getHeaderMatchesList()) && Objects.equals(this.ignoreCase, that.getIgnoreCase()) && Objects.equals(this.metadataFilters, that.getMetadataFiltersList()) && Objects.equals(this.prefixMatch, that.getPrefixMatch()) && Objects.equals(this.queryParameterMatches, that.getQueryParameterMatchesList()) && Objects.equals(this.regexMatch, that.getRegexMatch());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fullPathMatch, this.headerMatches, this.ignoreCase, this.metadataFilters, this.prefixMatch, this.queryParameterMatches, this.regexMatch);
    }

    public static class Builder {
        private String fullPathMatch;
        private List<HttpHeaderMatch> headerMatches;
        private Boolean ignoreCase;
        private List<MetadataFilter> metadataFilters;
        private String prefixMatch;
        private List<HttpQueryParameterMatch> queryParameterMatches;
        private String regexMatch;

        Builder() {
        }

        public Builder mergeFrom(HttpRouteRuleMatch other) {
            if (other == HttpRouteRuleMatch.getDefaultInstance()) {
                return this;
            }
            if (other.getFullPathMatch() != null) {
                this.fullPathMatch = other.fullPathMatch;
            }
            if (other.getHeaderMatchesList() != null) {
                this.headerMatches = other.headerMatches;
            }
            if (other.getIgnoreCase() != null) {
                this.ignoreCase = other.ignoreCase;
            }
            if (other.getMetadataFiltersList() != null) {
                this.metadataFilters = other.metadataFilters;
            }
            if (other.getPrefixMatch() != null) {
                this.prefixMatch = other.prefixMatch;
            }
            if (other.getQueryParameterMatchesList() != null) {
                this.queryParameterMatches = other.queryParameterMatches;
            }
            if (other.getRegexMatch() != null) {
                this.regexMatch = other.regexMatch;
            }
            return this;
        }

        Builder(HttpRouteRuleMatch source) {
            this.fullPathMatch = source.fullPathMatch;
            this.headerMatches = source.headerMatches;
            this.ignoreCase = source.ignoreCase;
            this.metadataFilters = source.metadataFilters;
            this.prefixMatch = source.prefixMatch;
            this.queryParameterMatches = source.queryParameterMatches;
            this.regexMatch = source.regexMatch;
        }

        public String getFullPathMatch() {
            return this.fullPathMatch;
        }

        public Builder setFullPathMatch(String fullPathMatch) {
            this.fullPathMatch = fullPathMatch;
            return this;
        }

        public List<HttpHeaderMatch> getHeaderMatchesList() {
            return this.headerMatches;
        }

        public Builder addAllHeaderMatches(List<HttpHeaderMatch> headerMatches) {
            if (this.headerMatches == null) {
                this.headerMatches = new LinkedList<HttpHeaderMatch>();
            }
            this.headerMatches.addAll(headerMatches);
            return this;
        }

        public Builder addHeaderMatches(HttpHeaderMatch headerMatches) {
            if (this.headerMatches == null) {
                this.headerMatches = new LinkedList<HttpHeaderMatch>();
            }
            this.headerMatches.add(headerMatches);
            return this;
        }

        public Boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public Builder setIgnoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public List<MetadataFilter> getMetadataFiltersList() {
            return this.metadataFilters;
        }

        public Builder addAllMetadataFilters(List<MetadataFilter> metadataFilters) {
            if (this.metadataFilters == null) {
                this.metadataFilters = new LinkedList<MetadataFilter>();
            }
            this.metadataFilters.addAll(metadataFilters);
            return this;
        }

        public Builder addMetadataFilters(MetadataFilter metadataFilters) {
            if (this.metadataFilters == null) {
                this.metadataFilters = new LinkedList<MetadataFilter>();
            }
            this.metadataFilters.add(metadataFilters);
            return this;
        }

        public String getPrefixMatch() {
            return this.prefixMatch;
        }

        public Builder setPrefixMatch(String prefixMatch) {
            this.prefixMatch = prefixMatch;
            return this;
        }

        public List<HttpQueryParameterMatch> getQueryParameterMatchesList() {
            return this.queryParameterMatches;
        }

        public Builder addAllQueryParameterMatches(List<HttpQueryParameterMatch> queryParameterMatches) {
            if (this.queryParameterMatches == null) {
                this.queryParameterMatches = new LinkedList<HttpQueryParameterMatch>();
            }
            this.queryParameterMatches.addAll(queryParameterMatches);
            return this;
        }

        public Builder addQueryParameterMatches(HttpQueryParameterMatch queryParameterMatches) {
            if (this.queryParameterMatches == null) {
                this.queryParameterMatches = new LinkedList<HttpQueryParameterMatch>();
            }
            this.queryParameterMatches.add(queryParameterMatches);
            return this;
        }

        public String getRegexMatch() {
            return this.regexMatch;
        }

        public Builder setRegexMatch(String regexMatch) {
            this.regexMatch = regexMatch;
            return this;
        }

        public HttpRouteRuleMatch build() {
            return new HttpRouteRuleMatch(this.fullPathMatch, this.headerMatches, this.ignoreCase, this.metadataFilters, this.prefixMatch, this.queryParameterMatches, this.regexMatch);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFullPathMatch(this.fullPathMatch);
            newBuilder.addAllHeaderMatches(this.headerMatches);
            newBuilder.setIgnoreCase(this.ignoreCase);
            newBuilder.addAllMetadataFilters(this.metadataFilters);
            newBuilder.setPrefixMatch(this.prefixMatch);
            newBuilder.addAllQueryParameterMatches(this.queryParameterMatches);
            newBuilder.setRegexMatch(this.regexMatch);
            return newBuilder;
        }
    }
}

