/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpHeaderAction;
import com.google.cloud.compute.v1.HttpRedirectAction;
import com.google.cloud.compute.v1.HttpRouteAction;
import com.google.cloud.compute.v1.HttpRouteRuleMatch;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpRouteRule
implements ApiMessage {
    private final String description;
    private final HttpHeaderAction headerAction;
    private final List<HttpRouteRuleMatch> matchRules;
    private final Integer priority;
    private final HttpRouteAction routeAction;
    private final String service;
    private final HttpRedirectAction urlRedirect;
    private static final HttpRouteRule DEFAULT_INSTANCE = new HttpRouteRule();

    private HttpRouteRule() {
        this.description = null;
        this.headerAction = null;
        this.matchRules = null;
        this.priority = null;
        this.routeAction = null;
        this.service = null;
        this.urlRedirect = null;
    }

    private HttpRouteRule(String description, HttpHeaderAction headerAction, List<HttpRouteRuleMatch> matchRules, Integer priority, HttpRouteAction routeAction, String service, HttpRedirectAction urlRedirect) {
        this.description = description;
        this.headerAction = headerAction;
        this.matchRules = matchRules;
        this.priority = priority;
        this.routeAction = routeAction;
        this.service = service;
        this.urlRedirect = urlRedirect;
    }

    public Object getFieldValue(String fieldName) {
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("headerAction".equals(fieldName)) {
            return this.headerAction;
        }
        if ("matchRules".equals(fieldName)) {
            return this.matchRules;
        }
        if ("priority".equals(fieldName)) {
            return this.priority;
        }
        if ("routeAction".equals(fieldName)) {
            return this.routeAction;
        }
        if ("service".equals(fieldName)) {
            return this.service;
        }
        if ("urlRedirect".equals(fieldName)) {
            return this.urlRedirect;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public HttpHeaderAction getHeaderAction() {
        return this.headerAction;
    }

    public List<HttpRouteRuleMatch> getMatchRulesList() {
        return this.matchRules;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public HttpRouteAction getRouteAction() {
        return this.routeAction;
    }

    public String getService() {
        return this.service;
    }

    public HttpRedirectAction getUrlRedirect() {
        return this.urlRedirect;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpRouteRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpRouteRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpRouteRule{description=" + this.description + ", headerAction=" + this.headerAction + ", matchRules=" + this.matchRules + ", priority=" + this.priority + ", routeAction=" + this.routeAction + ", service=" + this.service + ", urlRedirect=" + this.urlRedirect + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRouteRule) {
            HttpRouteRule that = (HttpRouteRule)o;
            return Objects.equals(this.description, that.getDescription()) && Objects.equals(this.headerAction, that.getHeaderAction()) && Objects.equals(this.matchRules, that.getMatchRulesList()) && Objects.equals(this.priority, that.getPriority()) && Objects.equals(this.routeAction, that.getRouteAction()) && Objects.equals(this.service, that.getService()) && Objects.equals(this.urlRedirect, that.getUrlRedirect());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.headerAction, this.matchRules, this.priority, this.routeAction, this.service, this.urlRedirect);
    }

    public static class Builder {
        private String description;
        private HttpHeaderAction headerAction;
        private List<HttpRouteRuleMatch> matchRules;
        private Integer priority;
        private HttpRouteAction routeAction;
        private String service;
        private HttpRedirectAction urlRedirect;

        Builder() {
        }

        public Builder mergeFrom(HttpRouteRule other) {
            if (other == HttpRouteRule.getDefaultInstance()) {
                return this;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getHeaderAction() != null) {
                this.headerAction = other.headerAction;
            }
            if (other.getMatchRulesList() != null) {
                this.matchRules = other.matchRules;
            }
            if (other.getPriority() != null) {
                this.priority = other.priority;
            }
            if (other.getRouteAction() != null) {
                this.routeAction = other.routeAction;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            if (other.getUrlRedirect() != null) {
                this.urlRedirect = other.urlRedirect;
            }
            return this;
        }

        Builder(HttpRouteRule source) {
            this.description = source.description;
            this.headerAction = source.headerAction;
            this.matchRules = source.matchRules;
            this.priority = source.priority;
            this.routeAction = source.routeAction;
            this.service = source.service;
            this.urlRedirect = source.urlRedirect;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public HttpHeaderAction getHeaderAction() {
            return this.headerAction;
        }

        public Builder setHeaderAction(HttpHeaderAction headerAction) {
            this.headerAction = headerAction;
            return this;
        }

        public List<HttpRouteRuleMatch> getMatchRulesList() {
            return this.matchRules;
        }

        public Builder addAllMatchRules(List<HttpRouteRuleMatch> matchRules) {
            if (this.matchRules == null) {
                this.matchRules = new LinkedList<HttpRouteRuleMatch>();
            }
            this.matchRules.addAll(matchRules);
            return this;
        }

        public Builder addMatchRules(HttpRouteRuleMatch matchRules) {
            if (this.matchRules == null) {
                this.matchRules = new LinkedList<HttpRouteRuleMatch>();
            }
            this.matchRules.add(matchRules);
            return this;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public HttpRouteAction getRouteAction() {
            return this.routeAction;
        }

        public Builder setRouteAction(HttpRouteAction routeAction) {
            this.routeAction = routeAction;
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public HttpRedirectAction getUrlRedirect() {
            return this.urlRedirect;
        }

        public Builder setUrlRedirect(HttpRedirectAction urlRedirect) {
            this.urlRedirect = urlRedirect;
            return this;
        }

        public HttpRouteRule build() {
            return new HttpRouteRule(this.description, this.headerAction, this.matchRules, this.priority, this.routeAction, this.service, this.urlRedirect);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDescription(this.description);
            newBuilder.setHeaderAction(this.headerAction);
            newBuilder.addAllMatchRules(this.matchRules);
            newBuilder.setPriority(this.priority);
            newBuilder.setRouteAction(this.routeAction);
            newBuilder.setService(this.service);
            newBuilder.setUrlRedirect(this.urlRedirect);
            return newBuilder;
        }
    }
}

