/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.AggregatedListBackendServicesHttpRequest;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceAggregatedList;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServiceSettings;
import com.google.cloud.compute.v1.BackendServicesScopedList;
import com.google.cloud.compute.v1.DeleteBackendServiceHttpRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetHealthBackendServiceHttpRequest;
import com.google.cloud.compute.v1.InsertBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ListBackendServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalBackendServiceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetSecurityPolicyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.SignedUrlKey;
import com.google.cloud.compute.v1.UpdateBackendServiceHttpRequest;
import com.google.cloud.compute.v1.stub.BackendServiceStub;
import com.google.cloud.compute.v1.stub.BackendServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BackendServiceClient
implements BackgroundResource {
    private final BackendServiceSettings settings;
    private final BackendServiceStub stub;

    public static final BackendServiceClient create() throws IOException {
        return BackendServiceClient.create(BackendServiceSettings.newBuilder().build());
    }

    public static final BackendServiceClient create(BackendServiceSettings settings) throws IOException {
        return new BackendServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BackendServiceClient create(BackendServiceStub stub) {
        return new BackendServiceClient(stub);
    }

    protected BackendServiceClient(BackendServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackendServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BackendServiceClient(BackendServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BackendServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendServiceStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addSignedUrlKeyBackendService(ProjectGlobalBackendServiceName backendService, SignedUrlKey signedUrlKeyResource) {
        AddSignedUrlKeyBackendServiceHttpRequest request = AddSignedUrlKeyBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setSignedUrlKeyResource(signedUrlKeyResource).build();
        return this.addSignedUrlKeyBackendService(request);
    }

    @BetaApi
    public final Operation addSignedUrlKeyBackendService(String backendService, SignedUrlKey signedUrlKeyResource) {
        AddSignedUrlKeyBackendServiceHttpRequest request = AddSignedUrlKeyBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setSignedUrlKeyResource(signedUrlKeyResource).build();
        return this.addSignedUrlKeyBackendService(request);
    }

    @BetaApi
    public final Operation addSignedUrlKeyBackendService(AddSignedUrlKeyBackendServiceHttpRequest request) {
        return (Operation)this.addSignedUrlKeyBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddSignedUrlKeyBackendServiceHttpRequest, Operation> addSignedUrlKeyBackendServiceCallable() {
        return this.stub.addSignedUrlKeyBackendServiceCallable();
    }

    @BetaApi
    public final AggregatedListBackendServicesPagedResponse aggregatedListBackendServices(Boolean includeAllScopes, ProjectName project) {
        AggregatedListBackendServicesHttpRequest request = AggregatedListBackendServicesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListBackendServices(request);
    }

    @BetaApi
    public final AggregatedListBackendServicesPagedResponse aggregatedListBackendServices(Boolean includeAllScopes, String project) {
        AggregatedListBackendServicesHttpRequest request = AggregatedListBackendServicesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListBackendServices(request);
    }

    @BetaApi
    public final AggregatedListBackendServicesPagedResponse aggregatedListBackendServices(AggregatedListBackendServicesHttpRequest request) {
        return (AggregatedListBackendServicesPagedResponse)((Object)this.aggregatedListBackendServicesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListBackendServicesHttpRequest, AggregatedListBackendServicesPagedResponse> aggregatedListBackendServicesPagedCallable() {
        return this.stub.aggregatedListBackendServicesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList> aggregatedListBackendServicesCallable() {
        return this.stub.aggregatedListBackendServicesCallable();
    }

    @BetaApi
    public final Operation deleteBackendService(ProjectGlobalBackendServiceName backendService) {
        DeleteBackendServiceHttpRequest request = DeleteBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).build();
        return this.deleteBackendService(request);
    }

    @BetaApi
    public final Operation deleteBackendService(String backendService) {
        DeleteBackendServiceHttpRequest request = DeleteBackendServiceHttpRequest.newBuilder().setBackendService(backendService).build();
        return this.deleteBackendService(request);
    }

    @BetaApi
    public final Operation deleteBackendService(DeleteBackendServiceHttpRequest request) {
        return (Operation)this.deleteBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteBackendServiceHttpRequest, Operation> deleteBackendServiceCallable() {
        return this.stub.deleteBackendServiceCallable();
    }

    @BetaApi
    public final Operation deleteSignedUrlKeyBackendService(ProjectGlobalBackendServiceName backendService, String keyName) {
        DeleteSignedUrlKeyBackendServiceHttpRequest request = DeleteSignedUrlKeyBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setKeyName(keyName).build();
        return this.deleteSignedUrlKeyBackendService(request);
    }

    @BetaApi
    public final Operation deleteSignedUrlKeyBackendService(String backendService, String keyName) {
        DeleteSignedUrlKeyBackendServiceHttpRequest request = DeleteSignedUrlKeyBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setKeyName(keyName).build();
        return this.deleteSignedUrlKeyBackendService(request);
    }

    @BetaApi
    public final Operation deleteSignedUrlKeyBackendService(DeleteSignedUrlKeyBackendServiceHttpRequest request) {
        return (Operation)this.deleteSignedUrlKeyBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSignedUrlKeyBackendServiceHttpRequest, Operation> deleteSignedUrlKeyBackendServiceCallable() {
        return this.stub.deleteSignedUrlKeyBackendServiceCallable();
    }

    @BetaApi
    public final BackendService getBackendService(ProjectGlobalBackendServiceName backendService) {
        GetBackendServiceHttpRequest request = GetBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).build();
        return this.getBackendService(request);
    }

    @BetaApi
    public final BackendService getBackendService(String backendService) {
        GetBackendServiceHttpRequest request = GetBackendServiceHttpRequest.newBuilder().setBackendService(backendService).build();
        return this.getBackendService(request);
    }

    @BetaApi
    public final BackendService getBackendService(GetBackendServiceHttpRequest request) {
        return (BackendService)this.getBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetBackendServiceHttpRequest, BackendService> getBackendServiceCallable() {
        return this.stub.getBackendServiceCallable();
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthBackendService(ProjectGlobalBackendServiceName backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthBackendServiceHttpRequest request = GetHealthBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealthBackendService(request);
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthBackendService(String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthBackendServiceHttpRequest request = GetHealthBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealthBackendService(request);
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthBackendService(GetHealthBackendServiceHttpRequest request) {
        return (BackendServiceGroupHealth)this.getHealthBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHealthBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthBackendServiceCallable() {
        return this.stub.getHealthBackendServiceCallable();
    }

    @BetaApi
    public final Operation insertBackendService(ProjectName project, BackendService backendServiceResource) {
        InsertBackendServiceHttpRequest request = InsertBackendServiceHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setBackendServiceResource(backendServiceResource).build();
        return this.insertBackendService(request);
    }

    @BetaApi
    public final Operation insertBackendService(String project, BackendService backendServiceResource) {
        InsertBackendServiceHttpRequest request = InsertBackendServiceHttpRequest.newBuilder().setProject(project).setBackendServiceResource(backendServiceResource).build();
        return this.insertBackendService(request);
    }

    @BetaApi
    public final Operation insertBackendService(InsertBackendServiceHttpRequest request) {
        return (Operation)this.insertBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertBackendServiceHttpRequest, Operation> insertBackendServiceCallable() {
        return this.stub.insertBackendServiceCallable();
    }

    @BetaApi
    public final ListBackendServicesPagedResponse listBackendServices(ProjectName project) {
        ListBackendServicesHttpRequest request = ListBackendServicesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listBackendServices(request);
    }

    @BetaApi
    public final ListBackendServicesPagedResponse listBackendServices(String project) {
        ListBackendServicesHttpRequest request = ListBackendServicesHttpRequest.newBuilder().setProject(project).build();
        return this.listBackendServices(request);
    }

    @BetaApi
    public final ListBackendServicesPagedResponse listBackendServices(ListBackendServicesHttpRequest request) {
        return (ListBackendServicesPagedResponse)((Object)this.listBackendServicesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListBackendServicesHttpRequest, ListBackendServicesPagedResponse> listBackendServicesPagedCallable() {
        return this.stub.listBackendServicesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListBackendServicesHttpRequest, BackendServiceList> listBackendServicesCallable() {
        return this.stub.listBackendServicesCallable();
    }

    @BetaApi
    public final Operation patchBackendService(ProjectGlobalBackendServiceName backendService, BackendService backendServiceResource, List<String> fieldMask) {
        PatchBackendServiceHttpRequest request = PatchBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setBackendServiceResource(backendServiceResource).addAllFieldMask(fieldMask).build();
        return this.patchBackendService(request);
    }

    @BetaApi
    public final Operation patchBackendService(String backendService, BackendService backendServiceResource, List<String> fieldMask) {
        PatchBackendServiceHttpRequest request = PatchBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setBackendServiceResource(backendServiceResource).addAllFieldMask(fieldMask).build();
        return this.patchBackendService(request);
    }

    @BetaApi
    public final Operation patchBackendService(PatchBackendServiceHttpRequest request) {
        return (Operation)this.patchBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchBackendServiceHttpRequest, Operation> patchBackendServiceCallable() {
        return this.stub.patchBackendServiceCallable();
    }

    @BetaApi
    public final Operation setSecurityPolicyBackendService(ProjectGlobalBackendServiceName backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyBackendServiceHttpRequest request = SetSecurityPolicyBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicyBackendService(request);
    }

    @BetaApi
    public final Operation setSecurityPolicyBackendService(String backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyBackendServiceHttpRequest request = SetSecurityPolicyBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicyBackendService(request);
    }

    @BetaApi
    public final Operation setSecurityPolicyBackendService(SetSecurityPolicyBackendServiceHttpRequest request) {
        return (Operation)this.setSecurityPolicyBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSecurityPolicyBackendServiceHttpRequest, Operation> setSecurityPolicyBackendServiceCallable() {
        return this.stub.setSecurityPolicyBackendServiceCallable();
    }

    @BetaApi
    public final Operation updateBackendService(ProjectGlobalBackendServiceName backendService, BackendService backendServiceResource, List<String> fieldMask) {
        UpdateBackendServiceHttpRequest request = UpdateBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setBackendServiceResource(backendServiceResource).addAllFieldMask(fieldMask).build();
        return this.updateBackendService(request);
    }

    @BetaApi
    public final Operation updateBackendService(String backendService, BackendService backendServiceResource, List<String> fieldMask) {
        UpdateBackendServiceHttpRequest request = UpdateBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setBackendServiceResource(backendServiceResource).addAllFieldMask(fieldMask).build();
        return this.updateBackendService(request);
    }

    @BetaApi
    public final Operation updateBackendService(UpdateBackendServiceHttpRequest request) {
        return (Operation)this.updateBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateBackendServiceHttpRequest, Operation> updateBackendServiceCallable() {
        return this.stub.updateBackendServiceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBackendServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackendServicesHttpRequest, BackendServiceList, BackendService, ListBackendServicesPage, ListBackendServicesFixedSizeCollection> {
        private ListBackendServicesFixedSizeCollection(List<ListBackendServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackendServicesFixedSizeCollection createEmptyCollection() {
            return new ListBackendServicesFixedSizeCollection(null, 0);
        }

        protected ListBackendServicesFixedSizeCollection createCollection(List<ListBackendServicesPage> pages, int collectionSize) {
            return new ListBackendServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackendServicesPage
    extends AbstractPage<ListBackendServicesHttpRequest, BackendServiceList, BackendService, ListBackendServicesPage> {
        private ListBackendServicesPage(PageContext<ListBackendServicesHttpRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListBackendServicesPage createEmptyPage() {
            return new ListBackendServicesPage(null, null);
        }

        protected ListBackendServicesPage createPage(PageContext<ListBackendServicesHttpRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListBackendServicesPage(context, response);
        }

        public ApiFuture<ListBackendServicesPage> createPageAsync(PageContext<ListBackendServicesHttpRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackendServicesPagedResponse
    extends AbstractPagedListResponse<ListBackendServicesHttpRequest, BackendServiceList, BackendService, ListBackendServicesPage, ListBackendServicesFixedSizeCollection> {
        public static ApiFuture<ListBackendServicesPagedResponse> createAsync(PageContext<ListBackendServicesHttpRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListBackendServicesPage> futurePage = ListBackendServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListBackendServicesPage, ListBackendServicesPagedResponse>(){

                public ListBackendServicesPagedResponse apply(ListBackendServicesPage input) {
                    return new ListBackendServicesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListBackendServicesPagedResponse(ListBackendServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackendServicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListBackendServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList, AggregatedListBackendServicesPage, AggregatedListBackendServicesFixedSizeCollection> {
        private AggregatedListBackendServicesFixedSizeCollection(List<AggregatedListBackendServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListBackendServicesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListBackendServicesFixedSizeCollection(null, 0);
        }

        protected AggregatedListBackendServicesFixedSizeCollection createCollection(List<AggregatedListBackendServicesPage> pages, int collectionSize) {
            return new AggregatedListBackendServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListBackendServicesPage
    extends AbstractPage<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList, AggregatedListBackendServicesPage> {
        private AggregatedListBackendServicesPage(PageContext<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList> context, BackendServiceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListBackendServicesPage createEmptyPage() {
            return new AggregatedListBackendServicesPage(null, null);
        }

        protected AggregatedListBackendServicesPage createPage(PageContext<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList> context, BackendServiceAggregatedList response) {
            return new AggregatedListBackendServicesPage(context, response);
        }

        public ApiFuture<AggregatedListBackendServicesPage> createPageAsync(PageContext<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListBackendServicesPagedResponse
    extends AbstractPagedListResponse<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList, AggregatedListBackendServicesPage, AggregatedListBackendServicesFixedSizeCollection> {
        public static ApiFuture<AggregatedListBackendServicesPagedResponse> createAsync(PageContext<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListBackendServicesPage> futurePage = AggregatedListBackendServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListBackendServicesPage, AggregatedListBackendServicesPagedResponse>(){

                public AggregatedListBackendServicesPagedResponse apply(AggregatedListBackendServicesPage input) {
                    return new AggregatedListBackendServicesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListBackendServicesPagedResponse(AggregatedListBackendServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListBackendServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

