/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteFirewallHttpRequest;
import com.google.cloud.compute.v1.Firewall;
import com.google.cloud.compute.v1.FirewallClient;
import com.google.cloud.compute.v1.FirewallList;
import com.google.cloud.compute.v1.GetFirewallHttpRequest;
import com.google.cloud.compute.v1.InsertFirewallHttpRequest;
import com.google.cloud.compute.v1.ListFirewallsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalFirewallName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateFirewallHttpRequest;
import com.google.cloud.compute.v1.stub.FirewallStub;
import com.google.cloud.compute.v1.stub.FirewallStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonFirewallCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonFirewallStub
extends FirewallStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteFirewallHttpRequest, Operation> deleteFirewallMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls/{firewall}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalFirewallName.newFactory()).setResourceNameField("firewall").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetFirewallHttpRequest, Firewall> getFirewallMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls/{firewall}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalFirewallName.newFactory()).setResourceNameField("firewall").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Firewall.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertFirewallHttpRequest, Operation> insertFirewallMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListFirewallsHttpRequest, FirewallList> listFirewallsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)FirewallList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchFirewallHttpRequest, Operation> patchFirewallMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls/{firewall}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalFirewallName.newFactory()).setResourceNameField("firewall").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateFirewallHttpRequest, Operation> updateFirewallMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.firewalls.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/firewalls/{firewall}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalFirewallName.newFactory()).setResourceNameField("firewall").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteFirewallHttpRequest, Operation> deleteFirewallCallable;
    private final UnaryCallable<GetFirewallHttpRequest, Firewall> getFirewallCallable;
    private final UnaryCallable<InsertFirewallHttpRequest, Operation> insertFirewallCallable;
    private final UnaryCallable<ListFirewallsHttpRequest, FirewallList> listFirewallsCallable;
    private final UnaryCallable<ListFirewallsHttpRequest, FirewallClient.ListFirewallsPagedResponse> listFirewallsPagedCallable;
    private final UnaryCallable<PatchFirewallHttpRequest, Operation> patchFirewallCallable;
    private final UnaryCallable<UpdateFirewallHttpRequest, Operation> updateFirewallCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFirewallStub create(FirewallStubSettings settings) throws IOException {
        return new HttpJsonFirewallStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonFirewallStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFirewallStub(FirewallStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonFirewallStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFirewallStub(FirewallStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFirewallStub(FirewallStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFirewallCallableFactory());
    }

    protected HttpJsonFirewallStub(FirewallStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteFirewallTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFirewallMethodDescriptor).build();
        HttpJsonCallSettings getFirewallTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFirewallMethodDescriptor).build();
        HttpJsonCallSettings insertFirewallTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertFirewallMethodDescriptor).build();
        HttpJsonCallSettings listFirewallsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFirewallsMethodDescriptor).build();
        HttpJsonCallSettings patchFirewallTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchFirewallMethodDescriptor).build();
        HttpJsonCallSettings updateFirewallTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFirewallMethodDescriptor).build();
        this.deleteFirewallCallable = callableFactory.createUnaryCallable(deleteFirewallTransportSettings, settings.deleteFirewallSettings(), clientContext);
        this.getFirewallCallable = callableFactory.createUnaryCallable(getFirewallTransportSettings, settings.getFirewallSettings(), clientContext);
        this.insertFirewallCallable = callableFactory.createUnaryCallable(insertFirewallTransportSettings, settings.insertFirewallSettings(), clientContext);
        this.listFirewallsCallable = callableFactory.createUnaryCallable(listFirewallsTransportSettings, settings.listFirewallsSettings(), clientContext);
        this.listFirewallsPagedCallable = callableFactory.createPagedCallable(listFirewallsTransportSettings, settings.listFirewallsSettings(), clientContext);
        this.patchFirewallCallable = callableFactory.createUnaryCallable(patchFirewallTransportSettings, settings.patchFirewallSettings(), clientContext);
        this.updateFirewallCallable = callableFactory.createUnaryCallable(updateFirewallTransportSettings, settings.updateFirewallSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteFirewallHttpRequest, Operation> deleteFirewallCallable() {
        return this.deleteFirewallCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetFirewallHttpRequest, Firewall> getFirewallCallable() {
        return this.getFirewallCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertFirewallHttpRequest, Operation> insertFirewallCallable() {
        return this.insertFirewallCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListFirewallsHttpRequest, FirewallClient.ListFirewallsPagedResponse> listFirewallsPagedCallable() {
        return this.listFirewallsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListFirewallsHttpRequest, FirewallList> listFirewallsCallable() {
        return this.listFirewallsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchFirewallHttpRequest, Operation> patchFirewallCallable() {
        return this.patchFirewallCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateFirewallHttpRequest, Operation> updateFirewallCallable() {
        return this.updateFirewallCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

