/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetTcpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalTargetTcpProxyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetBackendServiceTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetTcpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.TargetTcpProxySettings;
import com.google.cloud.compute.v1.stub.TargetTcpProxyStub;
import com.google.cloud.compute.v1.stub.TargetTcpProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TargetTcpProxyClient
implements BackgroundResource {
    private final TargetTcpProxySettings settings;
    private final TargetTcpProxyStub stub;

    public static final TargetTcpProxyClient create() throws IOException {
        return TargetTcpProxyClient.create(TargetTcpProxySettings.newBuilder().build());
    }

    public static final TargetTcpProxyClient create(TargetTcpProxySettings settings) throws IOException {
        return new TargetTcpProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetTcpProxyClient create(TargetTcpProxyStub stub) {
        return new TargetTcpProxyClient(stub);
    }

    protected TargetTcpProxyClient(TargetTcpProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetTcpProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetTcpProxyClient(TargetTcpProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetTcpProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetTcpProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteTargetTcpProxy(ProjectGlobalTargetTcpProxyName targetTcpProxy) {
        DeleteTargetTcpProxyHttpRequest request = DeleteTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy == null ? null : targetTcpProxy.toString()).build();
        return this.deleteTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetTcpProxy(String targetTcpProxy) {
        DeleteTargetTcpProxyHttpRequest request = DeleteTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy).build();
        return this.deleteTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation deleteTargetTcpProxy(DeleteTargetTcpProxyHttpRequest request) {
        return (Operation)this.deleteTargetTcpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteTargetTcpProxyHttpRequest, Operation> deleteTargetTcpProxyCallable() {
        return this.stub.deleteTargetTcpProxyCallable();
    }

    @BetaApi
    public final TargetTcpProxy getTargetTcpProxy(ProjectGlobalTargetTcpProxyName targetTcpProxy) {
        GetTargetTcpProxyHttpRequest request = GetTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy == null ? null : targetTcpProxy.toString()).build();
        return this.getTargetTcpProxy(request);
    }

    @BetaApi
    public final TargetTcpProxy getTargetTcpProxy(String targetTcpProxy) {
        GetTargetTcpProxyHttpRequest request = GetTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy).build();
        return this.getTargetTcpProxy(request);
    }

    @BetaApi
    public final TargetTcpProxy getTargetTcpProxy(GetTargetTcpProxyHttpRequest request) {
        return (TargetTcpProxy)this.getTargetTcpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetTargetTcpProxyHttpRequest, TargetTcpProxy> getTargetTcpProxyCallable() {
        return this.stub.getTargetTcpProxyCallable();
    }

    @BetaApi
    public final Operation insertTargetTcpProxy(ProjectName project, TargetTcpProxy targetTcpProxyResource) {
        InsertTargetTcpProxyHttpRequest request = InsertTargetTcpProxyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setTargetTcpProxyResource(targetTcpProxyResource).build();
        return this.insertTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation insertTargetTcpProxy(String project, TargetTcpProxy targetTcpProxyResource) {
        InsertTargetTcpProxyHttpRequest request = InsertTargetTcpProxyHttpRequest.newBuilder().setProject(project).setTargetTcpProxyResource(targetTcpProxyResource).build();
        return this.insertTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation insertTargetTcpProxy(InsertTargetTcpProxyHttpRequest request) {
        return (Operation)this.insertTargetTcpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertTargetTcpProxyHttpRequest, Operation> insertTargetTcpProxyCallable() {
        return this.stub.insertTargetTcpProxyCallable();
    }

    @BetaApi
    public final ListTargetTcpProxiesPagedResponse listTargetTcpProxies(ProjectName project) {
        ListTargetTcpProxiesHttpRequest request = ListTargetTcpProxiesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTargetTcpProxies(request);
    }

    @BetaApi
    public final ListTargetTcpProxiesPagedResponse listTargetTcpProxies(String project) {
        ListTargetTcpProxiesHttpRequest request = ListTargetTcpProxiesHttpRequest.newBuilder().setProject(project).build();
        return this.listTargetTcpProxies(request);
    }

    @BetaApi
    public final ListTargetTcpProxiesPagedResponse listTargetTcpProxies(ListTargetTcpProxiesHttpRequest request) {
        return (ListTargetTcpProxiesPagedResponse)((Object)this.listTargetTcpProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListTargetTcpProxiesHttpRequest, ListTargetTcpProxiesPagedResponse> listTargetTcpProxiesPagedCallable() {
        return this.stub.listTargetTcpProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList> listTargetTcpProxiesCallable() {
        return this.stub.listTargetTcpProxiesCallable();
    }

    @BetaApi
    public final Operation setBackendServiceTargetTcpProxy(ProjectGlobalTargetTcpProxyName targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest targetTcpProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetTcpProxyHttpRequest request = SetBackendServiceTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy == null ? null : targetTcpProxy.toString()).setTargetTcpProxiesSetBackendServiceRequestResource(targetTcpProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation setBackendServiceTargetTcpProxy(String targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest targetTcpProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetTcpProxyHttpRequest request = SetBackendServiceTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetBackendServiceRequestResource(targetTcpProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation setBackendServiceTargetTcpProxy(SetBackendServiceTargetTcpProxyHttpRequest request) {
        return (Operation)this.setBackendServiceTargetTcpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetBackendServiceTargetTcpProxyHttpRequest, Operation> setBackendServiceTargetTcpProxyCallable() {
        return this.stub.setBackendServiceTargetTcpProxyCallable();
    }

    @BetaApi
    public final Operation setProxyHeaderTargetTcpProxy(ProjectGlobalTargetTcpProxyName targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest targetTcpProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetTcpProxyHttpRequest request = SetProxyHeaderTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy == null ? null : targetTcpProxy.toString()).setTargetTcpProxiesSetProxyHeaderRequestResource(targetTcpProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation setProxyHeaderTargetTcpProxy(String targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest targetTcpProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetTcpProxyHttpRequest request = SetProxyHeaderTargetTcpProxyHttpRequest.newBuilder().setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetProxyHeaderRequestResource(targetTcpProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderTargetTcpProxy(request);
    }

    @BetaApi
    public final Operation setProxyHeaderTargetTcpProxy(SetProxyHeaderTargetTcpProxyHttpRequest request) {
        return (Operation)this.setProxyHeaderTargetTcpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetProxyHeaderTargetTcpProxyHttpRequest, Operation> setProxyHeaderTargetTcpProxyCallable() {
        return this.stub.setProxyHeaderTargetTcpProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetTcpProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy, ListTargetTcpProxiesPage, ListTargetTcpProxiesFixedSizeCollection> {
        private ListTargetTcpProxiesFixedSizeCollection(List<ListTargetTcpProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetTcpProxiesFixedSizeCollection createEmptyCollection() {
            return new ListTargetTcpProxiesFixedSizeCollection(null, 0);
        }

        protected ListTargetTcpProxiesFixedSizeCollection createCollection(List<ListTargetTcpProxiesPage> pages, int collectionSize) {
            return new ListTargetTcpProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetTcpProxiesPage
    extends AbstractPage<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy, ListTargetTcpProxiesPage> {
        private ListTargetTcpProxiesPage(PageContext<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            super(context, (Object)response);
        }

        private static ListTargetTcpProxiesPage createEmptyPage() {
            return new ListTargetTcpProxiesPage(null, null);
        }

        protected ListTargetTcpProxiesPage createPage(PageContext<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            return new ListTargetTcpProxiesPage(context, response);
        }

        public ApiFuture<ListTargetTcpProxiesPage> createPageAsync(PageContext<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetTcpProxiesPagedResponse
    extends AbstractPagedListResponse<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy, ListTargetTcpProxiesPage, ListTargetTcpProxiesFixedSizeCollection> {
        public static ApiFuture<ListTargetTcpProxiesPagedResponse> createAsync(PageContext<ListTargetTcpProxiesHttpRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            ApiFuture<ListTargetTcpProxiesPage> futurePage = ListTargetTcpProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTargetTcpProxiesPage, ListTargetTcpProxiesPagedResponse>(){

                public ListTargetTcpProxiesPagedResponse apply(ListTargetTcpProxiesPage input) {
                    return new ListTargetTcpProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetTcpProxiesPagedResponse(ListTargetTcpProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetTcpProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

