/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionInstanceGroupName
implements ResourceName {
    private final String instanceGroup;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/instanceGroups/{instanceGroup}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionInstanceGroupName(Builder builder) {
        this.instanceGroup = (String)Preconditions.checkNotNull((Object)builder.getInstanceGroup());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionInstanceGroupName of(String instanceGroup, String project, String region) {
        return ProjectRegionInstanceGroupName.newBuilder().setInstanceGroup(instanceGroup).setProject(project).setRegion(region).build();
    }

    public static String format(String instanceGroup, String project, String region) {
        return ProjectRegionInstanceGroupName.of(instanceGroup, project, region).toString();
    }

    public String getInstanceGroup() {
        return this.instanceGroup;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionInstanceGroupName projectRegionInstanceGroupName = this;
            synchronized (projectRegionInstanceGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instanceGroup", (Object)this.instanceGroup);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionInstanceGroupName> newFactory() {
        return new ResourceNameFactory<ProjectRegionInstanceGroupName>(){

            public ProjectRegionInstanceGroupName parse(String formattedString) {
                return ProjectRegionInstanceGroupName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionInstanceGroupName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionInstanceGroupName.parse: formattedString not in valid format");
        return ProjectRegionInstanceGroupName.of((String)matchMap.get("instanceGroup"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"instanceGroup", this.instanceGroup, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionInstanceGroupName) {
            ProjectRegionInstanceGroupName that = (ProjectRegionInstanceGroupName)o;
            return Objects.equals(this.instanceGroup, that.getInstanceGroup()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroup, this.project, this.region);
    }

    public static class Builder {
        private String instanceGroup;
        private String project;
        private String region;

        public String getInstanceGroup() {
            return this.instanceGroup;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setInstanceGroup(String instanceGroup) {
            this.instanceGroup = instanceGroup;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionInstanceGroupName projectRegionInstanceGroupName) {
            this.instanceGroup = projectRegionInstanceGroupName.instanceGroup;
            this.project = projectRegionInstanceGroupName.project;
            this.region = projectRegionInstanceGroupName.region;
        }

        public ProjectRegionInstanceGroupName build() {
            return new ProjectRegionInstanceGroupName(this);
        }
    }
}

