/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddInstancesInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.GetInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupList;
import com.google.cloud.compute.v1.InstanceGroupSettings;
import com.google.cloud.compute.v1.InstanceGroupsAddInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsListInstances;
import com.google.cloud.compute.v1.InstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsRemoveInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupsScopedList;
import com.google.cloud.compute.v1.InstanceGroupsSetNamedPortsRequest;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.ListInstancesInstanceGroupsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneInstanceGroupName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.RemoveInstancesInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.SetNamedPortsInstanceGroupHttpRequest;
import com.google.cloud.compute.v1.stub.InstanceGroupStub;
import com.google.cloud.compute.v1.stub.InstanceGroupStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstanceGroupClient
implements BackgroundResource {
    private final InstanceGroupSettings settings;
    private final InstanceGroupStub stub;

    public static final InstanceGroupClient create() throws IOException {
        return InstanceGroupClient.create(InstanceGroupSettings.newBuilder().build());
    }

    public static final InstanceGroupClient create(InstanceGroupSettings settings) throws IOException {
        return new InstanceGroupClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceGroupClient create(InstanceGroupStub stub) {
        return new InstanceGroupClient(stub);
    }

    protected InstanceGroupClient(InstanceGroupSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceGroupClient(InstanceGroupStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addInstancesInstanceGroup(ProjectZoneInstanceGroupName instanceGroup, InstanceGroupsAddInstancesRequest instanceGroupsAddInstancesRequestResource) {
        AddInstancesInstanceGroupHttpRequest request = AddInstancesInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setInstanceGroupsAddInstancesRequestResource(instanceGroupsAddInstancesRequestResource).build();
        return this.addInstancesInstanceGroup(request);
    }

    @BetaApi
    public final Operation addInstancesInstanceGroup(String instanceGroup, InstanceGroupsAddInstancesRequest instanceGroupsAddInstancesRequestResource) {
        AddInstancesInstanceGroupHttpRequest request = AddInstancesInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setInstanceGroupsAddInstancesRequestResource(instanceGroupsAddInstancesRequestResource).build();
        return this.addInstancesInstanceGroup(request);
    }

    @BetaApi
    public final Operation addInstancesInstanceGroup(AddInstancesInstanceGroupHttpRequest request) {
        return (Operation)this.addInstancesInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddInstancesInstanceGroupHttpRequest, Operation> addInstancesInstanceGroupCallable() {
        return this.stub.addInstancesInstanceGroupCallable();
    }

    @BetaApi
    public final AggregatedListInstanceGroupsPagedResponse aggregatedListInstanceGroups(Boolean includeAllScopes, ProjectName project) {
        AggregatedListInstanceGroupsHttpRequest request = AggregatedListInstanceGroupsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListInstanceGroups(request);
    }

    @BetaApi
    public final AggregatedListInstanceGroupsPagedResponse aggregatedListInstanceGroups(Boolean includeAllScopes, String project) {
        AggregatedListInstanceGroupsHttpRequest request = AggregatedListInstanceGroupsHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListInstanceGroups(request);
    }

    @BetaApi
    public final AggregatedListInstanceGroupsPagedResponse aggregatedListInstanceGroups(AggregatedListInstanceGroupsHttpRequest request) {
        return (AggregatedListInstanceGroupsPagedResponse)((Object)this.aggregatedListInstanceGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstanceGroupsHttpRequest, AggregatedListInstanceGroupsPagedResponse> aggregatedListInstanceGroupsPagedCallable() {
        return this.stub.aggregatedListInstanceGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList> aggregatedListInstanceGroupsCallable() {
        return this.stub.aggregatedListInstanceGroupsCallable();
    }

    @BetaApi
    public final Operation deleteInstanceGroup(ProjectZoneInstanceGroupName instanceGroup) {
        DeleteInstanceGroupHttpRequest request = DeleteInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).build();
        return this.deleteInstanceGroup(request);
    }

    @BetaApi
    public final Operation deleteInstanceGroup(String instanceGroup) {
        DeleteInstanceGroupHttpRequest request = DeleteInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).build();
        return this.deleteInstanceGroup(request);
    }

    @BetaApi
    public final Operation deleteInstanceGroup(DeleteInstanceGroupHttpRequest request) {
        return (Operation)this.deleteInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInstanceGroupHttpRequest, Operation> deleteInstanceGroupCallable() {
        return this.stub.deleteInstanceGroupCallable();
    }

    @BetaApi
    public final InstanceGroup getInstanceGroup(ProjectZoneInstanceGroupName instanceGroup) {
        GetInstanceGroupHttpRequest request = GetInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).build();
        return this.getInstanceGroup(request);
    }

    @BetaApi
    public final InstanceGroup getInstanceGroup(String instanceGroup) {
        GetInstanceGroupHttpRequest request = GetInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).build();
        return this.getInstanceGroup(request);
    }

    @BetaApi
    public final InstanceGroup getInstanceGroup(GetInstanceGroupHttpRequest request) {
        return (InstanceGroup)this.getInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInstanceGroupHttpRequest, InstanceGroup> getInstanceGroupCallable() {
        return this.stub.getInstanceGroupCallable();
    }

    @BetaApi
    public final Operation insertInstanceGroup(ProjectZoneName zone, InstanceGroup instanceGroupResource) {
        InsertInstanceGroupHttpRequest request = InsertInstanceGroupHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).setInstanceGroupResource(instanceGroupResource).build();
        return this.insertInstanceGroup(request);
    }

    @BetaApi
    public final Operation insertInstanceGroup(String zone, InstanceGroup instanceGroupResource) {
        InsertInstanceGroupHttpRequest request = InsertInstanceGroupHttpRequest.newBuilder().setZone(zone).setInstanceGroupResource(instanceGroupResource).build();
        return this.insertInstanceGroup(request);
    }

    @BetaApi
    public final Operation insertInstanceGroup(InsertInstanceGroupHttpRequest request) {
        return (Operation)this.insertInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInstanceGroupHttpRequest, Operation> insertInstanceGroupCallable() {
        return this.stub.insertInstanceGroupCallable();
    }

    @BetaApi
    public final ListInstanceGroupsPagedResponse listInstanceGroups(ProjectZoneName zone) {
        ListInstanceGroupsHttpRequest request = ListInstanceGroupsHttpRequest.newBuilder().setZone(zone == null ? null : zone.toString()).build();
        return this.listInstanceGroups(request);
    }

    @BetaApi
    public final ListInstanceGroupsPagedResponse listInstanceGroups(String zone) {
        ListInstanceGroupsHttpRequest request = ListInstanceGroupsHttpRequest.newBuilder().setZone(zone).build();
        return this.listInstanceGroups(request);
    }

    @BetaApi
    public final ListInstanceGroupsPagedResponse listInstanceGroups(ListInstanceGroupsHttpRequest request) {
        return (ListInstanceGroupsPagedResponse)((Object)this.listInstanceGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstanceGroupsHttpRequest, ListInstanceGroupsPagedResponse> listInstanceGroupsPagedCallable() {
        return this.stub.listInstanceGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstanceGroupsHttpRequest, InstanceGroupList> listInstanceGroupsCallable() {
        return this.stub.listInstanceGroupsCallable();
    }

    @BetaApi
    public final ListInstancesInstanceGroupsPagedResponse listInstancesInstanceGroups(ProjectZoneInstanceGroupName instanceGroup, InstanceGroupsListInstancesRequest instanceGroupsListInstancesRequestResource) {
        ListInstancesInstanceGroupsHttpRequest request = ListInstancesInstanceGroupsHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setInstanceGroupsListInstancesRequestResource(instanceGroupsListInstancesRequestResource).build();
        return this.listInstancesInstanceGroups(request);
    }

    @BetaApi
    public final ListInstancesInstanceGroupsPagedResponse listInstancesInstanceGroups(String instanceGroup, InstanceGroupsListInstancesRequest instanceGroupsListInstancesRequestResource) {
        ListInstancesInstanceGroupsHttpRequest request = ListInstancesInstanceGroupsHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setInstanceGroupsListInstancesRequestResource(instanceGroupsListInstancesRequestResource).build();
        return this.listInstancesInstanceGroups(request);
    }

    @BetaApi
    public final ListInstancesInstanceGroupsPagedResponse listInstancesInstanceGroups(ListInstancesInstanceGroupsHttpRequest request) {
        return (ListInstancesInstanceGroupsPagedResponse)((Object)this.listInstancesInstanceGroupsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstancesInstanceGroupsHttpRequest, ListInstancesInstanceGroupsPagedResponse> listInstancesInstanceGroupsPagedCallable() {
        return this.stub.listInstancesInstanceGroupsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances> listInstancesInstanceGroupsCallable() {
        return this.stub.listInstancesInstanceGroupsCallable();
    }

    @BetaApi
    public final Operation removeInstancesInstanceGroup(ProjectZoneInstanceGroupName instanceGroup, InstanceGroupsRemoveInstancesRequest instanceGroupsRemoveInstancesRequestResource) {
        RemoveInstancesInstanceGroupHttpRequest request = RemoveInstancesInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setInstanceGroupsRemoveInstancesRequestResource(instanceGroupsRemoveInstancesRequestResource).build();
        return this.removeInstancesInstanceGroup(request);
    }

    @BetaApi
    public final Operation removeInstancesInstanceGroup(String instanceGroup, InstanceGroupsRemoveInstancesRequest instanceGroupsRemoveInstancesRequestResource) {
        RemoveInstancesInstanceGroupHttpRequest request = RemoveInstancesInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setInstanceGroupsRemoveInstancesRequestResource(instanceGroupsRemoveInstancesRequestResource).build();
        return this.removeInstancesInstanceGroup(request);
    }

    @BetaApi
    public final Operation removeInstancesInstanceGroup(RemoveInstancesInstanceGroupHttpRequest request) {
        return (Operation)this.removeInstancesInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemoveInstancesInstanceGroupHttpRequest, Operation> removeInstancesInstanceGroupCallable() {
        return this.stub.removeInstancesInstanceGroupCallable();
    }

    @BetaApi
    public final Operation setNamedPortsInstanceGroup(ProjectZoneInstanceGroupName instanceGroup, InstanceGroupsSetNamedPortsRequest instanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsInstanceGroupHttpRequest request = SetNamedPortsInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup == null ? null : instanceGroup.toString()).setInstanceGroupsSetNamedPortsRequestResource(instanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPortsInstanceGroup(request);
    }

    @BetaApi
    public final Operation setNamedPortsInstanceGroup(String instanceGroup, InstanceGroupsSetNamedPortsRequest instanceGroupsSetNamedPortsRequestResource) {
        SetNamedPortsInstanceGroupHttpRequest request = SetNamedPortsInstanceGroupHttpRequest.newBuilder().setInstanceGroup(instanceGroup).setInstanceGroupsSetNamedPortsRequestResource(instanceGroupsSetNamedPortsRequestResource).build();
        return this.setNamedPortsInstanceGroup(request);
    }

    @BetaApi
    public final Operation setNamedPortsInstanceGroup(SetNamedPortsInstanceGroupHttpRequest request) {
        return (Operation)this.setNamedPortsInstanceGroupCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetNamedPortsInstanceGroupHttpRequest, Operation> setNamedPortsInstanceGroupCallable() {
        return this.stub.setNamedPortsInstanceGroupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesInstanceGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesInstanceGroupsPage, ListInstancesInstanceGroupsFixedSizeCollection> {
        private ListInstancesInstanceGroupsFixedSizeCollection(List<ListInstancesInstanceGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesInstanceGroupsFixedSizeCollection createEmptyCollection() {
            return new ListInstancesInstanceGroupsFixedSizeCollection(null, 0);
        }

        protected ListInstancesInstanceGroupsFixedSizeCollection createCollection(List<ListInstancesInstanceGroupsPage> pages, int collectionSize) {
            return new ListInstancesInstanceGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesInstanceGroupsPage
    extends AbstractPage<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesInstanceGroupsPage> {
        private ListInstancesInstanceGroupsPage(PageContext<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, InstanceGroupsListInstances response) {
            super(context, (Object)response);
        }

        private static ListInstancesInstanceGroupsPage createEmptyPage() {
            return new ListInstancesInstanceGroupsPage(null, null);
        }

        protected ListInstancesInstanceGroupsPage createPage(PageContext<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, InstanceGroupsListInstances response) {
            return new ListInstancesInstanceGroupsPage(context, response);
        }

        public ApiFuture<ListInstancesInstanceGroupsPage> createPageAsync(PageContext<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesInstanceGroupsPagedResponse
    extends AbstractPagedListResponse<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts, ListInstancesInstanceGroupsPage, ListInstancesInstanceGroupsFixedSizeCollection> {
        public static ApiFuture<ListInstancesInstanceGroupsPagedResponse> createAsync(PageContext<ListInstancesInstanceGroupsHttpRequest, InstanceGroupsListInstances, InstanceWithNamedPorts> context, ApiFuture<InstanceGroupsListInstances> futureResponse) {
            ApiFuture<ListInstancesInstanceGroupsPage> futurePage = ListInstancesInstanceGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesInstanceGroupsPage, ListInstancesInstanceGroupsPagedResponse>(){

                public ListInstancesInstanceGroupsPagedResponse apply(ListInstancesInstanceGroupsPage input) {
                    return new ListInstancesInstanceGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesInstanceGroupsPagedResponse(ListInstancesInstanceGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesInstanceGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstanceGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup, ListInstanceGroupsPage, ListInstanceGroupsFixedSizeCollection> {
        private ListInstanceGroupsFixedSizeCollection(List<ListInstanceGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceGroupsFixedSizeCollection createEmptyCollection() {
            return new ListInstanceGroupsFixedSizeCollection(null, 0);
        }

        protected ListInstanceGroupsFixedSizeCollection createCollection(List<ListInstanceGroupsPage> pages, int collectionSize) {
            return new ListInstanceGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceGroupsPage
    extends AbstractPage<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup, ListInstanceGroupsPage> {
        private ListInstanceGroupsPage(PageContext<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup> context, InstanceGroupList response) {
            super(context, (Object)response);
        }

        private static ListInstanceGroupsPage createEmptyPage() {
            return new ListInstanceGroupsPage(null, null);
        }

        protected ListInstanceGroupsPage createPage(PageContext<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup> context, InstanceGroupList response) {
            return new ListInstanceGroupsPage(context, response);
        }

        public ApiFuture<ListInstanceGroupsPage> createPageAsync(PageContext<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup> context, ApiFuture<InstanceGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceGroupsPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup, ListInstanceGroupsPage, ListInstanceGroupsFixedSizeCollection> {
        public static ApiFuture<ListInstanceGroupsPagedResponse> createAsync(PageContext<ListInstanceGroupsHttpRequest, InstanceGroupList, InstanceGroup> context, ApiFuture<InstanceGroupList> futureResponse) {
            ApiFuture<ListInstanceGroupsPage> futurePage = ListInstanceGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstanceGroupsPage, ListInstanceGroupsPagedResponse>(){

                public ListInstanceGroupsPagedResponse apply(ListInstanceGroupsPage input) {
                    return new ListInstanceGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstanceGroupsPagedResponse(ListInstanceGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListInstanceGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList, AggregatedListInstanceGroupsPage, AggregatedListInstanceGroupsFixedSizeCollection> {
        private AggregatedListInstanceGroupsFixedSizeCollection(List<AggregatedListInstanceGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListInstanceGroupsFixedSizeCollection createEmptyCollection() {
            return new AggregatedListInstanceGroupsFixedSizeCollection(null, 0);
        }

        protected AggregatedListInstanceGroupsFixedSizeCollection createCollection(List<AggregatedListInstanceGroupsPage> pages, int collectionSize) {
            return new AggregatedListInstanceGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListInstanceGroupsPage
    extends AbstractPage<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList, AggregatedListInstanceGroupsPage> {
        private AggregatedListInstanceGroupsPage(PageContext<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList> context, InstanceGroupAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListInstanceGroupsPage createEmptyPage() {
            return new AggregatedListInstanceGroupsPage(null, null);
        }

        protected AggregatedListInstanceGroupsPage createPage(PageContext<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList> context, InstanceGroupAggregatedList response) {
            return new AggregatedListInstanceGroupsPage(context, response);
        }

        public ApiFuture<AggregatedListInstanceGroupsPage> createPageAsync(PageContext<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList> context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListInstanceGroupsPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList, AggregatedListInstanceGroupsPage, AggregatedListInstanceGroupsFixedSizeCollection> {
        public static ApiFuture<AggregatedListInstanceGroupsPagedResponse> createAsync(PageContext<AggregatedListInstanceGroupsHttpRequest, InstanceGroupAggregatedList, InstanceGroupsScopedList> context, ApiFuture<InstanceGroupAggregatedList> futureResponse) {
            ApiFuture<AggregatedListInstanceGroupsPage> futurePage = AggregatedListInstanceGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListInstanceGroupsPage, AggregatedListInstanceGroupsPagedResponse>(){

                public AggregatedListInstanceGroupsPagedResponse apply(AggregatedListInstanceGroupsPage input) {
                    return new AggregatedListInstanceGroupsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListInstanceGroupsPagedResponse(AggregatedListInstanceGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListInstanceGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

