/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListVpnGatewaysHttpRequest;
import com.google.cloud.compute.v1.DeleteVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.GetStatusVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.GetVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.InsertVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.ListVpnGatewaysHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetLabelsVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsVpnGatewayHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.VpnGateway;
import com.google.cloud.compute.v1.VpnGatewayAggregatedList;
import com.google.cloud.compute.v1.VpnGatewayClient;
import com.google.cloud.compute.v1.VpnGatewayList;
import com.google.cloud.compute.v1.VpnGatewaysGetStatusResponse;
import com.google.cloud.compute.v1.VpnGatewaysScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonVpnGatewayStub;
import com.google.cloud.compute.v1.stub.VpnGatewayStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class VpnGatewayStubSettings
extends StubSettings<VpnGatewayStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> aggregatedListVpnGatewaysSettings;
    private final UnaryCallSettings<DeleteVpnGatewayHttpRequest, Operation> deleteVpnGatewaySettings;
    private final UnaryCallSettings<GetVpnGatewayHttpRequest, VpnGateway> getVpnGatewaySettings;
    private final UnaryCallSettings<GetStatusVpnGatewayHttpRequest, VpnGatewaysGetStatusResponse> getStatusVpnGatewaySettings;
    private final UnaryCallSettings<InsertVpnGatewayHttpRequest, Operation> insertVpnGatewaySettings;
    private final PagedCallSettings<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse> listVpnGatewaysSettings;
    private final UnaryCallSettings<SetLabelsVpnGatewayHttpRequest, Operation> setLabelsVpnGatewaySettings;
    private final UnaryCallSettings<TestIamPermissionsVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsVpnGatewaySettings;
    private static final PagedListDescriptor<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewaysScopedList> AGGREGATED_LIST_VPN_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewaysScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListVpnGatewaysHttpRequest injectToken(AggregatedListVpnGatewaysHttpRequest payload, String token) {
            return AggregatedListVpnGatewaysHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListVpnGatewaysHttpRequest injectPageSize(AggregatedListVpnGatewaysHttpRequest payload, int pageSize) {
            return AggregatedListVpnGatewaysHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListVpnGatewaysHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(VpnGatewayAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VpnGatewaysScopedList> extractResources(VpnGatewayAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGateway> LIST_VPN_GATEWAYS_PAGE_STR_DESC = new PagedListDescriptor<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGateway>(){

        public String emptyToken() {
            return "";
        }

        public ListVpnGatewaysHttpRequest injectToken(ListVpnGatewaysHttpRequest payload, String token) {
            return ListVpnGatewaysHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListVpnGatewaysHttpRequest injectPageSize(ListVpnGatewaysHttpRequest payload, int pageSize) {
            return ListVpnGatewaysHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListVpnGatewaysHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(VpnGatewayList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VpnGateway> extractResources(VpnGatewayList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> AGGREGATED_LIST_VPN_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse>(){

        public ApiFuture<VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList> callable, AggregatedListVpnGatewaysHttpRequest request, ApiCallContext context, ApiFuture<VpnGatewayAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_VPN_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse.createAsync((PageContext<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewaysScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse> LIST_VPN_GATEWAYS_PAGE_STR_FACT = new PagedListResponseFactory<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse>(){

        public ApiFuture<VpnGatewayClient.ListVpnGatewaysPagedResponse> getFuturePagedResponse(UnaryCallable<ListVpnGatewaysHttpRequest, VpnGatewayList> callable, ListVpnGatewaysHttpRequest request, ApiCallContext context, ApiFuture<VpnGatewayList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VPN_GATEWAYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VpnGatewayClient.ListVpnGatewaysPagedResponse.createAsync((PageContext<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGateway>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> aggregatedListVpnGatewaysSettings() {
        return this.aggregatedListVpnGatewaysSettings;
    }

    public UnaryCallSettings<DeleteVpnGatewayHttpRequest, Operation> deleteVpnGatewaySettings() {
        return this.deleteVpnGatewaySettings;
    }

    public UnaryCallSettings<GetVpnGatewayHttpRequest, VpnGateway> getVpnGatewaySettings() {
        return this.getVpnGatewaySettings;
    }

    public UnaryCallSettings<GetStatusVpnGatewayHttpRequest, VpnGatewaysGetStatusResponse> getStatusVpnGatewaySettings() {
        return this.getStatusVpnGatewaySettings;
    }

    public UnaryCallSettings<InsertVpnGatewayHttpRequest, Operation> insertVpnGatewaySettings() {
        return this.insertVpnGatewaySettings;
    }

    public PagedCallSettings<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse> listVpnGatewaysSettings() {
        return this.listVpnGatewaysSettings;
    }

    public UnaryCallSettings<SetLabelsVpnGatewayHttpRequest, Operation> setLabelsVpnGatewaySettings() {
        return this.setLabelsVpnGatewaySettings;
    }

    public UnaryCallSettings<TestIamPermissionsVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsVpnGatewaySettings() {
        return this.testIamPermissionsVpnGatewaySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpnGatewayStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonVpnGatewayStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VpnGatewayStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VpnGatewayStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VpnGatewayStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListVpnGatewaysSettings = settingsBuilder.aggregatedListVpnGatewaysSettings().build();
        this.deleteVpnGatewaySettings = settingsBuilder.deleteVpnGatewaySettings().build();
        this.getVpnGatewaySettings = settingsBuilder.getVpnGatewaySettings().build();
        this.getStatusVpnGatewaySettings = settingsBuilder.getStatusVpnGatewaySettings().build();
        this.insertVpnGatewaySettings = settingsBuilder.insertVpnGatewaySettings().build();
        this.listVpnGatewaysSettings = settingsBuilder.listVpnGatewaysSettings().build();
        this.setLabelsVpnGatewaySettings = settingsBuilder.setLabelsVpnGatewaySettings().build();
        this.testIamPermissionsVpnGatewaySettings = settingsBuilder.testIamPermissionsVpnGatewaySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VpnGatewayStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> aggregatedListVpnGatewaysSettings;
        private final UnaryCallSettings.Builder<DeleteVpnGatewayHttpRequest, Operation> deleteVpnGatewaySettings;
        private final UnaryCallSettings.Builder<GetVpnGatewayHttpRequest, VpnGateway> getVpnGatewaySettings;
        private final UnaryCallSettings.Builder<GetStatusVpnGatewayHttpRequest, VpnGatewaysGetStatusResponse> getStatusVpnGatewaySettings;
        private final UnaryCallSettings.Builder<InsertVpnGatewayHttpRequest, Operation> insertVpnGatewaySettings;
        private final PagedCallSettings.Builder<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse> listVpnGatewaysSettings;
        private final UnaryCallSettings.Builder<SetLabelsVpnGatewayHttpRequest, Operation> setLabelsVpnGatewaySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsVpnGatewaySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListVpnGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_VPN_GATEWAYS_PAGE_STR_FACT);
            this.deleteVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getStatusVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVpnGatewaysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VPN_GATEWAYS_PAGE_STR_FACT);
            this.setLabelsVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsVpnGatewaySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListVpnGatewaysSettings, this.deleteVpnGatewaySettings, this.getVpnGatewaySettings, this.getStatusVpnGatewaySettings, this.insertVpnGatewaySettings, this.listVpnGatewaysSettings, this.setLabelsVpnGatewaySettings, this.testIamPermissionsVpnGatewaySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VpnGatewayStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VpnGatewayStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VpnGatewayStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(VpnGatewayStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListVpnGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getStatusVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listVpnGatewaysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsVpnGatewaySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(VpnGatewayStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListVpnGatewaysSettings = settings.aggregatedListVpnGatewaysSettings.toBuilder();
            this.deleteVpnGatewaySettings = settings.deleteVpnGatewaySettings.toBuilder();
            this.getVpnGatewaySettings = settings.getVpnGatewaySettings.toBuilder();
            this.getStatusVpnGatewaySettings = settings.getStatusVpnGatewaySettings.toBuilder();
            this.insertVpnGatewaySettings = settings.insertVpnGatewaySettings.toBuilder();
            this.listVpnGatewaysSettings = settings.listVpnGatewaysSettings.toBuilder();
            this.setLabelsVpnGatewaySettings = settings.setLabelsVpnGatewaySettings.toBuilder();
            this.testIamPermissionsVpnGatewaySettings = settings.testIamPermissionsVpnGatewaySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListVpnGatewaysSettings, this.deleteVpnGatewaySettings, this.getVpnGatewaySettings, this.getStatusVpnGatewaySettings, this.insertVpnGatewaySettings, this.listVpnGatewaysSettings, this.setLabelsVpnGatewaySettings, this.testIamPermissionsVpnGatewaySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListVpnGatewaysHttpRequest, VpnGatewayAggregatedList, VpnGatewayClient.AggregatedListVpnGatewaysPagedResponse> aggregatedListVpnGatewaysSettings() {
            return this.aggregatedListVpnGatewaysSettings;
        }

        public UnaryCallSettings.Builder<DeleteVpnGatewayHttpRequest, Operation> deleteVpnGatewaySettings() {
            return this.deleteVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<GetVpnGatewayHttpRequest, VpnGateway> getVpnGatewaySettings() {
            return this.getVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<GetStatusVpnGatewayHttpRequest, VpnGatewaysGetStatusResponse> getStatusVpnGatewaySettings() {
            return this.getStatusVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<InsertVpnGatewayHttpRequest, Operation> insertVpnGatewaySettings() {
            return this.insertVpnGatewaySettings;
        }

        public PagedCallSettings.Builder<ListVpnGatewaysHttpRequest, VpnGatewayList, VpnGatewayClient.ListVpnGatewaysPagedResponse> listVpnGatewaysSettings() {
            return this.listVpnGatewaysSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsVpnGatewayHttpRequest, Operation> setLabelsVpnGatewaySettings() {
            return this.setLabelsVpnGatewaySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsVpnGatewayHttpRequest, TestPermissionsResponse> testIamPermissionsVpnGatewaySettings() {
            return this.testIamPermissionsVpnGatewaySettings;
        }

        public VpnGatewayStubSettings build() throws IOException {
            return new VpnGatewayStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

